/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * Check permissions on the PBS Tree Built
 *
 *	Files should be owned by root, and not world writable.
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include "portability.h"
#include "log.h"

static char ident[] = "@(#) $RCSfile: chk_tree.c,v $ $Revision: 2.1 $";

char *msg_daemonname = 0;	/* to satisfy the Cray linker */
main(argc, argv)
	int argc;
	char *argv[];
{
	int err = 0;
	int i;
	int j;
	int chk_file_sec();
	int dir = 0;
	int no_err = 0;
	int sticky = 0;
	extern int optind;


	while ((i = getopt(argc, argv, "dns")) != EOF) {
	    switch (i) {
		case 'd': dir = 1;
			  break;
		case 'n': no_err = 1;
			  break;
		case 's': sticky = 1;
			  break;
		default: err = 1;
	    }
	}

	if (err || (optind == argc)) {
		fprintf(stderr, "Usage %s -d -s -n path ...\n\twhere:\t-d indicates directory (file otherwise)\n\t\t-s indicates world write allowed if sticky set\n\t\t-n indicates do not return the error status, exit with 0\n", argv[0]);
		return 1;
	}

	for (i=optind; i < argc; ++i)
		if (j=chk_file_sec(argv[i], dir, sticky, S_IWGRP|S_IWOTH, 1)) {
			err=1;
		}

	if (no_err)
		return 0;
	else
		return (err);
}

/*
 * log_err - for this utility, write to stderr rather than logging.
 */

void log_err(rc, routine, text)
	int  rc;
	char *routine;
	char *text;
{
	fprintf(stdout, "chk_tree: %s: error #%d: (%s)\n", text, rc,
		strerror(rc) ? strerror(rc) : "UNKNOWN");
}
