/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <string.h>

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#if !defined(H_ERRNO_DECLARED)
extern int h_errno;
#endif


void usage(name)
	char *name;
{
		fprintf(stderr, "Usage: %s [-v] hostname\n", name);
		fprintf(stderr, "\t -v turns on verbose output\n");
}

main(argc, argv, env)
	int argc;
	char *argv[];
	char *env[];
{
	int i;
	struct hostent *host;
	struct hostent *hosta;
	struct in_addr *ina;
	int		naddr;
	int		vflag = 0;
	void prt_herrno();
	extern int optind;

	while ((i = getopt(argc, argv, "v")) != EOF) {
		switch (i) {
		    case 'v':	vflag = 1;
				break;
		    default:
				usage(argv[0]);
				return 1;
		}
	}

	if (optind != argc-1) {
		usage(argv[0]);
		return 1;
	}

	h_errno = 0;

	i = 0;
	while (env[i]) {
		if (!strncmp(env[i], "LOCALDOMAIN", 11)) {
			printf("%s\n", env[i]);
			env[i] = "";
			break;
		}
		++i;
	}

	host = gethostbyname(argv[optind]);
	if (host) {
		printf("primary name:  %s", host->h_name);
		if (vflag)
			 printf(" (from gethostbyname())");
		printf("\n");
		if (host->h_aliases && *host->h_aliases) {
			for (i=0; host->h_aliases[i]; ++i)
				printf("aliases:           %s\n",
					host->h_aliases[i]);
		} else if (vflag) {
			printf("aliases:            -none-\n");
		}

		if (vflag)
			printf("     address length:  %d bytes\n", host->h_length);

		/* need to save address because they will be over writen on */
		/* next call to gethostby*()				    */

		naddr = 0;
		for (i=0; host->h_addr_list[i]; ++i) {
			++naddr;
		}
		ina = (struct in_addr *)malloc(sizeof (struct in_addr) * naddr);
		
		for (i=0; i<naddr; ++i) {
			(void)memcpy((char *)(ina+i), host->h_addr_list[i],
						   host->h_length);
		}
		for (i=0; i<naddr; ++i) {
			printf("     address:      %15.15s  ", inet_ntoa(*(ina+i)));
			if (vflag)
				printf(" (%u dec)  ", (int)(ina+i)->s_addr);
		
			h_errno = 0;
			hosta = gethostbyaddr((char *)(ina+i), host->h_length,
							    host->h_addrtype);
			if (hosta) {
				printf("name:  %s", host->h_name);
			} else {
				printf("name:  -null-");
				prt_herrno();
			}
			printf("\n");
		}

	} else {
		printf("no name entry found for %s\n", argv[optind]);
		prt_herrno();
	}
	return 0;
}

void prt_herrno()
{
	char *txt;

	switch (h_errno) {
		case 0:
			return;

		case HOST_NOT_FOUND:
			txt = "Answer Host Not Found";
			break;

		case TRY_AGAIN:
			txt = "Try Again";
			break;

		case NO_RECOVERY:
			txt = "No Recovery";
			break;

		case NO_DATA:
			txt = "No Data";
			break;

		default:	
			txt = "unknown error";
			break;
	}
	printf(" ** h_errno is %d %s\n", h_errno, txt);
}
