/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/


#ifndef TRACEJOB_H
#define TRACEJOB_H

/* Symbolic constants */

/* default number of columns on a terminal */
#ifndef DEFAULT_WRAP
#define DEFAULT_WRAP 80
#endif

/*
 * filter excessive log entires
 */
#ifndef FILTER_EXCESSIVE
#define FILTER_EXCESSIVE
#endif

/* if filter excessive if turned on and there are at least this many 
 * log entires, its considered is considered excessive
 */
#ifndef EXCESSIVE_COUNT 
#define EXCESSIVE_COUNT 15
#endif
 
/* number of entries to start */
#ifndef DEFAULT_LOG_LINES
#define DEFAULT_LOG_LINES 1024
#endif
 
#define SECONDS_IN_DAY 86400
 
/* indicies into the mid_path array */
enum index
{
  IND_ACCT = 0,
  IND_SERVER = 1,
  IND_MOM = 2,
  IND_SCHED = 3
};
 
/* fields of a log entry */
enum field
{
  FLD_DATE = 0,
  FLD_EVENT = 1,
  FLD_OBJ = 2,
  FLD_TYPE = 3,
  FLD_NAME = 4,
  FLD_MSG = 5
};

/* A PBS log entry */
struct log_entry
{
  char *date;           /* date of log entry */
  time_t date_time;     /* number of seconds from the epoch to date */
  char *event;          /* event type */
  char *obj;            /* what entity is writing the log */
  char *type;           /* type of object Job/Svr/etc */
  char *name;           /* name of object */
  char *msg;            /* log message */
  char log_file;        /* What log file */
  int lineno;		/* what line in the file.  used to stabilize the sort */
  unsigned no_print:1;	/* whether or not to print the message */
  /* A=accounting S=server M=Mom L=Scheduler */
};
 
/* prototypes */
int sort_by_date( const void *v1, const void *v2 );
void parse_log(FILE *fp, char *job, int act);
char *strip_path( char *path );
void free_log_entry( struct log_entry *lg );
void line_wrap(char *line, int start, int end);
char *log_path( char *path, int index, struct tm *tm_ptr );
void alloc_more_space();
void filter_excess( int threshold );
int sort_by_message( const void *v1, const void *v2 );


/* used by getopt(3) */
extern char *optarg;
extern int optind;

#endif
