.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.IP Account 15
is an arbitrary character string which may have meaning to
one or more hosts in the batch system.  Frequently, account
is used as a grouping for charging for the use of resources.
.IP Administrator 15
See Manager.
.IP Attribute 15
is an inherent characteristic of the parent object.  Typically, this is a
data item whose value affects the operation or behavior of the object and
is settable by owner of the object.  For example, the user may supply values
for attributes of a job.
.IP Batch 15
or batch processing, is the capability of running
.I jobs
outside of the interactive login session.  
In this document, batch implies a more complex subsystem
which provides for additional control over job scheduling and
resource contention.
.IP "Batch Server" 15
is a persistent subsystem (daemon) upon a single host which provides batch
processing capability.
.IP "Batch System" 15
is a set of batch servers that are configured
for processing.  The system may consist of multiple hosts, each with
multiple servers.
.IP Cluster
A complex made up of cluster nodes.
.IP Complex 15
A collection of nodes managed by one batch system.  A complex may be made up
of nodes that are allocated to only one job at a time or of nodes that have
many jobs executing on each at once or a combination of both.
A complex may be made up of a set of workstations,
multiple cpu systems, or one or more parallel systems.  
.IP
A queue complex in NQS was a set of queues within a batch server.
The purpose of a complex was to provide additional control over resource usage.
The advanced scheduling features of PBS eliminates the requirement for
queue complexes.
.IP "Cluster Node"
.mc |
A node whose allocation units (Virtual processors) are allocated specifically
to one job at a time (see .I "exclusive node" ), or a few jobs (see
.I "temporarily-shared nodes" ).
This type of node may also be called
.I "space shared" .
Hosts that are timeshared among many jobs are called \*Qtimeshared.\*U
.IP
In prior versions of PBS, the entire node was allocated to a job.  In this
version, one or more virtual processors (see definition in this glossary) may
be declared.   Each virtual processor is allocated as an independent unit.
.mc
.IP Destination 15
is the location within the batch system where the job is
sent for processing or executing.  IN PBS, a destination may uniquely
define a single
queue at a single batch server or it may map into many locations.
.IP "Destination Identifier " 15
is a string which names the destination.  It is in two parts and has the
format
.DS C
queue@server
.DE
where server is the name of a batch server and queue is the string identifying
a queue on that server.
.IP "Exclusive Nodes"
.mc |
An exclusive node is one whose virtual processors are used by one and only one
job at a time.  The processors of a
set of nodes is assigned exclusively to a job for the duration of that job.
This is typically done to improve the performance of message passing programs.
.mc
.IP "Temporarily-shared Nodes"
.mc |
A
.I "temporarily-shared node"
is one in which one or more of the virtual processors are temporarily shared
by multiple jobs.
.mc
If several jobs request
multiple temporarily-shared nodes, some nodes may be allocated
commonly to both job and some may be unique to one of the jobs.
When a node is allocated as a temporarily-shared node, it remains so until
all jobs using it are terminated.  Then
the node may be next allocated again for temporarily-shared use or for
exclusive use.
.IP "File Staging" 15
is the movement of files between a specified location and the execution
host.
See "Stage In" and "Stage Out" .
.IP Group 15
is a collection of system users (see Users).
A user must be a member of a group and may be a member of more than one.
Within Unix and POSIX systems, membership in a group establishes one
level of privilege.  Group membership is also often used to control or
limit access to system resources.
.IP Hold 15
is an artificial restriction which prevents a job from being selected for
processing.  There are three types of holds,
.Av User
which is applied by the job owner,
.Av Other
(or operator) which is applied by the batch operator or administrator, and
.Av System
which is applied by the system itself or the batch system administrator.
.IP Job 15
or 
.I "batch job"
is the basic execution object managed by the batch subsystem.  A job is a
collection of related processes which is managed as a whole.  A job can
often be thought of as a shell script.
In POSIX terms, a job is a session group.  A session is a  processes group
the member processes cannot leave.
.IP Manager 15
or Batch System Manager is a person authorized to use all restricted
capabilities of the batch system.  The manager may act upon the
the batch system, queues, or jobs.  Also called the administrator.
.IP Node 15
Within PBS, the term Node is used to mean a computational unit, one or more of
which can be allocated to a job in a shared or exclusive manner.  A node is
characterized by (a) one or more virtual processors, (b)a unique memory address
space, (c) and operating system
image, (d) one or more IP addresses, and (e) a PBS execution server (pbs_mom).
.mc |
In prior versions of PBS, a node could only be allocated as a whole.  Starting
with version 2.2, pieces of a node, called virtual processors, VPs, may be 
defined and allocated individually.   This is typically done where the node
is a Shared Multiple Processor, SMP, system.   References to allocating a 
.I node
may still be found and should be taken to mean allocating a virtual processor.
If a node only has one virtual processor defined, then of course, allocating
that processor is synonymous with allocating the node itself.
.IP
If VPs on a set of nodes are allocated in an
.I exclusive
manner to a job, no other job may use that set of processors during the
execution
of the job to which the nodes are assigned.   This is often called
.I "Space Sharing"
If a set of VPs on a set nodes are allocated in a
.I shared
manner, multiple jobs may have processes executing on the set at the same
time.
.mc
.IP Operator 15
or Batch Operator is a person authorized to use some but not all of the
restricted capabilities of the batch system.
.IP Owner 15
of a job is the user who submitted the job to the batch system.
.IP PBS 15
is short for
.I "Portable Batch System" .
.IP POSIX 15
refers to the various standards being developed by the "Technical
Committee on Operating Systems and Application Environments of the IEEE
Computer Society" under standard  P1003.  There are a number of
subcommittees under POSIX, those of interest to this project were:
.RS 15
.IP POSIX.1 10
System Application Program Interface (the system calls).
.IP POSIX.2 10
The command shell language.
.IP POSIX.3 10
Test Methods
.IP POSIX.10 10
Super Computing Profile
.IP POSIX.12 10
Protocol Independent Interfaces (one of the many network working groups)
.IP POSIX.14 10
Multiprocessor Working Group
.IP POSIX.15 10
Batch Queuing Extensions.  This standard has been approved as 1003.2d and
is the basis of the PBS external design.
.RE
.IP Queue 15
is a collection of jobs (or job related tasks) within the
batch queuing system.
Each queue has a set of associated attributes which
determine what actions are performed upon each job  within the queue. 
Typical attributes include queue name, queue priority, resource limits,
destination(s) and job count limits.
Selection/scheduling of jobs is implementation defined.  The use of the
term "queue" does not imply the ordering is "first in, first out."
.IP Rerunable
If a batch job can be terminated and its execution restarted from the
beginning without harmful side effects, then the job is said to be rerunable.
.IP "Stage In" 15
is to move a file or files to the host prior to the batch job beginning
execution.
.IP "Stage Out" 15
is to move a file or files off of the host after the batch job completes
execution.
.IP Timeshared
In our context, to timeshare is to always allow multiple jobs to run
concurrently on an execution host or node.  A
.I "timeshared node"
is a node on which jobs are timeshared.  Often the term
.I host
rather than node is used in conjunction with timeshared, as in
.I "timeshared host" .
If the term node is used without the timeshared prefix, the node is a cluster
node which is allocated either exclusively or temporarily-shared.
.IP User 15
is a user of the compute system.  Each user is identified by a unique
character string, the user name; and by a unique number, the user id.
.IP "User ID" 15
is a numeric identifier uniquely assigned to each user.
Privilege to access system resources and services is typically established
by the user id.
.IP "Virtual Processor" 15
An allocation unit that exists within a cluster (space-shared) node.
Virtual processors, VPs, are allocated to jobs on an exclusive or temporarily
shared basis.   Virtual processors may or may not correspond in number to the
number of real processors on the node.  Fewer VPs than real processors may
be defined to keep the batch load on the node down.   More VPs may be defined
to allow for over-subscription of the cpu resources.
