. % 1
.OH ''PBS ERS'Job Scheduler'
.EH 'Job Scheduler'PBS ERS'
.P1
.so ers_setup.ms
.Rv $Revision: 2.1 $
.nr H1 7
.NH 1
.Tc "\f3\s+2The PBS Job Scheduler\s-2\fP"
.LP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.LP
The PBS Job Scheduler is a daemon that performs job scheduling for a particular PBS 
server. 
.NH 2
.Tc \f3Scheduler Overview\fP
.LP
The PBS Scheduler performs job scheduling upon request from a PBS Server.
Except for the initial message, which is transmitted through a normal socket
connection, the Server and Scheduler communicate
by using functions defined in the pbs_ifl (PBS interface library).
.LP
The entity which is given the role of scheduler for PBS may be a special
purpose program or even a shell script.  The fundamental parts have been
provided to offer maximum flexability.  Two example schedulers have been
included.
One scheduler is based on
.B yacc
and
.B lex
and creates its own language BASL, for BAtch Scheduler Language.
The other scheduler is based on
One is based on
.B tcl
and augments an already existing language with some new commands
that give access to PBS functions.
The other is a C language framework.
.LP
.NH 2
.Tc "\f3The Scheduling Cycle\fP"
.LP
If the scheduler has been asked to initiate a scheduling cycle, it first
reverses the sense of the connection between the scheduler and server, and
requests information concerning the current job pool from the server, and
possibly, information about the queues that the server has defined.
The scheduler then evaluates the job set according to the procedure expressed
in the language file,
and determines if any action should be taken concerning any jobs in the pool.
At the end of the cycle, the scheduler once more resumes listening on the
designated port.
.LP
The scheduler may also request information from one or more Resource Monitors.
Resource Monitors are daemons that provide information about the state of the
resources of particular machines, or collections of processors, such as
clusters or MPP partitions.  Communication between the scheduler and resource
Monitors is conducted over a well-known port.
The protocol used between the scheduler and a resource Monitor is described
in the PBS Scheduler IDS.
.NH 2
.Tc "\f3The Tcl Scheduler\fP"
.LP
Tcl is a flexable language which can be extended fairly easily.  The
library to communicate with the Resource Monitor and the regular
PBS Interface Library have been wrapped into Tcl commands to
create a special purpose tcl interpreter which waits to be
awakened by the PBS server before swinging into action.
The indispensable book for dealing with Tcl is
.ul
Tcl and the Tk Toolkit
by John K. Ousterhout.
.LP
The Tcl scheduler man page gives all the particulars about the functions
which are available to access the PBS Resource Monitor and Server.
The section of the ERS which describes the Resource Monitor discusses
the information available to the script writter for a particular type
of system.
.LP
.NH 2
.Tc "\f3The C Scheduler\fP"
.LP
This is a skeleton program designed as a starting point for
someone to use to create a complete C language scheduler program.
It consists of a main program that processes options and sets up
the network connection to the server.  It was patterned after the
Tcl scheduler main program in the hope it would not need to
be chaneged yet the scheduler algorithm could still modified
easily.  A directory of examples is included that show the
required entry points for the scheduler writter.
.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[Page intentionally left bank.]
.DE
.bp
\}
