.nr % 1
.OH ''PBS ERS'User Commands'
.EH 'User Commands'PBS ERS''
.P1
.so ers_setup.ms
.Rv $Revision: 2.2 $
.nr H1 4
.NH 1
.Tc \f3\s+2User Commands\s-2\fP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.LP
This section describes the commands available to the general user.
Unless otherwise noted, the command must conform to the POSIX 1003.2d
specification of the command as to syntax and functionality.
.NH 2
.Tc "\f3General Specifications of User Commands\fP"
.LP
The following specifications apply to all user commands.
.NH 3
.Tc Error Checking
.LP
All user commands will validate their invocation for the correct syntax.
Any syntax error or invalid option will terminate the command with an
error message on standard error and an exit status greater than zero.
.NH 3
.Tc Directing Requests to Correct Server
.LP
A command performs its function by sending the corresponding
request for service to a batch server.
The choice of batch servers to which to send the request is governed
by the following ordered set of rules:
.IP 1. 3
For those commands which require or accept a job identifier operand,
if the server is specified in the job identifier operand as
.Ty @server ,
then the batch requests will be sent to the server named by
.Ty server .
.IP 2. 3
For those commands which require or accept a job identifier operand
and the 
.Ty @server
is not specified, then the command will attempt to determine the
current location of the job by sending a 
.I "Locate Job"
batch request to the server which created the job.
.IP 3. 3
If a server component of a destination is supplied via the -q option,
such as on 
.B qsub
and
.B qselect ,
but not 
.B qalter ,
then the server request is sent to that server.
.IP 4. 3
The server request is sent to the server identified as the default server,
see section \*(Si.
.NH 3
.Tc Operands
.LP
Unless noted, when more than one operand is specified on the command line,
the command processes each operand in turn.
An error reply from a server
on one operand will be noted in the standard error stream.  The command
continues processing the other operands.  If an error
reply was received for any operand, the final exit status for the
command will be greater than zero.
.LP
Generally, the operands to commands will be job identifiers as
described in section \*(Ji or destination identifiers described in
section \*(Di.
.NH 2
.Tc "\f3General User Commands\fP"
.LP
.bp
.NH 3
.Tc Alter Job
.LP
.so ../man1/qalter.1B
.bp
.NH 3
.Tc Delete Job
.so ../man1/qdel.1B
.bp
.NH 3
.Tc Hold Job
.so ../man1/qhold.1B
.bp
.NH 3
.Tc Move Job
.so ../man1/qmove.1B
.bp
.NH 3
.Tc Message Job
.so ../man1/qmsg.1B
.bp
.NH 3
.Tc Order Jobs
.so ../man1/qorder.1B
.bp
.NH 3
.Tc Rerun Job
.so ../man1/qrerun.1B
.bp
.NH 3
.Tc Release Job
.so ../man1/qrls.1B
.bp
.NH 3
.Tc Select Jobs
.so ../man1/qselect.1B
.bp
.NH 3
.Tc Signal Job
.so ../man1/qsig.1B
.bp
.NH 3
.Tc Status Jobs, Queues, or Server
.so ../man1/qstat.1B
.bp
.NH 3
.Tc Submit Job
.so ../man1/qsub.1B
.bp
.NH 3
.Tc "Convert NQS Scripts"
.so ../man1/nqs2pbs.1B
.bp
.NH 3
.Tc "BASL Compiler"
.so ../man1/basl2c.1B
.bp
Figure \n(H1\-\n+(Fi shows how the BASL data types Server, Set Server, Que,
Set Que, Job, Set Job relate to one another. The items in italics are the
predefined functions that must be called in a BASL program in order to 
instantiate the data types. The figure also illustrates the PBS framework:
in a scheduling system,  one or more server hosts exist, and each server
manages one or more queues, and one or more jobs are spooled inside a queue.
Jobs are run on one or more computational nodes (machines). A machine could
act both as a server and a computation node.
.so basl_datatype.pic
.sp
.ce
Figure \n(H1\-\n(Fi: BASL Complex Data Types
.NH 3
.Tc "Graphical User Interface: xpbs"
.LP
\f3xpbs\fP is the graphical user interface to PBS user and operator commands.
The
current implementation will actually call the PBS commands like qsub, qstat,
qselect, and so on. In addition, 2 new commands were created specifically
for xpbs: xpbs_scriptload, and xpbs_datadump. These 2 binaries are compiled
using the same libraries used by the standard PBS commands.
.sp
\f3xpbs\fP is written in Tcl/Tk. The way it works is that a main driver
script/program called "xpbs" is what a user invokes, and this
script calls other programs found in XPBS_LIB directory (as set in Makefile).
.so ../man1/xpbs.1B
.NH 3
.Tc "Graphical User Interface: xpbsmon"
.LP
\f3xpbsmon\fP is the graphical user interface for displaying, monitoring the
nodes/execution hosts under PBS.
.sp
\f3xpbsmon\fP is also written in Tcl/Tk. The way it works is that a main driver
script/program called "xpbsmon" is what a user invokes, and this
script calls other programs found in XPBSMON_LIB directory (as set in Makefile).
.so ../man1/xpbsmon.1B
.bp
.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[Page intentionally left bank.]
.DE
.bp
\}
