.nr % 1
.OH ''PBS IDS'Administrator Commands'
.EH 'Administrator Commands'PBS IDS''
.P1
.so ids_setup.ms
.Rv $Revision: 2.1 $
.nr H1 3
.NH 1
.Tc \f3\s+2Administrator Commands\s-2\fP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.LP
A batch administrator is a user of the system who is granted the highest level
of privilege in the batch system.  The batch administrator is able to perform all operator functions and additionally modify queue and server configurations.

In addition to the general user commands and operator commands, the 
administrator has access to the
.B qmgr
command.
.NH 2
.Fi qmgr.c
.LP
The
.B qmgr
command provides an administrator interface to the batch system.
The command reads directives from standard input or from the command line.  
The syntax of each directive is checked and the appropriate request is sent 
to the one or more batch servers.
.NH 3
.Fn main()
.Cs
main(int argc, char **argv)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of options on the command line.
.IP argv 8
The
.B argv
array contains the following options:
.RS
.IP -a 4
Abort
.B qmgr
on any syntax errors or any requests rejected by a server.
.IP "-c command" 4
Execute a single command and exit.
.IP -e 4
Echo all commands to standard output.
.IP -n 4
No commands are executed, syntax checking only is performed.
.IP -z 4
No errors are written to standard error.
.IP "server ..." 4
The list of servers to manage.
.RE
.RE
.IP Returns: 4
Nothing

.LP
Main is controls the flow for the entire program.  It first parses the 
arguments with help from the getops(3) call.  If there were servers passed in
on the command line, the rest of the command line arguments are passed through
.I strings2objname()
to convert then into objname structures.  If no servers are on the command line
.I default_server_name()
is called to get the default server objname struct.  The objname struct is 
passed into 
.I connect_servers()
to connect to the servers and set the 
.Av servers 
global variable.  These servers are set to be the active servers.
If there was an error and the "-a" flag was given, qmgr 
exits.  At this point is the important part of the main function.   The 
following can be done in a loop depending on if the "-c" flag was given.  
First, if the "-e" flag was set.  If it was, print the command.  Next, the 
.I parse()
function is called to parse the command.  If the there was an error and the 
"-a" flag was set qmgr exits.  Finally if "-n" was not set and parse did not 
return an error
.I execute()
is called to package up the command and send it to the server.  If the "-c"
flag is not given, it will loop on the 
.I get_request()
function until an EOF is returned.  Lastly it disconnects from all the servers 
and exits.

.NH 4
.Fn get_request()
.Cs
int get_request(char *request)
.Ce
.IP Args: 4
.RS
.IP request 16
OUT: buffer for the string passed by reference
.RE
.IP Returns: 4
.RS
.IP int 8
Zero, if a request was found.  EOF, otherwise.
.RE

.LP 
There are two while loops are do most of the work in this function.  

The first
takes care of getting line from standard input.  It will remove whitespace and 
newlines.  It will also ignore comments, and concatinte continuation lines 
ending with(\).  Note, this loop could be skipped if a command seperator was 
used the last time through.  There is still more to be executed.

.LP
The second while loop copies the string into the 
.Av request
buffer passed in by the caller.  It copies the string character by character 
handling special cases when they arise.  It will end the command if it sees a 
command seperator(;), start of a comment(#), or null byte.  If it encounters
a quote ( " or ' ) it will copy the string until it finds another quote of the
same type.

.LP
The function will make one last check: Is there any more on the line?  If the 
command has ended in a commanx seperator(;), and there is more on the line then
just white space, it will set the
.Av empty
flag to false.  If the line ended with a comment or a null byte, the 
.Av empty
flag is set to true.  Lastly, the rest (could be all) of the static buffer is 
filled with null bytes.

.NH 4
.Fn parse()
.Cs
int parse(char *request, int *operation, int *type, char **names, struct attropl *attributes)
.Ce
.IP Args: 4
.RS
.IP request 16
One entire qmgr request.
.IP oper 16
OUT: parsed operator (active / create / delete / set / unset / list)
.IP type 16
OUT: parsed type of object (server / queue / node)
.IP names 16
OUT: parsed names of object
.IP attributes 16
OUT: parsed list of attributes
.RE
.IP Returns: 4
.RS
.IP int 8
Zero, if there are no syntax errors.  Non-zero, otherwise.
.RE

The parse function is what takes the input line and parses out the 
necessary things to do the command.  A call to 
.I parse_request()
is made to parse out the command, object, and possible name.  The command 
is used to set the 
.Ar oper
variable.  The object is used to set the 
.Ar type
variable.  If there is a name it is passed to the function
.I is_attr()
to check and see if it is attribute.  If it is, then back up what is returned
by
.I parse_request()
and clear the IND_NAME field of the
.Ar req
req array.  If it is not an attribute, it is passed into the function
.I check_list()
to check for errors in a comma seperated list of names.  Next, the rest of
the request is passed through the function
.I attributes()
which converts the attribute value pairs to attrl structures.  Lastly, a little
error checking is done.

.NH 5
.Fn attributes()
.Cs
int attributes( char *attrs, struct attropl **attrlist, int doper )
.Ce
.IP Args: 4
.RS
.IP attrs 16
The text of the attributes to parse
.IP attrlist 16
OUT: the attropl structure to return the parsed attributes in
.IP doper 16
The operation being done (active/create/delete/set/unset/list)
.RE
.IP Returns: 4
.RS
.IP 0: 
no syntax errors
.IP index: 
the index into the 
.Av attrs
var of where the error occurred otherwise.
.RE

.LP 

The form of the attributes is either
.br
attr OP value
.br
or
attr.res OP value
.br
where OP is either = += or -=

.I freeattropl() 
is called right off to free the space of previous structures.
A forever loop starts here.  The first thing that happens in the
find the name of the attribute.  A attropl struct is created, and space for
the attribute name is also allocated and assigned.  If the 
.Av attrs
string is currently at a period(.), then the attribute is a resource.  Space
is allocated and the text of the resource is saved in it.  The operator is
found and set.  If the operator is a comma goto the end of the loop to
check for more attriburtes.  The value is the last thing to find.  If the 
value is quoted,
find the other side of the quote and allocate and assign the string.  If it is
not quoted, look forward to find a comma or the end of the line and
allocate and assign the string.  

The last thing is the look if there are any more attributes to to parse.
(Remember that goto a second ago... this is where it went)

.NH 4
.Fn execute()
.Cs
int execute(int aopt, int oper, int type, char *names, struct attropl *attribs)
.Ce
.IP Args: 4
.RS
.IP aopt 16
If the -a option was on the command line.  Abort on an error.
.IP oper 16
The operation part of the request.   (list/set/unset/create/delete)
.IP type 16
The type of object from the request. (server/queue/node)
.IP names 16
The names of the objects.
.IP attribs 16
The list of attributes of the object.
.RE
.IP Returns: 4
.RS
.IP 0 
success
.IP non-zero
on error
.RE

.LP 
The first thing which is done is th convert the comma seperated list of names 
into a objname linked list.  This is done by a call to 
.I commalist2objname()
if the operation is to set active, call 
.I set_actiive()
and return.  Otherwise we need to loop through all the objects doing the right 
thing.  If if the list of names was not passed it, the active objects are used.
This starts the two main loops of the function.  The outer loop is of the 
objects, and the inner loop is the servers.  If the object has specified a 
server, the request will only be sent to that server.  If it doesnt specify, 
it will be sent to all the active servers.  The outer loop doesnt too anything
but the inner loop.  The first thing that happens in the inner loop is that it 
will check if it needs to connect to a server.  This is where the meat of the
function happens.  If the operation is list or print, a pbs_stat* 
(server/queue/node) call is sent to the server and the result sent to display.
Everything else is packaged up into a 
.I pbs_manager()
and sent to the server.  Lastly a little error checking is doen so make sure 
there wasn't an error and then the error, if any is returned.


.NH 5
.Fn commalist2objname
.Cs
int commalist2objname(char *names, int type)
.Ce
.IP Args: 4
.RS
.IP names 16
A comma seperated list of names or NULL
.IP type 16
The type of the object
.RE
.IP Returns:
pointer to array of names

.LP
This function will take a list of comma seperated names and turn it into a 
linked list of objname strutures.  There is one main loop in this function.
We shoot forward in the string looking for either a comma or an at sign.  We 
allocate an objname structure.  If we found an at sign, we look for a comma 
we copy whats before the at sign into the object name, and after the comma into
the server name.  If we ended on a comma, we just need to copy the object name.
If the type is a server, then assign the object name into the server name.
After the loop we check for an error.  Ifthere was one, clean up and return.
If not, return the objname list.


.NH 5
.fN attropl2attrl()
.Cs
struct attrl *attropl2attrl(struct attropl *from)
.Ce
.IP Args: 4
.RS
.IP from 16
an attropl list to be transformed into an attrl list
.RE
.IP Returns: 4
.RS
.IP Pointer 
attrl list
.RE

.LP
This whole function revolves around a loop which goes through the entire 
attropl list in 
.Av from .
Mainly two things are done in this loop.  The first is to allocate and
initalize a new attrl struct in the new attrl list.  The second is to copy the
.Av name ,
.Av resource ,
and
.Av value 
fields from the current attropl struct into the new attrl struct.  This ends
the loop.
Lastly, the new list will be returned.

.NH 5
.Fn freeattrl()
.Cs
int freeattrl(struct attrl *attr)
.Ce
.IP Args: 4
.RS
.IP attr 16
The list of attrl structures to be freed
.RE
.LP
.IP Returns: 4
Nothing

.LP 
March through the attrl list freeing all the inner variables, and finally the
structure its self.

.NH 5
.Fn display()
.Cs
int display(int otype, char *oname, struct batch_status *status, int format)
.Ce
.IP Args: 4
.RS
.IP otype 16
The type of the object
.IP oname 16
The name of the object
.IP status 16
The list of status structures to display.
.IP format 16
True, if the output is to be formatted as input.
.RE
.IP Returns: 4
Nothing

.LP
The output of this function will depend on the 
.Av format 
variable.  If it is true, the output of the function could be used as input
into the qmgr.  If it is false, the output will be easier to read output for
information.  Throughout the function there are checks to print either method
depending on the 
.Av format
variable.   There is a series of while loops since the batch_status structure
is a linked list of objects which contain a linked list of attributes.  The
outer while loop is to go through the batch_status structs.  The inner one is
for attributes.  

.LP
Everything is the same for the two methods of output until you get to printing
attributes whose values have multiple values (i.e. managers=root,bob,susan).
If
.Av format
is true, the multiple values will be seperated into multiple lines while using
the addition operator(i.e. managers = root ; managers += bob...).  If 
.Av format
is false, the multiple values are line wrapped.
Sample output:
.br
#
# Set server attributes.
#
set server scheduling = True
set server max_running = 3
set server managers = root
set server managers += bob
set server managers += susan
set server resources_max.mem = 128mb
set server resources_available.mem = 100mb
set server scheduler_iteration = 120

.NH 4
.Fn clean_up_and_exit()
.Cs
int clean_up_and_exit(int extflg)
.Ce
.IP Args: 4
.RS
.IP extflg 16
the exit value
.RE
.LP
Returns:
.RS
This function never returns, its exits.
.RE

.LP
Free the active object lists.  Then call 
.I pbs_disconnect()
on each of the open servers.  Finally exit with 
.Av exit_val
return code.

.Fn make_connection()
.Cs
int make_connection( char *name, struct server *svr )
.Ce

.IP Args: 4
.RS
.IP name
.br
the name of the server to connect
.RE

.IP Returns:
.RS
Pointer to newly connected server
.RE

.LP
A connection attempt is made through the 
.I cnt2server()
library call.  If it is successful, a new server struct is allocated and the
the server fields 
.Av s_name
and 
.Av s_connect
are assigned.  If it fails print an error.

.Fn connect_servers()
.Cs
int connect_servers( char **server_names, int numservers )
.Ce

.IP Args: 4
.RS
.IP server_names
.br
array of server names to make connections
.IP numservers
.br
the number of servers to connect to on the list
.RE

.IP Returns
.RS
.IP TRUE
.br
on error
.IP FALSE
.br
NOTE: This function modifies the 
.Ar servers
global variable.
.RE

.LP
First of all, nonreferenced servers are closed.  If the ammount of open servers
is still under the max ammount of servers that can be open, then run through 
a forloop from 1 .. 
.Av numervers
and call
.I make_connection()
to each one.  The objname 
.Av svr
field is set.

.Fn blanks()
.Cs 
void blanks( int number )
.Ce

.IP Args:
.RS 
.IP number 
.br
the number of spaces to print
.RE
.IP Returns
Nothing

.LP 
print
.Av number
spaces to standard error by filling a buffer with spaces and printing them.

.Fn check_list()
.Cs 
int check_list( char *list )
.Ce

.IP Args:
.RS
.IP list
.br
A comma delemited list
.RE

.IP Returns
.RS
.IP 0
.br
If the syntax is correct
.IP > 0
.br
If the index into the string where the error occured
.RE

.LP
This function checks for validity of a comma seperated list.  There is one 
main loop which checks for eronious conditions and returns the index into the
string where it happened.
.RS
.nf
.IP "Case 1:"
First char is not not alpha or an '@'
Ex Good: "ueue"
Ex Fail: "!queue"

.IP "Case 2:"
error situation with an "@"
Ex Good: "name@svr"
Ex Fail: "name@," "name@"

.IP "Case 3:"
After a name with an "@" if doesnt end with a "," or EOL
Ex Good: "name@svr,name"
Ex Fail: "name@svr@name"

.IP "Case 4:"
a comma at the end of the line.
Ex Good: "name@svr"
Ex Fail: "name,"
.fi

.Fn freeattropl()
.Cs 
void freeattropl(struct attropl *attr)
.Ce

.IP Args: 4
.RS
.IP attr 
.br
A pointer to a linked list of attropl structs to free
.RE

.IP Returns
Nothing

.LP
Loop through the attropl list freeing the members and finally freeing the
structure itsself.

.Fn is_attr()
.Cs 
int is_attr( int object, char *name, int attr_type )
.Ce

.IP Args: 4
.RS
.IP object
.br
The type of object
.IP name
.br
The name of the attribute
.IP attr_type
.br 
The type of the attribute: Public or Readonly
.RE

.IP Returns
.RS
.IP TRUE
.br
if the attribute is public
.IP FALSE 
.br
if not
.RE

.LP
There are six attribute arrays which are are initialized with the contents of 
header files.  They are used to see if the name is an attribute or not.  The
object type and attribute type is checked to see what arrays to use.  The 
check is doen by iterating through the arrays.

.Fn pstderr()
.Cs
static void pstderr( char * )
.Ce

.IP Args: 4
.RS
.IP string
.br
the string to print to stderr
.RE
.IP Returns
Nothing

.LP
If the global variable 
.Av zopt 
is false, then print to standard error
.Av string .
else do nothing

.Fn pstderr1()
.Cs
void pstderr( char *string, char *arg )
.Ce

.IP Args: 4
.RS
.IP string
.br
The format string
.IP Arg
.br
Argument
.RE

.IP Returns 
Nothing

.LP
This function is like
.I pstderr()
but instead of just printing a string, it will print a string and one string 
argument.  It uses fprintf().


.Fn show_help()
.Cs
void show_help( char *str )
.Ce

.IP Args: 4
.RS
.IP str 
.br
Possible subject to get help on
.RE

.IP Returns: 
Nothing

.LP
if the string is NULL or a null byte, print basic help.  If there is a string,
print more specific help.

.Fn find_server()
.Cs
struct server * find_server( char *name )
.Ce

.IP Args:
.RS
.IP name
.br
Then name of the server to find
.RE

.IP Returns:
The server structure if found or NULL of not

.LP
Basically loop though all of the servers in the global variable 
.Av servers .
If the server is found, return it.  If not return NULL;

.Fn new_server()
.Cs
struct server *new_server()
.Ce

.IP Args:
None

.IP Returns:
Newly allocated server structure

.LP
Allocates a new server structure and initializes it.

.Fn new_objname()
.Cs
struct objname *new_objname()
.Ce

.IP Args:
None

.IP Returns:
newly allocated objname structure

.LP
Allocates a new objname structure and initializes it.

.Fn strings2objname()
.Cs
struct objname *strings2objname( char **str, int num, int type )
.Ce

.IP Args:
.RS
.IP str
.br
the array of strings
.IP num
.br
The number of strings in the array
.IP type
.br
The type of objects
.RE

.IP Returns:
objname linked list

.LP
Loop through all the elements in the array and create a linked list of objnames.
If the type is a server set the svr_name to the obj_name field.

.Fn default_server_name()
.Cs
struct objname * default_server_name()
.Ce

.IP Returns 
objname structure with default server information

.LP
If 
.I pbs_connect()
is passed a null string(""), it will open a connection to the server specified
in the pbs default file.  This function will create an objname structure and
fill it with the correct information for the default server.

.Fn temp_objname()
.Cs
struct objname *temp_objname( char *obj_name, char *svr_name, 
						struct server *svr)
.Ce

.IP Args
.RS
.IP obj_name
.br
The name for the temp obj
.IP svr_name
.br
The server name for the temp obj
.IP svr
.br
The server for the temp obj
.RE

.IP Returns
The temporary object

.LP
This function has a static struct objname which it will use.  It clears all 
data from the objname, and then assigns in the new data.  It will adjust 
the reference counts on the new and old servers as necessary.

.Fn parse_request()
.Cs
int parse_request(char *request, char req[][] )
.Ce

.IP Args
.RS
.IP request 
.br
the request line to parse
.IP req
.br
OUT: The array to assign
.RE

.IP Returns 
length of the request line parsed or zero on error

.LP
Parse out the first three words of the request.  The first word should be the
command, the second the object, and the third will be a name.
There are five symbolic constants used to help with this array.
IND_FIRST is the first index of the array.  IND_LAST is the last index.  We 
then have IND_CMD, IND_OBJ, and IND_NAME.  These are for command, object and 
name indicies of the array.

.Fn free_objname_list
.Cs
void free_objname_list( struct objname *list );
.Ce

.IP Args:
.RS
.IP list
.br
the objname list to free
.RE

.IP Returns:
Nothing

.LP
Free all the objnames by looping through the linked list calling 
.I free_objname()

.Fn free_server()
.Cs
void free_server( struct server *svr )
.Ce

.IP Args
.RS
.IP svr
.br
The server to free
.RE

.IP Returns
Nothing

.LP
This function will first attempt to remove the server from the servers list.
If it can find the server, it will unlink it from the servers list.
Reguardless, it will free the memory used by the structure.

.Fn free_objname()
.Cs
void free_objname( struct objname *obj )
.Ce

.IP Args:
.RS
.IP list
.br
the objname to free
.RE

.IP Returns
Nothing

.LP
Free the memory used by the objname and decrement the server which it 
referenced.

.Fn close_non_ref_servers()
.Cs
void close_non_ref_servers()
.Ce

.IP Returns
Nothing

.LP
This function goes through the server linked list and will close connections
to servers with a zero reference count.  This is done by calling
.I disconnect_from_server().

.Fn set_active()
.Cs 
int set_active( int obj_type, struct objname *obj_names )
.Ce

.IP Args
.RS
.IP obj_type
.br
The type of object we are setting the active list
.IP obj_names
.br
the objname linked list to set active to
.RE

.IP Returns
0 on success / non-zero on failure

.LP
This function will set the active servers, or print the active object
depending on whether obj_names is NULL.  If it is not NULL then the active 
object will be set.  If its a call to set the active servers, then each server
is connected to if needed.  Otherwise a call to 
.I is_valid_object()
is made to see if the object is exists and is valid.

.Fn is_valid_object()
.Cs
int is_valid_object( struct objname *obj, int type )
.Ce

.IP Args
.Rs
.IP obj
.br
the object to check
.IP type
.br
The type of object
.RE

.IP Returns
1 if the object is valid, 0 if not

.LP
If the type is queue, a 
.I pbs_statque()
is done to check for the existence of the queue.  It acually queries queue
type, but nothing is done with this value.  This is because something has to
be queried, or everything is returned.  Simularly with nodes the state of the
node is querried for the same reason.  If the call is successful, the object
exists and is valid.  The other case of a valid object is if 
.Av obj
is NULL.  A null object means any requests will be sent to all active servers.

.Fn disconnect_from_server()
.Cs
void disconnect_from_server( struct server *svr )
.Ce

.IP Args
.RS
.IP svr
.br
The server to disconnect from
.RE

.IP Returns 
Nothing

.LP
call 
.I pbs_disconnect()
on the connection descriptor for the server, and make a call to 
.I free_server().  Lastly decrement the number of connected servers


.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[This page is blank.]
.DE
.bp
\}
