.nr % 1
.OH ''PBS IDS'IFF'
.EH 'IFF'PBS IDS''
.P1
.so ids_setup.ms
.Rv $Revision: 2.1 $
.mr Fi 0 1
.nr H1 8
.NH 1
.Tc "\f3\s+2IFF - User Credential Granter\s-2\fP"
.LP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.NH 2
.Tc \f3PBS_IFF Overview\fP
.LP
As the PBS server is happy to act upon jobs if the user's name in the batch
request is the same as the job owner, there must be a method of authenticating
or proving that the requesting user is who they claim to be.
The standard practise in socket/TCP/IP based applications for user
authentication is through the use of \*Qreserved\*U or \*Qprivileged\*U ports.
This provides weak authentication, but it is about the only common game in
town, especially if you cannot use encryption.
Typically a client cannot bind to a port with a number less than 1024 unless
the client is running with root effective privilege.  This approach is fine
when the clients are fixed and few in number.
.LP
As PBS provides the API library and allows users to write their own PBS clients,
another method of user authentication is required which does not require root
privilege of each client program.  In the basic PBS system, user authentication
is achieved by the program
.B pbs_iff ,
.I "identification, friend or foe" .
.LP
The basic scheme is to have the client program fork and execute a root
privilege program (setuid) which using its real uid to obtain the user's name
and its root effective uid to gain access to a privileged port.
This process is known as 
.B pbs_iff .
Pbs_iff sends a authentication message to the server over the privileged port.
The authentication message contains the requesting user's name, host
name and the name (number) of the non-privileged port the parent PBS client
is using to contact the server.
The server will associate the user and host name with the clients port. 
As long as the requests that arrive on that port originate from the named host
and the user name in the request matches the associated name, the server will
accept the request.  This scheme is shown in figure \n(H1\-\n+(Fi.
.DS B
.ce
.so iff.pic
.sp
\f3Figure \n(H1\-\n(Fi: PBS IFF Program\f1
.DE
.LP
The client API library interfaces with pbs_iff via one call within 
.I pbs_connect() .
More information is available in the API section of the IDS.
.LP
The simple interface between pbs_connect() and pbs_iff on one end and
the server on the other allows for easy replacement of pbs_iff with
the user authentication of your choice, such as Kerberos.
.NH 2
.Tc Packaging
.LP
The following source files are required to build pbs_iff:
.in +.5i
pbs_iff.c
.in -.5i
The following libraries are used when linking pbs_iff:
.in +.5i
libnet.a libpbs.a and the whole ISODE mess.
.in -.5i
.NH 3
.Tc External Interfaces
.LP
Pbs_iff is called with the usage:
.Cs
pbs_iff [-t] server_host_name server_port_number [client_socket]
.Ce
Where 
.Ar server_host_name
is the name of the server to which the client will
connect.  
.Ar Server_port_number
is the port number to which the server listens,
typically 15000.  If the 
.Ar -t
option is specified, it indicates a test mode.
In this mode, pbs_iff sends a message to the server to test connectivity.
If 
.Ar -t
is not given, the normal case, then 
.Ar client_socket
is required.  It is the socket number which the calling client has opened and
connected to the server.
.LP
Pbs_iff is forked and exec-ed by a client program, typically by a 
.I popen(3)
call.
Pbs_iff returns the type of authentication performed to the client by
writing an identifying integer on its standard output if that stream is
connected to a pipe.
.LP
Provisions are made for having pbs_iff return a credential to the PBS API.
In the current release this is not used, a credential type of
.Sc int_BATCH_credentialtype_credential__none
is returned and nothing else.
If the authentication type is not
as defined in the Batch Protocol, then the size of the size of the credential
is returned as an integer, followed by the credential itself.
.LP
Pbs_iff will create a socket and bind it to a reserved port.  This socket 
is then connected to the server.
.LP
.NH 3
.Fi pbs_iff.c
.LP
The file
.I src/iff/pbs_iff.c
contains the source for the main function of pbs_iff.
.Fn "main() [pbs_iff]"
.Cs
pbs_iff [-t] server_host_name server_port [client_socket]
.Ce
.IP Args: 4
See above under "External Interfaces".
.LP
A test is made to make sure that pbs_iff's standard output is connected to
a pipe.
The main routine of pbs_iff obtains the real user id and converts that to
the user's login name.
The server's network address is obtained by calling
.I get_hostaddr() .
The function
.I client_to_svr()
is called to allocated and bound (bind()) a socket to a reserved port and make
a connection to the server.
.LP
If not test mode (-t option), the port name of the client's socket is obtained
via getsockname().  If test mode is set, then the port number of pbs_iff's
socket is used instead as there is likely not client socket.  This port number
is placed in the Authenticate User batch request and sent to the server over
the privileged port.
.LP
If the server accepts the request, pbs_iff returns 
.Sc int_BATCH_credentialtype_credential__none
to the client.  Otherwise, pbs_iff exits without writting to the client.
.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[This page is blank.]
.DE
.bp
\}
