.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.OH ''PBS IDS'Libraries'
.EH 'Libraries'PBS IDS''
.P1
.so ids_setup.ms
.Rv $Revision: 2.1 $
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.NH 2
.Tc "\f3libpbs.a - Command API and Data Encode Library\fP"
.Ix libpbs.a
.LP
The PBS Command Interface Library (IFL), 
.B libpbs.a ,
provides a application programming interface, API, to the PBS
server.  The PBS commands are implemented using these functions.  It is also
intended that users be able to write their own commands if they so
desire.  The data encode/decode are an integral part
of the interface library.
.NH 3
.Tc "Design Concepts of the Interface Library"
.LP
The IFL is an RPC interface to the 
services provided by the PBS server.  The 
functions 
.B pbs_connect 
and 
.B pbs_disconnect 
bind and unbind
the library to an
instance of a batch server, and the remaining (public) calls are remote calls
to functions in the server.  A connection identifier is returned by
.B pbs_connect 
to identify the binding, and is input to all the other calls.
Additional private routines support the public API calls.
.LP
The marshaling of the parameters and the unmarshaling of the replies
are handled by private routines (enc_*.c and dec_*.c)
included in the library.   At the lowest level, the DIS data encode/decode
provide machine independent network representation of the data.
.LP
The functions in the Interface Library can be divided into 5 groups:
.IP \(bu
Those that manage connections.
.IP \(bu
Those functions that are essentially direct RPCs for server functions.
These map directly to batch server functions. Some are not intended to
be called directly,
but are rather intended to be used in a set sequence
to implement some higher level part of the protocol.
.IP \(bu
Higher level functions that call several of the direct RPC style functions
to accomplish some higher protocol goal.  The function
.B pbs_submit 
is the prime example.
.IP \(bu
Functions used to convert between data types, for example.
.IP \(bu
Data encode and decode routines.
.LP
.NH 4
Types Used in Argument Lists
.LP
There are several special argument types that occur again and again in
the argument lists of the library functions. 
.LP
For almost all the functions, the first argument is a 
.I connection 
.I descriptor.
The
.I connection
.I descriptor
is returned by
.B pbs_connect,
and is an input argument to everything else.  See the section on Connection
Management Functions for more information.
.LP 
A
.I job_id
is a character string the syntax and semantics of which are specified in
the ERS section 2.7.6.
.LP
The
.I struct
.I batch_status
data structure is the return value for all the functions that return status.
It is described in, for example, section 4.3.1 of the ERS.
.LP
A
.I "destination id"
appears in several of the functions.  It refers to a server, or a queue
managed by a particular server.  The semantics and syntax are described
in sections 2.7.3 and 4.3.9 of the ERS (the man page for 
.B pbs_movejobs
).
.LP
Finally, a ubiquitous argument called
.I extend
is used to allow for extensions to the POSIX standard.
Its meaning is always context dependent.
.NH 4
Naming Conventions
.LP
All the functions in libpbs.a that are intended to be called directly
have names that begin with 
.B pbs_ .  
Functions that are not generally
expected to be called by casual users, but that are externally visible,
have names that begin with 
.B PBS_ .  
Also visible, but not intended to be called by the user are the data
marshaling routines starting with
.B enc_
and
.B dec_ ,
and the DIS encode/decode routines starting with
.B dis .
Static functions that cannot be
called by users have no particular restrictions on the names.
.LP
.NH 4
Connection Management Functions
.LP
The term
.I connection
refers to the process of creating a binding to a particular server.
Successful opening of a connection involves: 1) generating an address
from the supplied server name, according to the rules specified in the
ERS,
2) opening a socket, and
3) validating the user via the IFF.
After it has successfully completed these tasks, 
.B pbs_connect
will return a
.I "connection descriptor" .
.LP
The
.I "connection descriptor"
is analogous to a UNIX file descriptor.
It is actually an index into a small table of
.I "connection state records"
(CSR's). Each CSR
in the table contains a socket, a stream, a place
holder for a returned error number,
a pointer to potential error text, and flags.
.LP
.NH 4
Simple RPC style functions
.LP
At the API level there are 21 Batch Requests.
They are described in section 3 of the ERS. 
these functions
follow an RPC paradigm \- the arguments are marshaled (converted to a
form suitable for transmission on the network) into a buffer and sent
to the server.  The server parses the request, does the action or notes
an error, marshals a reply, and sends it.  The library function receives this
reply, unmarshals it, and returns the results to the caller.  The most 
important characteristic of this model is that the library functions, with
some exceptions, are essentially semantics free -- in the ideal they
transparently pass their arguments to the server, and transparently
return the reply.  In the following descriptions, if a function follows
this paradigm it is described as a "simple RPC", or words to that effect, 
and not described further.
.LP
The basic structure of these functions includes
a call to 
.B encode_DIS_ReqHdr 
to generate the common request header data and insert the request id.
A call to an 
.I encode_DIS_
function of some sort which encodes the request body.
A call to
.B encode_DIS_ReqExtend
to generate the common extension field (request trailer).
Finally, a call to
.B DIS_tcp_wflush() 
completely sends (flushes) the request.  A call to
.B PBS_rdrpy 
reads the
reply, a little code to check for error status, a call to 
.B PBSD_FreeReply() 
and possibly other deallocation routines to deallocate
the reply structure, and finally, a return of an error status.
Sometimes helper functions that manipulate the more complex data
structures are used to keep the code to a reasonable size.
.LP
.NH 4
Composite and multipurpose functions
.LP
The function
.B pbs_submit
has clean and simple semantics conceptually, but considerations related to 
atomic transactions and packaging require that the process actually
be broken into several RPCs.
.LP
On the other hand, in certain cases simplicity of packaging and \*Qobject
management\*U
dictated that several of
the library functions actually resolve down to one RPC call, 
.B PBS_manager .
These functions are 
.B pbs_alterjob ,
.B pbs_deljob ,
.B pbs_holdjob ,
.B pbs_manager ,
.B pbs_rlsjob ,
and
.B pbs_rerunjob .
.LP
Second are those that call
.B PBS_status .
They are
.B pbs_statjob ,
.B pbs_statque ,
and
.B pbs_statsrv .
.LP
.NH 4
Miscellaneous functions
.LP
There are two main categories:  functions that convert from one data
structure to another, or allocate or deallocate data structures; and helper
functions that basically make the packaging a little better -- we try
to avoid functions more than a few pages long.
.LP
.NH 3
.Tc "API Modules"
.LP
As a side note, most of the API and supporting routines where in files named
pbs_*.c and PBS_*.c.   When the newer DIS versions of the calls were introduced,
they were placed in files pbsD_*.c and PBSD_*.c to  separate them from the
old ISODE/ASN.1 versions.  The source control system is such that it is
simpler to keep the new file names.
.LP
Certain of the API functions are spilt into two parts.  The first part calls
the second to send the request.   The first part also includes the code to
understand the reply.   Where this spilting occurs, it is because the PBS job
server needed access to the \*Qsending\*U piece but not the reply piece.
.NH 4
File PBSD_data.c
.LP
This file provides external data blocks used by various functions.
.NH 4
File PBSD_jcred.c
.LP
.Fn PBS_jcred()
A simple RPC that sends the Job Credentials functions to the server.
The credential (unused in this release) is nothing more than a byte array.
It has no meaning to the server.
.LP
.NH 4
File PBSD_manage2.c
.LP
.Fn PBS_mgr_put()
A support routine for 
.B PBS_manager
that handles the send side of the RPC.
The request body is handled by the routine
.I encode_DIS_Manage() .
.NH 4
File PBSD_manager.c
.LP
.Fn PBS_manager()
.LP
Not to be confused with 
.B pbs_manager ,
.B PBS_manager
is a lower level interface
to the "manage" server function.  Its interface is as follows:
.Cs
int PBS_manager(connection, function, command, objtype, objname,
                attrib, extend)
.Ce
The arguments for 
.B PBS_manager are exactly those described for 
.B pbs_manager
in the ERS section 4.3.8, except for
.I function ,
which is an integer used to describe which of the server functions
is indicated.  
.B PBS_manager is an RPC that calls 
.I PBS_mgr_put()
for the
send side, and 
.I PBS_rdrpy()
for the reply.
.LP
.NH 4
File PBSD_msg2.c
.LP
Like pbs_manage, pbs_msgjob is spilt into two pieces.
The public function, pbs_msgjob(), is found in 
.B pbsD_msgjob.c
.Fn PBSD_msg_put()
This part of message job is responsible for encoding and sending the request.
The request body is handled by
.I encode_DIS_MessageJob() .
.NH 4
File PBS_rdrpy.c
.LP
.Fn PBS_rdrpy()
The function
is most frequently seen implementing the reply half of an RPC.
It handles the egregious bookkeeping chores associated with
obtaining a reply.  It allocates a reply structure and uses
.I decode_DIS_replyCmd()
to read and decode the data.  As required, any error codes and messages are
placed where required.
.I DIS_tcp_reset()
is called to reset (pointers to) the buffer used to read/write and decode/encode
DIS data.
.Fn PBSD_FreeReply()
This function frees the reply structure created in PBSD_rdrpy().
What must be freed depends on the type of reply since the structure is a union.
.NH 4
File PBSD_sig2.c
.LP
Again, the pbs_signaljob function is spilt into two pieces for sake of the
job server.  The main function is found in 
.B pbsD_sigjob.c .
.Fn PBSD_sig_put()
This function sends the request using
.I encode_DIS_SignalJob()
to encode the request body.
.NH 4
File PBSD_status.c
.LP
.Fn PBS_status()
This function is the basic call for obtaining status for all object types.
It makes use of the helper function
.I PBS_status_put()
found in PBSD_status2.c
to handle the send side, because the marshaling of
an attribute list is rather complex.  It returns a
pointer to a list of 
.I batch_status
structures via a call to
.I PBSD_status_get() .
The arguments are as described for 
.B pbs_statjob 
in the ERS, section
4.3.15, except for 
.I objtype ,
which describes whether the object for which status is being requested
is a server, a queue, or a job.  In the case of a server, the 
.I id
argument is ignored, because the connection specifies the server.
.LP
Note that the DIS string encoding routines do not take kindly to a null
string pointer.  Here and else where, null pointers are converted to a pointer
to the null string.
.Fn PBSD_status_get()
This function contains a messy little algorithm to take the reply structure 
returned by
.I PBSD_rdrpy()
and convert it into the expected list of
.B batch_status
structures.  Remember, each batch_status structure is also the head of a list
of attributes.
.Fn alloc_bs()
This private function allocates and initializes the space for a batch_status structure.
.NH 4
File PBSD_status2.c
.LP
.Fn PBS_status_put()
The above mentioned helper function.  The complex marshaling of the
attribute list is further helped by a call to 
.B PBS_al2AL .
.LP
.NH 4
File PBSD_submit.c:
.LP
This file contains components of the complex submit request.
.Fn PBS_rdytocmt()
This function is a component of the fairly complex commit protocol that 
guarantee atomic transmission of a job from a client to a server.  This
protocol is defined in the ERS.  It is a pure RPC function as defined
above that sends the "Ready to Commit" function to the server, and
receives the reply.
.Fn PBS_commit()
This function completes the commit protocol required to submit
a job.  It sends the job id of the job that has just been queued to the
server, and acts as a final acknowledgement from the client that it knows
that the server has taken the job.  The only characteristic of this function
that keeps it from fitting the RPC model exactly is that the reply is
immaterial, and thus is ignored.
.Fn PBS_scbuf()
An RPC-style function that sends a single chunk of a job script to the
server.  It is called, potentially many times, by the function 
.B PBS_jscript
to send the entire job script to the server.
.Fn PBS_jscript()
Sending the job script is another component of the job submission protocol.
However, since the script may need to be sent in chunks, 
.B PBS_jscript
calls the function 
.B PBS_scbuf
as many times as necessary to send 
buffer loads of the script.  
.B PBS_jscript
has no system interaction of 
its own, and is a very simple function.
.Fn PBS_queuejob()
This is another RPC-style function.  It sends the first request in the
protocol required to submit a job to the server.
This request contains all of the job control (attribute) information.
.LP
.NH 4
File get_svrport.c
.LP
The file
.I src/lib/Libnet/get_svrport.c
(which of course should be named PBS_get_svrport)
contains the function:
.Fn get_svrport()
.Cs
unsigned int get_svrport(char *service_name, char *proto, unsigned int default)
.Ce
.IP Args: 4
.RS
.IP service_name
the name of the service.
.IP proto
protocol: "tcp" or "udp".
.IP default
port to use.
.RE
.IP Returns: 4
.RS
.IP port
number in host byte order, or -1 if an error.
.RE
.LP
The function just calls the library routine
.I getservbyname()
to obtain the port number.  If the service is not found in /etc/services, the
.Ar default
port is returned.
.LP
This function is contained within Libifl.a, rather than Libnet.h (its natural
home) because it is called from pbs_connect() and a user written program might
otherwise not need Libnet.a.
.NH 4
File pbsD_alterjob.c
.LP
.Fn pbs_alterjob()
This function is almost a pass-through to 
.B PBS_manage
-- the "alterjob"
request is an instance of the Manage Job function.
The one bit of mess required is to convert the
.B attrl 
structures into
.B attropl
structures.
.NH 4
File pbsD_asyrun.c
.LP
.Fn pbs_asyrunjob()
This is the asynchronous version of the pbs_runjob call.
It is identical with pbs_runjob() except for the request id passed in the
request header.
.NH 4
File pbsD_connect.c
.LP
These functions provide connection management services.
.Fn pbs_connect()
pbs_connect does the following things:
.IP \(bu
Reserves a CSR.  Subsequent processing will cause fields in the CSR
to be filled in, unless an error occurs somewhere along the way, in
which case the CSR will be released.
.IP \(bu
Refines the supplied server name via the rules specified in ERS section.
2.7.9.
This is done through a call to the static function 
.B PBS_get_server .
.IP \(bu
Through socket calls, sets up a TCP connection to the server.
.IP \(bu
Makes sure that the user is authenticated to the Server.  This is done through
a call to another static function 
.I PBS_authenticate() .
.IP \(bu
Lastly setups the DIS encoding buffer by calling
.I DIS_tcp_setup() .
.LP
.Fn PBS_get_server()
The static function 
.B PBS_get_server
implements the rules for instantiating a
server name as defined in the ERS. 
From a string of the form
.Ty server_host[:port] 
it returns the server host name and the port number.  If 
.Ty :port
is not supplied, the default port is obtained via
.I get_svrport() .
.Fn pbs_default()
The function
.B pbs_default
will return the default server name.  It is also copied into the private, static
areas
.Ar dflt_server
and
.Ar server_name .
Once the default name has been gotten, it is just supplied on future calls
from 
.Ar dflt_server
with
.Ar server_name 
updated to that string.
.Fn PBS_authenticate()
The static function
.B PBS_authenticate
sets up a pipe and calls the PBS program 
.B pbs_iff 
with the following arguments: the server's name, the server's port, and the
number of the socket of the connection to the server created by pbs_connect.
The type of the credential is read back over the pipe from pbs_iff.  If the
credential is not
.Sc int_BATCH_credentialtype_credential__none ,
which it is always by default, then pbs_authenticate() returns an error.
.QP
In version of PBS prior to 1.1.5, a encrypted version of a credential was
generated by pbs_iff and the server and returned to pbs_connect().  This
was eliminated in 1.1.5 as a step in readying PBS for general availability
including export out side of the USA.
.LP
.Fn pbs_disconnect
The function 
.B pbs_disconnect
is trivial: it shutdown the TCP/IP 
stream, closes the socket, and frees the CSR
.LP
.NH 4
File pbsD_deljob.c
.LP
.Fn pbs_deljob()
Deleting a job is actually an instance of the "manager" function.  Thus
.B pbs_deljob
just calls
.B PBS_manager
with an appropriate set of arguments.
.LP
.NH 4
File pbs_geterrmsg.c
.LP
.Fn pbs_geterrmsg.c
Return a pointer to the last error text returned from the server.
.LP
.NH 4
File pbsD_holdjob.c
.LP
.Fn pbs_holdjob()
Holding a job is another instance of the "manager" function.  Thus 
.B pbs_holdjob
also just calls 
.B PBS_manager
with appropriate arguments.
.LP
.NH 4
File pbsD_locjob.c
.LP
.Fn pbs_locjob()
A simple RPC that sends a job identifier to the server.
The request body is encoded using
.I encode_DIS_JobId() .
.LP
.NH 4
File pbsD_manager.c
.LP
.Fn pbs_manager()
Another straightforward call to
.B PBS_manager ,
with the specific command
being int_BATCH_request_manager.
.LP
.NH 4
File pbsD_movejob.c
.LP
.Fn pbs_movejob()
A simple RPC.  The interface is defined in the ERS.
The request body is encoded using
.I encode_DIS_MoveJob() .
.LP
.NH 4
File pbsD_msgjob.c
.LP
.Fn pbs_msgjob()
A simple RPC.  The interface is defined in the ERS.
The request is sent by calling 
.I PBSD_msg_put() ,
see PBSD_msg2.c
.LP
.NH 4
File pbsD_orderjo.c
.LP
.Fn pbs_orderjob()
A simple RPC.  The interface is defined in the ERS.
This function also uses
.I encode_DIS_MoveJob()
to encode the request body.
.LP
.NH 4
File pbsD_rerunjo.c
.LP
.Fn pbs_rerunjob()
A call to rerun a job, the request body is encoded via
.I encode_DIS_JobId() .
.LP
.NH 4
File pbsD_resc.c
.LP
.Fn encode_DIS_Resc()
.LP
.Cs
static int encode_DIS_Resc(int sock, char **rlist, int count, resource_t rh)
.Ce
.IP Args 4
.RS
.IP sock
sock of stream connection to the PBS server.
.IP rlist
A array of resource strings.
.IP count
The number of strings in rlist.
.IP
The value of an existing resource handle or 
.Sc RESOURCE_T_NULL
for a new handle.
.RE
.IP Returns: 4
The function return value is 0 on success or a PBS error number if an
error occured on the request.
.LP
This internal routine encodes and writes the resource request body for 
the resource query, resource reserve, and resource release requests.
See PBSD_resc().
.Fn PBS_resc()
.LP 
.Cs
static int PBS_resc(int c, int reqtype, char **rlist, int count, resource_t rh)
.Ce
.IP Args: 4
.RS
.IP c
Connection handle for connection to server.
.IP reqtype
the type of request, either
.Av PBS_BATCH_Rescq ,
.Av PBS_BATCH_ReserveResc ,
or
.Av PBS_BATCH_ReleaseResc .
.IP rlist
An array of resource strings.
.IP count
Number of strings in rescl
.IP rh
The value of an existing resource handle or 
.Sc RESOURCE_T_NULL
for a new handle.
.RE
.IP Returns: 4
The function return value is 0 on success or a PBS error number if an
error occured on the request.
.LP
This function is used by pbs_rescquery(), pbs_rescreserve(), and
pbs_rescrelease() to format and send the releated resource request.
The body is sent by calling
.I encode_DIS_Resc() .
.LP
The resource strings are transparent to this routine.  The general format is
one of the following forms:
.Cs
     resource_name
     resoruce_name=
     resource_name=value
.Ce
Currently, the only resource name recognized by the PBS server is
.Av nodes .
.Fn pbs_rescquery()
.Cs
int pbs_rescquery(int c, char **rlist, int count, 
                  int *available, int *allocated, int *reserved, int *down)
.Ce
.IP Args: 4
.RS
.IP c
connection handle from pbs_connect().
.IP rlist
An array of resource strings.
.IP count
Number of strings in rescl; also size of the following integer arrays.
.IP available
Return: number of available resources matching the specification given in
the equivalent position of rlist.
.IP allocated
Return: number of already allocated resources matching the specification given
in the equivalent position of rlist.
.IP reserved
Return: number of reserved resources matching the specification given
in the equivalent position of rlist.
.IP down
Return: number of resources matching the specification given
in the equivalent position of rlist which are marked as down or off-line.
.RE
.IP Returns:
Zero on success or a PBS error number.  On success, the integer arrays
pointed to by
.At available ,
.At allocated ,
.At reserved ,
and
.At down
are filled in.
.LP
A Query Resource batch request is made to the server via the function
.I PBS_resc ().
The reply from the server is read by
.I PBSD_rdrpy ()
and if there are no errors, the return arrays are filled in.  The reply
structure is freed by calling
.I PBSD_FreeReply ().
.Fn pbs_rescreserve()
.Cs
int pbs_rescreserve(int c, char **rlist, int count, resource_t *rh)
.Ce
.IP Args: 4
.RS
.IP c
connection handle to the server returned by pbs_connect().
.IP rlist
An array of resource strings.
.IP count
Number of strings in rescl.
.IP rh
Input/Return: Pointer to a resource handle.
.RE
.IP Returns:
Zero is returned on success or on error a PBS error number is returned.
Also on success, if
.At rh
points to a null resource handle,
.Sc RESOURCE_T_NULL ,
the location pointed to by rh is filled in with a new resource handle.
.LP
A 
.Sc PBS_BATCH_ReserveResc
request is sent to the server by calling
.I PBS_resc ().
The reply is read via
.I PBSD_rdrpy()
and if there is not a handle, rh is updated with the resource handle.
.LP
Note that if the server is able to only reserve part of the requested 
resources, the error 
.Er PBSE_RMPART
is returned.  A resource handle is also returned in that case and the 
resources which could be allocated are assigned to the returned handle.
Should the caller wish to give up the "partial" allocation, 
.I pbs_release ()
should be called with the returned resource handle.
.Fn pbs_rescrelease()
.Cs
int pbs_rescrelease(int c, resource_t rh)
.Ce
.IP Args: 4
.RS
.IP c
connection to the server returned by pbs_connect().
.IP rh
A resource handle returned by pbs_rescreserve().
.RE
.IP Returns:
Zero on success or a PBS error number if a error occured.
.LP
The function
.I PBS_resc ()
is used to send a
.Sc PBS_BATCH_ReleaseResc
request to the server.
.Fn totpool()
.Cs
int totpool(int con, int update)
.Ce
.IP Args: 4
.RS
.IP con
Connection to the PBS server returned by pbs_connect().
.IP update
If non-zero, make a new resource query to the server.
.RE
.IP Returns:
Returns the total number of nodes known to the server.
.LP
If the
.At update
flag is non-zero, a new node resource query is sent to the server by calling
.I pbs_rescquery ()
with a single string resource list of
.Av nodes .
Data from the query is maintained in static memory.
.LP
If the
.At update
flag is zero,  the values from the the prior query is returned from global
memory.   This allows for multiple totpool() and usepool() calls to be
made with only one actual query going to the server.
.LP
The return value is the sum of the number of available, allocated, reserved,
and down nodes.
.Fn usepool()
.Cs
int usepool(int con, int update)
.Ce
.IP Args: 4
.RS
.IP con
Connection to the PBS server returned by pbs_connect().
.IP update
If non-zero, make a new resource query to the server.
.RE
.IP Returns:
Returns the number of nodes known by the server to be in use.
.LP
If the
.At update
flag is non-zero, a new node resource query is sent to the server by calling
.I pbs_rescquery ()
with a single string resource list of
.Av nodes .
Data from the query is maintained in static memory.
.LP
If the
.At update
flag is zero,  the values from the the prior query is returned from global
memory.   This allows for multiple totpool() and usepool() calls to be
made with only one actual query going to the server.
.LP
The return value is the sum of the number of allocated, reserved, and
down nodes.
.Fn avail()
.Cs
char *avail(int con, char *nodes)
.Ce
.IP Args: 4
.RS
.IP con
is a connection to the server returned by pbs_connect().
.IP nodes
is a node specification requested for a job.  It is the 
.Av nodes=spec
string from the -l option of the qsub for the job.
.RE
.IP Returns:
.RS
.IP \f5yes\fP
The character string "yes" is returned if the requested nodes are available.
If the job is now run, a set of  nodes can be allocated to the job which will
satisified the request.
.IP \f5no\fP
The character string "no" is returned if the requested nodes are not 
currently available.   They may be available at a later time.   Some required
node either is allocated to a job, is off-line, is down, or is reserved.
.IP \f5never\fP
The character string "never" is returned if no combination of the known nodes
will ever satisify the request.   For example the request is for more nodes
than exist.
.IP \f5?\fP
The character string "?" is returned if the request is in error.
.RE
.LP
The nodes specication in the argument
.At nodes
is passed to a 
.I pbs_rescquery() 
call.   Because the specification is generally complex, only the 
.Av avaliable
number returned by the server is meaninful.  If it is greater than zero,
it is the count of the number of nodes in the request and indicates they
are available.   If 
.Av available
is zero, one or more of the requested nodes is currently unavailable.
If negative, the request cannot ever be satified.
.LP
.NH 4
File pbsD_rlsjob.c
.LP
.Fn pbs_rlsjob()
Another call to
.B PBS_manage .
The function 
.B pbs_rlsjob
is a variant of the HoldJob request.
.LP
.NH 4
File pbsD_runjob.c
.LP
.Fn pbs_runjob()
A simple RPC.  The interface is defined in the ERS.
The body is encoded with
.I encode_DIS_RunJob() .
.LP
.NH 4
File pbsD_selectj.c
.LP
.Fn pbs_selectjob()
This function sends a Select Jobs request and places the returned job IDs
in a array.
The static functions
.I PBSD_select_put()
and
.I PBSD_select_get() 
do the work.
.Fn pbs_selstat()
This function also uses
.I PBSD_select_put() 
but to send a Select Status request.   Status of the selected jobs are
returned rather than the Job ID, so the function
.I PBSD_status_get() ,
see PBSD_status.c, is used to process the reply.
.Fn PBSD_select_put()
The static function PBSD_select_put() uses
.I encode_DIS_attropl()
to encode the list of
.Ar attropl
structures which are the job selection criteria.
.Fn PBSD_select_get()
The static function PBSD_select_get() decodes the reply to a Select Job
request and builds the return value, a null terminated array of pointers
to Job IDs.
For historical reasons, the reply structure is build with the Job IDs in a
linked list.
.LP
.NH 4
File pbsD_sigjob.c
.LP
.Fn pbs_sigjob()
A simple RPC.  The interface is described in the ERS.
The function
.I PBSD_sig_put()
does the work of sending the request, see PBSD_sig2.c.
.LP
.NH 4
File pbsD_stagein.c
.LP
This call, provided mainly for the job scheduler, directs the server
to begin staging in files for the specified job.  The body of the request 
is generated by
.I encode_DIS_RunJob() 
Though the header has a different Request ID.
.NH 4
File pbs_statfree.c
.LP
.Fn pbs_statfree()
Deallocates an object of type struct batch_status.
.LP
.NH 4
File pbsD_statjob.c
.LP
.Fn pbs_statjob()
This function is a call to 
.I PBS_status() ,
specifying a job as the type of
object for which status is desired.
.LP
.NH 4
File pbsD_statque.c
.LP
.Fn pbs_statque()
This function is a call to
.I PBS_status() ,
specifying a queue as the type of
object for which status is desired.
.LP
.NH 4
File pbsD_statsrv.c
.LP
.Fn pbs_statsrv()
This function is a call to
.I PBS_status() ,
specifying a server as the type of
object for which status is desired.
.LP
.NH 4
File pbsD_submit.c
.LP
.Fn pbs_submit()
This function trundles through the various components of the job
submission protocol.  First it checks to see that there actually
is a script to send, then it calls
.I PBSD_queuejob
to initiate the protocol.
If that works, then it calls 
.I PBSD_jscript
to send the script to the server.
Next it calls 
.I PBSD_rdytocmt
to indicate that it is prepared to forget about the whole thing.
And if
.I that
works, it then calls
.I PBSD_commit
and returns the job id to the caller.
.LP
.NH 4
File pbsD_termin.c
.LP
.Fn pbs_terminate()
A simple RPC.  The arguments are as described in the ERS.  
The 
.I shutdown
function is sent to the server at the other end of the connection.
The request body is encoded using
.I encode_DIS_ShutDown() .
.LP
.NH 3
.Tc "Request/Reply Encode/Decode Modules"
.LP
The routines that marshal and unmarshal the data being passed in request and
replies are described in this section.  The typical function used to
marshal the data (enc_*.c) takes its parameters and uses the proper sequence
of DIS write routines to encode the data as host independent strings.
The typical function which unmarshals data calls the DIS read routines in the
same order and places the data into a 
.Ar batch_request
or
.Ar batch_reply
structure.
.LP
Unless otherwise noted, these routines return zero on success and a DIS error
code on failure.
.NH 4
File enc_CpyFil.c
.LP
.Fn encode_DIS_CopyFiles()
Encodes the Copy Files request used between the Server and Mom.
The data is taken directly from the
.Ar batch_request
structure.
.LP
Data items sent are:
.Cs
 string          job id
 string          job owner               (may be null string)
 string          execution user name
 string          execution group name    (may be null string)
 unsigned int    direction
 unsigned int    count of file pairs in set
 set of          file pairs:
                 unsigned int    flag
                 string          local path name
                 string          remote path name (may be null string)
.Ce
.NH 4
File enc_JobCred.c
.LP
.Fn encode_DIS_JobCred()
Encodes the request to send an opaque job credential.
.LP
Data items sent are:
.Cs
 unsigned int    Credential type
 string          the credential (octet array)
.Ce
.NH 4
File enc_JobFile.c
.LP
.Fn encode_DIS_JobFile()
Encodes a block of a job related file (script, checkpoint, standard out/error).
Data items sent are:
.Cs
 u int   block sequence number
 u int   file type (stdout, stderr, ...)
 u int   size of data in block
 string  job id
 cnt str data
.Ce
.NH 4
File enc_JobId.c
.LP
.Fn encode_DIS_JobId()
Encodes a Job Id.   This is used in a number of other routines.  The ID is
sent as a string.
.NH 4
File enc_JobObit.c
.LP
.Fn encode_DIS_JobObit()
Encodes a Job Obituary Notice (batch request).
The data sent is:
.Cs
 string          job id
 unsigned int    status
 list of         svrattrl
.Ce
Also see
.I encode_DIS_svrattrl() .
.NH 4
File enc_Manage.c
.LP
.Fn encode_DIS_Manage()
Everybodies favorite routine, encodes the Manage batch request.
Data sent is:
.Cs
 u int          command
 u int          object type
 string         object name
 list of        attropl
.Ce
Also see 
.I encode_DIS_attropl() .
.NH 4
File enc_MoveJob.c
.LP
.Fn encode_DIS_MoveJob()
Encodes a Move Job request.  Data sent is:
.Cs
 string        job id
 string        destination
.Ce
.NH 4
File enc_MsgJob.c
.LP
.Fn encode_DIS_MessageJob()
Encodes a Message Job request.  Data sent is:
.Cs
 string          job id
 unsigned int    which file (fileopt)
 string          the message
.Ce
.NH 4
File enc_QueueJob.c
.LP
.Fn encode_DIS_QueueJob()
Encodes the Queue Job request, part of a Submit job complex request.
Note that a null pointer to either Job ID or Destination is replaced 
with a pointer to the null string so DIS does not go off the deep end.
Data send is:
.Cs
 string  job id
 string  destination
 list of attribute, see encode_DIS_attropl()
.Ce
.NH 4
File enc_Reg.c
.LP
.Fn encode_DIS_Register()
Encodes the Register Dependency request.  Data encoded is:
.Cs
 string          job owner
 string          parent job id
 string          child job id
 unsigned int    dependency type
 unsigned int    operation
 signed long     cost
.Ce
.NH 4
File enc_ReqExt.c
.LP
.Fn encode_DIS_ReqExtend()
This function appends the \*Qentension\*U to each request.   An extension
is provided for sites and/or future modifications.  The extension is a
null terminated character string.  It is not generally used.
.LP
An integer of value 1 or 0 is always sent.   If the extension is not null,
the 1 indicates that the string follows.  Otherwise, 0 is sent as the integer
and no string is sent.
.NH 4
File enc_ReqHdr.c
.LP
.Fn encode_DIS_ReqHdr()
This function encodes the request header that is part of every batch request.
The protocol ID and version are used to validate the protocol and for future
modifications.   The header contains the batch request ID which identifies
the type of request and hence the format of the request body.   The body is
always followed by the extension, at least the extension flag.
.LP
Data encoded is:
.Cs
 u int     Protocol ID
 u int     Protocol version
 u int     Request ID
 string    Name of user making the request
.Ce
.NH 4
File enc_RunJob.c
.LP
.Fn encode_DIS_RunJob()
Encodes a Run Job (and other) request.  Data sent is:
.Cs
 string          job id
 string          destination
 unsigned int	 resource_handle (reserved for future use)
.Ce
.NH 4
File enc_Shut.c
.LP
.fn encode_DIS_ShutDown()
Encodes a Terminate (shutdown) server request.  Data encoded is:
.Cs
unsigned int    manner
.Ce
.NH 4
File enc_Sig.c
.LP
.Fn encode_DIS_SignalJob()
Encodes a Signal Job request.  Data encoded is:
.Cs
 string          job id
 string          signal
.Ce
.LP
Note the signal may be either the name of the signal or its value, but in
either case it is a string.
.NH 4
File enc_Status.c
.LP
.Fn encode_DIS_Status()
Encodes a status (job, queue, server) request.  The request type identifies
which.  The data encoded is:
.Cs
 string          object id
 list of         attrl,     see encode_DIS_attrl()
.Ce
.NH 4
File enc_Track.c
.LP
.Fn encode_DIS_TrackJob()
Encode a track job report (request).   Data encoded is:
.Cs
 string          job id
 unsigned int    hop count
 string          new location
 u char          job state
.Ce
.NH 4
File enc_attrl.c
.LP
.Fn encode_DIS_attrl()
Used to encode a list of
.Ar attrl
structures as defined in the API.
The very first data item encoded is an unsigned integer giving the
number of attrl entries in the list.  This may be zero, in which case
nothing else follows.  Then for each entry, the following is encode:
.Cs
 u int   size of the three strings (name, resource, value), including
         the terminating nulls
 string  attribute name
 u int   1 or 0 if resource name does or does not follow
 string  resource name (if one)
 string  value of attribute/resource
 u int   "op" of attrlop, forced to "Set"
.Ce
.NH 4
File enc_attropl.c
.LP
.Fn encode_DIS_attropl() 
This is identical to the above function with the addition of the 
.I op
field.  Following the initial count of list items, the following data is sent:
.Cs
 u int   size of the three strings (name, resource, value) including
         the terminating nulls
 string  attribute name
 u int   1 or 0 if resource name does or does not follow
 string  resource name (if one)
 string  value of attribute/resource
 u int   "op" of attrlop
.Ce
.NH 4
File enc_reply.c
.LP
.Fn encode_DIS_reply()
Encodes a Batch Reply structure,
.Ar batch_reply .
This function does it all, the reply header and the reply union.
The header consists of:
.Cs
 u int        Protocol type
 u int        Protocol version
 u int        Return code
 u int        Auxiliary return code
 u int        Union discriminator
.Ce
.LP
The reply union then follows.   It is one of the following sets of data:
.Cs
Null Reply

  nothing else is sent

Queue Reply, Ready to Commit Reply, or Commit Reply

  string     Job Id

Select Reply

  u int      A count of the number of Job Ids, if 0 nothing else follows
  sequence of Job Id strings

Status Reply

  u int      Number of status reply objects which follow

  u int      Object type
  string     Object name
  list of attropl,         see encode_DIS_svrattrl()

Text Reply

  string     counted byte string

Locate Job reply

  string     location of job
.Ce
.LP
One weirdness in this is that a status reply may be
.I decoded
into one of three forms, but they have only one source format and on the
wire they all look alike.  The server maintains attributes in a
.Ar svrattrl
structure which is the source format. The server decodes into the same
form while the API routines deal with either 
.Ar attrl
or
.Ar attropl
structures.  Regardless sof which structure will be the destination, the format
on the wire closely resembles that of the attropl.   See encode_DIS_svrattrl(),
encode_DIS_attrl(), and encode_DIS_attropl().
.NH 4
File enc_svrattrl.c
.LP
.Fn encode_DIS_svrattrl()
This encodes a list of the server's
.Ar svrattrl
structures.  The first item encodes is a unsigned integer count of the
number of items in the list.  If zero, no more data is encoded as part of
this sequence.  Then for each structure in the list:
.Cs
 u int   size of the three strings (name, resource, value) including the
         terminating nulls.
 string  attribute name
 u int   1 or 0 if resource name does or does not follow
 string  resource name (if one)
 string  value of attribute/resource
 u int   "op" of attrlop
.Ce
.NH 4
File dec_Authen.c
.LP
.Fn decode_DIS_Authen()
Used by the Job Server to to decode the Authenticate User request body
sent by the pbs_iff process.  The useful data items are the user name from
the header, already decoded, and the one item from the body, the unsigned
integer port number from which the client has connected.
.NH 4
File dec_CpyFil.c
.LP
.Fn decode_DIS_CopyFiles()
Used by MOM to decode the body of a Copy Files request.  The data in the
request is:
.Cs
 string          job id                  (may be null)
 string          job owner               (may be null)
 string          execution user name
 string          execution group name    (may be null)
 unsigned int    direction
 unsigned int    count of file pairs in set
 set of          file pairs:
         unsigned int    flag
         string          local path name
         string          remote path name (may be null)
.Ce
.NH 4
File dec_JobCred.c
.LP
.Fn decode_DIS_JobCred()
Used by the server to decode a Job Credential request (currently not used).
The data items are:
.Cs
 unsigned int    credential type
 counted string  the message
.Ce
.NH 4
File dec_JobFile.c
.LP
.Fn decode_DIS_JobFile()
Used by the server or Mom to decode Job Related Job File Move request.
Data items are:
.Cs
 u int           block sequence number
 u int           file type (stdout, stderr, ...)
 u int           size of data in block
 string          job id
 counted string  data
.Ce
.NH 4
File dec_JobId.c
.LP
.Fn decode_DIS_JobId()
The Job Id, a simple string, is decoded into a fixed size character array
using
.I disrfst() . 
This saves having to copy it in memory.
.NH 4
File dec_JobObit.c
.LP
.Fn decode_DIS_JobObit()
Used by the server to decode a Job Obituary Notice (request).  Data items are:
.Cs
 string          job id
 unsigned int    status
 list of         svrattrl,  see decode_DIS_svrattrl()
.Ce
.NH 4
File dec_Manage.c
.LP
.Fn decode_DIS_Manage()
Used by the server and Mom to decode the body of a number of requests.
The request id is in the header which has already be decoded.
.LP
The data decoded is:
.Cs
 unsigned int    command
 unsigned int    object type
 string          object name
 list of attropl attributes,   see decode_DIS_svrattrl()
.Ce
.NH 4
File dec_MoveJob.c
.LP
.Fn decode_DIS_MoveJob()
Used by the server to decode a Move Job request body, also the Order Job body.
Data decoded is:
.Cs
 string          Job ID
 string          destination or second Job ID
.Ce
.NH 4
File dec_MsgJob.c
.LP
.Fn decode_DIS_MessageJob()
Used by the server and Mom to decode a Message Job request.  The data items are:
.Cs
 string          job id
 unsigned int    which file
 string          the message
.Ce
.NH 4
File dec_QueueJob.c
.LP
.Fn decode_DIS_QueueJob()
Used by the server and Mom to decode the Queue Job request which is part of
the complex send job sequence.  Data decoded is:
.Cs
 string  job id
 string  destination
 list of attributes (attropl),  see decode_DIS_svrattrl()
.Ce
.NH 4
File dec_Reg.c
.LP
.Fn decode_DIS_Register()
Used by the server to decode the Register Job Dependency request body.
Data decoded is:
.Cs
 string          job owner
 string          parent job id
 string          child job id
 unsigned int    dependency type
 unsigned int    operation
 signed long     cost
.Ce
.NH 4
File dec_ReqExt.c
.LP
.Fn decode_DIS_ReqExtend()
This function is used by the server and Mom to decode the optional extension
field on a batch request.  The first data item is a unsigned integer.  A
value of one indicates a string follows, zero says it does not.
.NH 4
File dec_ReqHdr.c
.LP
.Fn decode_DIS_ReqHdr()
This function is used by the server and Mom to decode the batch request 
header.   The header contains, among other things, the request ID.  The body
which follows is decoded based on the id.   Data decoded is:
.Cs
 unsigned int   Protocol ID
 unsigned int   Protocol Version
 unsigned int   Request  ID
 string         Name of user making the request
.Ce
.NH 4
File dec_RunJob.c
.LP
.Fn decode_DIS_RunJob()
This function is used by the server to decode the body of the Run Job and
Async Run Job request.  Data decoded is:
.Cs
 string          job id
 string          destination
 unsigned int	 resource_handle (reserved for future use)
.Ce
.NH 4
File dec_Shut.c
.LP
.Fn decode_DIS_ShutDown()
This function is used by the server to decode the body of the Server Shutdown
(terminate) request.  Data decoded is one unsigned integer for the manner of
shutdown.
.NH 4
File dec_Sig.c
.LP
.Fn decode_DIS_SignalJob()
Used by the server and Mom to decode the Signal Job request.  Data decoded is:
.Cs
 string          job id
 string          signal name or numeric string of value
.Ce
.NH 4
File dec_Status.c
.LP
.Fn decode_DIS_Status()
This decodes the body for a Status Job, Status Queue, or Status Server request.
Data decoded is:
.Cs
 string          Job ID
 list of         attrl,		see decode_DIS_svrattrl()
.Ce
.NH 4
File dec_Track.c
.LP
.Fn decode_DIS_TrackJob()
Used to decode the Track Job Notice (request) by the server.  Data is:
.Cs
 string          Job ID
 unsigned int    hop count
 string          location (new server name)
 u char          state
.Ce
.NH 4
File dec_attrl.c
.LP
.Fn decode_DIS_attrl()
This is a support routine used by API routines, not the servers, when decoding
a list of attrl, attropl, or svrattrl which are all the same on the wire.
This routine is used when the destination structure is a 
.Ar attrl .
.LP
Data decoded is:
.Cs
 u int   number of attrl in list,    if non-zero it is followed by for each:

 u int   size of the three strings (name, resource, value)
 string  attribute name
 u int   1 or 0 if resource name does or does not follow
 string  resource name (if one)
 string  value of attribute/resource
 u int   "op" of attrlop
.Ce
The \*Qop\*U is discarded for an attrl.
.NH 4
File dec_attropl.c
.LP
.Fn decode_DIS_attropl()
This is a support routine used by API routines, not the servers, when decoding
a list of attrl, attropl, or svrattrl which are all the same on the wire.
This routine is used when the destination structure is a 
.Ar attropl .
.LP
Data decoded is:
.Cs
 u int   number of attrl in list,    if non-zero it is followed by for each:

 u int   size of the three strings (name, resource, value)
 string  attribute name
 u int   1 or 0 if resource name does or does not follow
 string  resource name (if one)
 string  value of attribute/resource
 u int   "op" of attrlop
.Ce
.NH 4
File dec_rpyc.c
.LP
.Fn decode_DIS_replyCmd()
This support routine is used to decode the reply sent by a server in response
to a request.  It is used by the 
.B API .
It differs from
.I decode_DIS_replySvr() 
in the structures used by the server and API to hold status data.
The expected data consist of the reply header:
.Cs
 u int   protocol type
 u int   protocol version
 u int   return code
 u int   auxiliary return code
 u int   union choice discriminator
.Ce
The remainder of the data depends on the type of reply given by the
union choice discriminator.  The union data is described under
.I encode_DIS_reply() .
.NH 4
File dec_rpys.c
.LP
.Fn decode_DIS_replySvr()
This function is used by a server to decodes a batch reply.
It is used by the
.B server .
It differs from
.I decode_DIS_replyCmd() 
in the structures used by the server and API to hold status data.
The data decoded is described under decode_DIS_replyCmd() and
encode_DIS_reply().
.NH 4
File dec_svrattrl.c
.LP
.Fn decode_DIS_svrattrl()
Another support routine used when decoding data for the server.
This routine is like
.I decode_DIS_attrl()
and
.I decode_DIS_attropl()
except that the data is placed into a 
.Ar svrattrl
structure.  See decode_DIS_attrl() for the data decoded.
.NH 4
File tcp_dis.c
.LP
This file contains functions used as I/O primitivies by DIS encode/decode
routines when the data is being moved over TCP/IP.
Support routines to handle the data buffers are also included.
.LP
The DIS routines use the following I/O primitivies via a set of function
pointers:
.IP dis_getc
Get a single character from the source; for tcp set to 
.I tcp_getc() .
.IP dis_gets
Get a string from the source; for tcp set to
.I tcp_gets() .
.IP dis_puts
Put a string to the sink; for tcp set to
.I tcp_puts() .
.IP dis_skip
Skip over bytes in the source; for tcp (unused but) set to
.I tcp_rskip() .
.IP disr_commit
Advance/restore the pointer to commited data in the read buffer, for tcp set to
.I tcp_rcommit .
.IP disw_commit
Advance/restore the pointer to commited data in the write buffer, for tcp set to
.I tcp_wcommit .
.LP
For tcp, the get and put routines work out of a pair of buffers, one for write
(put) and one for read (get).   When the read buffer is empty or the write
buffer is full, 
.I tcp_read()
or 
.I tpc_write()
is called to fill or empty the buffer as required.
.Fn tcp_pack_buff()
.Cs
static void tcp_pack_buff(int n)
.Ce
.IP Args:
.RS
.IP n
0 for input buffer, 1 for output buffer
.RE
.LP
This routine packes the buffer by moving any uncommited data to the beginning
and adjusting the pointers.
.Fn tcp_read()
.Cs
static int tcp_read(int fd)
.Ce
.IP Args:
.RS
.IP fd
the file descriptor/socket from which to read
.RE
.IP Returns:
.RS
.IP >0
number of characters read
.IP 0
EOF
.IP <0
on error
.RE
.LP
Any data left in the buffer and as yet unread, is moved to the beginning by
.I tcp_pack_buff()
.LP
An original read typically follows a select() indicating that data is ready
to be read.   But if not all of the required data in a request is sent,
the reader could \*Qhang\*U waiting for more, a bad thing for a server.
Hence, a local select() with a timeout is performed before the blocking read.
A default timeout of 120 seconds is provided.   If data does not arrive within
the timeout period, a "premature end of data" is returned.
.LP
Data is read into the buffer and the EOD (end of data) pointer set after it.
.Fn DIS_tcp_wflush()
.Cs
int DIS_tcp_wflush(int fd)
.Ce
.IP Args:
.RS
.IP fd
file descriptor/socket to which to write
.RE
.IP Returns:
zer on success, -1 on error
.LP
Any \*Qcommitted\*U data (between the start of the buffer and the trailing
pointer) in the write buffer is writted to
.Av fd .
The buffer is packed by
.I tcp_pack_buff() .
.Fn DIS_tcp_reset()
.Cs
void DIS_tcp_reset(int fd, int i)
.Ce
.IP Args:
.RS
.IP i
0 for input buffer, 1 for output buffer
.RE
.LP
The various pointers for the buffer used by the specified file descriptor
are reset to the beginning of the buffer.
.Fn tcp_rskip()
.Cs
static int tcp_rskip(int fds, size_t ct)
.Ce
.IP Args:
.RS
.IP fds
file/socket descriptor.
.IP ct
Amount of data in the read buffer to skip over.
.RE
.IP Returns
always 0
.LP
This function is unused in PBS.
.Fn tcp_getc()
.Cs
static int tcp_getc(int fd)
.Ce
.IP Args:
.RS
.IP fd
file/socket descriptor on which to read data
.RE
.IP Returns:
Character \*Qread\*U or -1 if error/eof
.LP
Returns the next character from the read buffer.   If the buffer is empty,
.I tcp_read()
is called to fill it.
.Fn tcp_gets()
.Cs
static int tcp_gets(int fd, char *str, size_t ct)
.Ce
.IP Args:
.RS
.IP fd
file/socket descriptor on which to read data
.IP str
pointer to location to deliver array of bytes
.IP ct
number of bytes to deliver
.RE
.IP Returns:
Number of bytes delivered or -1 on error/eof
.LP
Returns 
.Ar ct
characters from the read buffer.   If the buffer is empty,
.I tcp_read()
is called to fill it.
.Fn tcp_puts()
.Cs
static int tcp_puts(int fd, char *str, size_t ct)
.Ce
.IP Args:
.RS
.IP fd
file/socket descriptor on which to write data
.IP str
pointer to source of array of bytes to copy into the buffer
.IP ct
number of bytes to write
.RE
.IP Returns:
Number of bytes copied or -1 on error/eof
.LP
.Ar ct
bytes are moved from
.Ar str
to the write buffer.   If there is insufficient room, the buffer is written by
.I DIS_tcp_wflush() .
.Fn tcp_rcommit()
.Cs
static int tcp_rcommit()
.Ce
.IP Args:
.RS
.IP fp
unused
.IP commit_flag
commit forward/backward
.RE
.IP Returns
always zero
.LP
If
.Ar commit_flag
is true, commit the data in the read buffer by advancing the trailing pointer
to the leading pointer.
If false, uncommit data by the reverse operation.
.Fn tcp_wcommit()
Identical to above except works on write buffer.
.Fn DIS_tcp_setup()
.Cs
void DIS_tcp_setup(int fd)
.Ce
Sets up the DIS function pointers to use the above TCP based routines.
Also sets up a buffer for the given file descriptor and
resets the read and write buffer pointers.
.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[This page is blank.]
.DE
.bp
\}
