.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.so ids_setup.ms
.Rv $Revision: 2.2 $
.nr Fi 0 1
.sp 3
.in +0.7i
.sp 0.22i
.vs 11
.ps +22
P
.br
\h'11p'B\ \ 
.ps -4
\v'-4p'Portable Batch System\v'4p'
.br
.ps +4
\h'21p'S
.br
.ps -22
.vs 12
\l'4.9i'
.br
.in -0.8i
.sp 3
.TL
Internal Design Specification
.AU
Albeaus Bayucan
Casimir Lesiak
Bhroam Mann
Robert L. Henderson
Tom Proett
Dave Tweten \(dg
.FS \(dg
Numerical Aerospace Simulation Systems Division,
NASA Ames Research Center, Moffett Field, CA
.FE
.sp 1
.AI
.B "MRJ Technology Solutions"
2672 Bayshore Parkway
Suite 810
Mountain View,  CA 94043
http://pbs.mrj.com
.sp
.so ../ers/release.ms
.br
Printed: \*(DY
.LP
.OH ''PBS IDS''
.EH ''PBS IDS''
.bp
\ 
.bp
.nr % 1
.OF '''pf%-'
.EF 'pf%'''
.DS C
\s+2\f3Portable Batch System (PBS) Software License\fP\s-2
.sp
Copyright \(co 1999, MRJ Technology Solutions.
.br
All rights reserved.
.DE
.LP
Acknowledgment: The Portable Batch System Software was originally developed
as a joint project between the Numerical Aerospace Simulation (NAS) Systems
Division of NASA Ames Research Center and the National Energy Research
Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.LP
Redistribution of the Portable Batch System Software and use in source
and binary forms, with or without modification, are permitted provided
that the following conditions are met:
.IP -
Redistributions of source code must retain the above copyright and
acknowledgment notices, this list of conditions and the following disclaimer.
.IP -
Redistributions in binary form must reproduce the above copyright and
acknowledgment notices, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution.
.IP -
All advertising materials mentioning features or use of this software must
display the following acknowledgment:
.RS
.QP
This product includes software developed by NASA Ames Research
Center, Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.RE
.sp
.LP
.ce
DISCLAIMER OF WARRANTY
.QP
THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT
WARRANTY OF ANY KIND,  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,  FITNESS
FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY  DISCLAIMED.
.QP
IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
THE U.S. GOVERNMENT  BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
NOR ANY  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.LP
This license will be governed by the laws of the Commonwealth of Virginia,
without reference to its choice of law rules.
.LP
This product includes software developed by the NetBSD
Foundation, Inc. and its contributors.
.LP
.bp
.DS C
PBS Revision History
.DE
.so ../ers/rel_history.ms
\"
\" The TOC follows
.bp
.XS pf1
PBS License Agreement
.XE
.XS pf2
Revision History
.so ids_toc.input
.XE
.LG
Table of Contents
.NL
.sp
.PX no
.bp
.if e \{
\&
.sp 10
.DS C
[This page is blank.]
.DE
.OH ''PBS IDS'Introduction'
.EH 'Introduction'PBS IDS''
.bp
\}
\" New section, the introduction, follows this line
.nr % 1
.nr H1 0
.NH 1
.Tc \f3\s+2Introduction\s-2\fP
.LP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
The Portable Batch System is a product designed and developed at the
Numerical Aerodynamic Simulation Systems Division at NASA's Ames
Research Center, and at the Livermore Computer Center and National
Energy Research Supercomputer Center, both at Lawrence Livermore National Labs.
.LP
This product provides support for batch processing on POSIX\**
.FS
Copyright IEEE, see IEEE standards 1003.1, 1003.2, and 1003.2d.
.FE
and UNIX\**
.FS
Unix is a trademark of USL.
.FE
systems.
.NH 2
.Tc \f3Purpose\fP
.LP
This document is the
.nh
.UL Portable
.UL Batch
.UL System
.UL Internal
.UL Design
.UL Specification ,
.hy
also called the
.B IDS .
The IDS describes the detailed design of the Portable Batch System,
.B PBS .
Included in this design is detailed information about each package
that makes up PBS, the programs that make up each package, the files
and functions that make up each program.
The level of detail is such to provide an experienced C language and Unix
programmer with all the information required to understand, maintain, and
expand PBS.
.LP
The structure of this document is provided by figure \n(H1\-\n+(Fi.
.DS B
.so ids_struct.pic
.sp
.ce
\f3Figure \n(H1\-\n(Fi: IDS Document Structure\f1
.DE
.LP
Two other documents are provided as part of the
.B PBS
package, the
.nh
.UL Portable
.UL Batch
.UL System
.UL Requirements
.UL Specification ,
.hy
the Requirements Spec,
and the
.nh
.UL Portable
.UL Batch
.UL System
.UL External
.UL Reference
.UL Specification ,
.hy
the ERS.
It is strongly recommended that those two documents be read before
attempting to delve into this document.
.NH 2
.Tc \f3Glossary\fP
.LP
In order to save trees, the glossary is not reproduced here.  Please
refer to the glossary section of the PBS ERS.
.LP
.NH 2
.Tc \f3System Overview\fP
.LP
.NH 3
.Tc \f3Batch Pre-history\fP
.LP
.B PBS
was developed to provide support for batch processing.
As opposed to simply placing a process in the background,
batch processing encompasses the scheduling of multiple jobs according
to a policy of system resource management.  Each job may consist of
multiple processes.  Jobs may be routed to processing hosts over
a network.  Resources may be reserved for a job before its execution
begins, and limits are established on the consumption of resources by
the job.
This goes well beyond the traditional process scheduling provided by
Unix systems.
.LP
Other batch systems have been developed for Unix system.  The most
well know was NQS, also developed at the Numerical Aerodynamic Simulation
Systems Division, NAS.
.B PBS
was developed to:
.IP - 3
Overcome the problems associated with NQS.
.IP - 3
Extend the features of NQS.
.IP - 3
Be a superset of the POSIX Batch Extensions Standard, P1003.2d.
.IP - 3
Provide a growth platform for batch cluster computing and distributed jobs.
.LP
.NH 3
.Tc PBS Overview
.LP
The PBS batch system consist of the following major sections:
.IP 1. 4
The user/operator/administrator client commands which are discussed in chapters
2, 3, and 4.
.IP 2.
The main server, pbs_server, which is the focal point for all client 
communication and manages the batch jobs.  It is covered in chapter 5.
.IP 3.
The job scheduler, pbs_sched, which determines which jobs should be executed.
There are two supplied version discussed in chapter 6.
.IP 4.
The job executor and resource monitor, pbs_mom,
which manages job execution and monitors system activity and resource
usage on a "per host" basis.
MOM's resource monitor functons are covered in chapter 7 and
job executor functons are described in chapter 8.
.IP 5.
The user client authentication system is covered in chapter 9.
.IP 6.
A number of libraries, including the API, are discussed in chapter 10.
.IP 8.
The network based interprocess communication between the client commands and
the server, between the server and MOM, and between the server and the scheduler
is covered in chapter 11.
.LP
The design concept of PBS follows the \*Qclient \- server\*U paradigm.
Clients make requests of the server to perform actions on a set of objects.
The actions
include creation, deletion, modification, and status.
There are three classes of objects known to the PBS Server:  server, queue, and
job.  The PBS job executor, MOM,  is also aware of the job object, but not
the others.
.LP
The server owns and manages all batch jobs.  All access to jobs are
through requests the server.
The server performs other services for jobs on a time or event driven
basis.
These services are known as deferred services.
Deferred services include initiation into execution, routing to
processing hosts, and resource management.
.LP
Queues are collection points for jobs.  The term queue is used for
historical reasons, it does not imply any ordering of jobs within the queue.  
A better term might have been \*Qpool\*U.
.LP
Each of the objects discussed above consist of a name and a set of attributes.
Attributes are a data name and data value.   The objects and their attributes
are discussed in great detail at the start of chapter 5.
.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[This page is blank.]
.DE
.bp
\}
