.nr % 1
.OH ''PBS IDS'User Commands'
.EH 'User Commands'PBS IDS''
.P1
.so ids_setup.ms
.Rv $Revision: 2.1 $
.nr H1 1
.NH 1
.Tc \f3\s+2User Commands\s-2\fP
.LP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.NH 2
.Tc "\f3User Commands Overview\fP"
.LP
This section describes the commands available to the general user.
Unless otherwise noted, the command must conform to the POSIX.15 specification
of the command as to syntax and functionality.
.LP
When more than one operand is specified on the command line,
the command processes each operand in turn.
An error reply from a server
on one operand will be noted in the standard error stream.  The command
continues processing the other operands.  If an error
reply was received for any operand, the final exit status for the
command will be greater than zero.
.NH 2
.Tc \f3Packaging\fP
.LP
The source code for each of these routines consists a single file for each
routine and a set of library routines that are shared among some of the other
programs.  The main file for each command contains a section that parses the
execute line options followed by a loop that executes the appropriate command
for each operand on the command line.  The library has routines for holding 
attributes created from the options, separating the parts of each operand, and 
related functions.
.NH 2
.Tc \f3Program: qalter\fP
.LP
The
.B qalter
command modifies the attributes of the job or jobs specified
by
.Ar "job_identifier"
on the command line.
Only those attributes listed as options on the command will be modified.  
If any of the specified attributes cannot be modified for a job for any reason, 
none of that jobs attributes will be modified.
.LP
The 
.B qalter
command accomplishes the modifications by sending a
.I "Modify Job"
batch request to the batch server which owns each job.
.NH 3
.Tc Overview
.LP
Parse the options on the execute line and build up an attribute list.
For each job given, send the attribute list in the 
.I "Modify Job"
batch request to the batch server which owns each job.
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the qalter command, the exit status will be a value of zero.
.LP
If the qalter command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi qalter.c
.LP
This file contains the main routine only.  All other functions are in the
library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
[\-a\ date_time] [\-A\ account_string] [\-c\ interval] [\-e\ path]
[\-h\ hold_list] [\-j\ join] [\-k\ keep] [\-l\ resource_list] 
[\-m\ mail_options] [\-M\ user_list] [\-N\ jobname] [\-o\ path] [\-p\ priority]
[\-r\ c] [-S\ path] [\-u\ user_list] [\-W\ dependency_list] job_identifier...
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
None are used by the main routine, but some may be used by the library. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
Use getopt to get each option
	Build the attribute list for the modify job request
	Get appropriate path name where needed
For each remaining operand
	Determine the job identifier and server name
cnt:
	Connect to the server
	Send the modify job request
	f Unknown Job Id and not Located Then
		Locate job
		go to cnt
	Disconnect from the server
.fi
.RE
.NH 2
.Tc \f3Program: qdel\fP
.LP
The 
.B qdel 
command deletes jobs in the order in which
their job identifiers are presented to the command.
A job is deleted by sending a 
.I "Delete Job"
batch request to the batch server that owns the job. 
A job that has been deleted is no longer subject to management by 
batch services. 
.NH 3
.Tc Overview
.LP
Parse the options on the execute line.
For each job on the execute line send a 
.I "Delete Job"
batch request to the batch server that owns the job. 
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the qdel command, the exit status will be a value of zero.
.LP
If the qdel command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi qdel.c
.LP
This file contains the main routine only.  All other functions are in the
library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
[\-W\ delay] job_identifier...
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
None are used by the main routine, but some may be used by the library. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
Use getopt to get each option
	Build the delay argument for the delete job request
For each remaining operand
	Determine the job identifier and server name
cnt:
	Connect to the server
	Send the delete job request
	f Unknown Job Id and not Located Then
		Locate job
		go to cnt
	Disconnect from the server
.fi
.RE
.NH 2
.Tc \f3Program: qhold\fP
.LP
The 
.B qhold 
command requests that a server place one or more holds on
a job.  A job that has a hold is not eligible for execution.
The 
.B qhold
command sends a
.I "Hold Job"
batch request to the server that owns the job.
.NH 3
.Tc Overview
.LP
Parse the options on the execute line.
For each job on the execute line send a 
.I "Hold Job"
batch request to the batch server that owns the job. 
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the qhold command, the exit status will be a value of zero.
.LP
If the qhold command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi qhold.c
.LP
This file contains the main routine only.  All other functions are in the
library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
[\-h\ hold_list] job_identifier ...
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
None are used by the main routine, but some may be used by the library. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
Use getopt to get each option
	Set the hold type and expedite flag
For each remaining operand
	Determine the job identifier and server name
cnt:
	Connect to the server
	Send the hold job request
	f Unknown Job Id and not Located Then
		Locate job
		go to cnt
	Disconnect from the server
.fi
.RE
.NH 2
.Tc \f3Program: qmove\fP
.LP
To move a job is to remove the job from the queue in which it 
resides and instantiate the job in another queue. 
The
.B qmove
command issues a 
.I "Move Job"
batch request to the batch server that currently owns each job.
.NH 3
.Tc Overview
.LP
Get the destination from the execute line, and for each remaining argument,
move the requested job to the destination queue.
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the qmove command, the exit status will be a value of zero.
.LP
If the qmove command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi qmove.c
.LP
This file contains the main routine only.  All other functions are in the
library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
destination job_identifier ...
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
None are used by the main routine, but some may be used by the library. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
The first argument is the destination
For each remaining operand
	Determine the job identifier and server name
cnt:
	Connect to the server
	Send the move job request
	f Unknown Job Id and not Located Then
		Locate job
		go to cnt
	Disconnect from the server
.fi
.RE
.NH 2
.Tc \f3Program: qmsg\fP
.LP
The
.B qmsg
command writes messages into the files of jobs
by sending a 
.I "Job Message"
batch request to the batch server that owns the job.
.NH 3
.Tc Overview
.LP
Parse the options on the execute line.  The argument after any options is the
message.  Send the message to each job indicated by the remaining operands.
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the qmsg command, the exit status will be a value of zero.
.LP
If the qmsg command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi qmsg.c
.LP
This file contains the main routine only.  All other functions are in the
library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
[-E] [-O] message_string job_identifier ...
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
None are used by the main routine, but some may be used by the library. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
Use getopt to get each option
	Set the tofile flag
The next argument is the message string
For each remaining operand
	Determine the job identifier and server name
cnt:
	Connect to the server
	Send the job message request
	f Unknown Job Id and not Located Then
		Locate job
		go to cnt
	Disconnect from the server
.fi
.RE
.NH 2
.Tc \f3Program: qrerun\fP
.LP
The 
.B qrerun
command directs that the specified jobs are to be rerun if possible.
.NH 3
.Tc Overview
.LP
For each operand try rerunning the job.
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the qrerun command, the exit status will be a value of zero.
.LP
If the qrerun command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi qrerun.c
.LP
This file contains the main routine only.  All other functions are in the
library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
job_identifier ...
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
None are used by the main routine, but some may be used by the library. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
For each operand
	Determine the job identifier and server name
cnt:
	Connect to the server
	Send the rerun job request
	f Unknown Job Id and not Located Then
		Locate job
		go to cnt
	Disconnect from the server
.fi
.RE
.NH 2
.Tc \f3Program: qrls\fP
.LP
The
.B qrls
command removes or releases holds which exist on batch jobs.
.NH 3
.Tc Overview
.LP
Parse the execute line to get the hold type.  For each remaining operand
release the hold on the indicated job.
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the qrls command, the exit status will be a value of zero.
.LP
If the qrls command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi qrls.c
.LP
This file contains the main routine only.  All other functions are in the
library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
[-h hold_list] job_identifier ...
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
None are used by the main routine, but some may be used by the library. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
Use getopt to get each option
	Set the hold type
For each remaining operand
	Determine the job identifier and server name
cnt:
	Connect to the server
	Send the release job request
	f Unknown Job Id and not Located Then
		Locate job
		go to cnt
	Disconnect from the server
.fi
.RE
.NH 2
.Tc \f3Program: qselect\fP
.LP
The
.B qselect
command provides a method to list the job identifier of those
jobs which meet a list of selection criteria.
.NH 3
.Tc Overview
.LP
Parse the options on the execute line and build up an attribute list.
For each job given, send the attribute list in the 
.I "Select Job"
batch request to the batch server which owns each job.
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the qselect command, the exit status will be a value of zero.
.LP
If the qselect command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi qselect.c
.LP
This file contains the main routine and some other functions related to job
selection only.  All other functions are in the library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
[\-a\ [op]date_time] [\-A\ account_string] [\-c\ [op]interval]
[\-h\ hold_list] [\-l\ resource_list] [\-N\ name] [\-p\ [op]priority]
[\-q\ destination] [\-r\ c] [-s states] [\-u\ user-name]
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
None are used by the main routine, but some may be used by the library. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
Use getopt to get each option
	Build the attribute list for the select job request
If destination is given Then
	Determine the queue and server name
Connect to the server
Send the select job request
Print the job identifiers returned
Disconnect from the server
.fi
.RE
.NH 4
.Fn set_attrop()
.Cs
void set_attrop(struct attropl **list, char *name, char *resource, char *value, enum batch_op op)
.Ce
.IP Args: 4
.RS
.IP list 8
The attribute list.
.IP name 8
The name part of the attribute.
.IP resource 8
The resource part of the attribute.
.IP value 8
The value part of the attribute.
.IP op 8
The operation part of the attribute.
.RE
.LP
Control Flow:
.RS
.nf
Allocate the memory for an attribute structure
If name is defined Then
	Allocate the memory for the name part
	Copy the name part
If resource is defined Then
	Allocate the memory for the resource part
	Copy the resource part
If value is defined Then
	Allocate the memory for the value part
	Copy the value part
Set the operation part
Add the attribute structure to the beginning of the attribute list
.fi
.RE
.NH 4
.Fn check_op()
.Cs
void check_op(char *opstring, enum batch_op *op, char *value)
.Ce
.IP Args: 4
.RS
.IP opstring 8
The operator and value string from the command line.
.IP op 8
The operator part of the string turned into an enum batch_op. The operator
defaults to EQ if none is given.
.IP value 8
The value part of the string.
.RE
.LP
Control Flow:
.RS
.nf
Set the operatro to EQ
If opstring contains an operator Then
	Find out which operator was used
Copy the value part
.fi
.RE
.NH 4
.Fn check_res_op()
.Cs
int check_res_op(char *resources, char *name, enum batch_op *op, char *value, char **position)
.Ce
.IP Args: 4
.RS
.IP resources 8
The comma delimited list of resources. The list looks like
.nf

name op value, ...

.fi
.IP name 8
The resource name.
.IP op 8
The operator.
.IP value 8
The value.
.IP position 8
The next position in the resource list to parse.
.RE
.IP Returns: 4
Zero, if the resource list is parsed correctly, one otherwise.
.LP
Control Flow:
.RS
.nf
Scan for the resource name
Find out which operator was used
Scan for the resource value
Set the next character position
.fi
.RE
.NH 4
.Fn check_user()
.Cs
int check_user(char *users, enum batch_op *op, char *user, char **position)
.Ce
.IP Args: 4
.RS
.IP users 8
The comma delimited list of users.
.IP op 8
The operator is always EQ.
.IP user 8
The next user name in the list.
.IP position 8
The next character position to parse in the list.
.RE
.IP Returns: 4
Zero, there are no errors.
.LP
Control Flow:
.RS
Set the operator to EQ
Scan for the user name
.RE
.NH 2
.Tc \f3Program: qsig\fP
.LP
The
.B qsig
command requests that a signal be sent to executing batch jobs.
.NH 3
.Tc Overview
.LP
Parse the execute line to get the signal.  For each remaining operand
send the signal to the indicated job.
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the qsig command, the exit status will be a value of zero.
.LP
If the qsig command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi qsig.c
.LP
This file contains the main routine only.  All other functions are in the
library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
[-s signal] job_identifier ...
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
None are used by the main routine, but some may be used by the library. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
Use getopt to get each option
	Set the signal
For each remaining operand
	Determine the job identifier and server name
cnt:
	Connect to the server
	Send the signal job request
	If Unknown Job Id and not Located Then
		Locate job
		go to cnt
	Disconnect from the server
.fi
.RE
.NH 2
.Tc \f3Program: qstat\fP
.LP
The
.B qstat
command is used to request the status of jobs, queues, or a batch server.
.NH 3
.Tc Overview
.LP
Parse the execute line for options and set the mode of the status request.
Depending on the mode set, give the status of the jobs listed on the execute
line, the queues listed on the execute line, or the server.
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the qstat command, the exit status will be a value of zero.
.LP
If the qstat command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi qstat.c
.LP
This file contains the main routine and some other functions related to job
status only.  All other functions are in the library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
[-f] [\^job_identifier... | destination...\^]
.sp
-Q [-f] [\^destination...\^]
.sp
-B [-f] [\^server_name\^]
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
None are used by the main routine, but some may be used by the library. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
Use getopt to get each option
	Set the full display flag and the mode of the status request
If no operands Then
	Case mode is
	job:
		Set default job id and server name
		go to job_no_args
	queue:
		Set default queue name
		go to queue_no_args
	server:
		Set default server name
		go to server_no_args
For each remaining operand
	Case mode is
	job:
		If operand is a job id Then
			Get full job id and server name
		Else
			Get queue and server name
job_no_args:
		Connect to the server
		Send the status job request
		If Unknown Job Id and not Located Then
			Locate job
			go to job_no_args
		Print the job status returned
		Disconnect from the server		
	queue:
		Get queue and server name
queue_no_args:
		Connect to the server
		Send the status queue request
		Print the queue status returned
		Disconnect from the server		
	server:
server_no_args:
		Connect to the server
		Send the status server request
		Print the server status returned
		Disconnect from the server		
.fi
.RE
.NH 4
.Fn isjobid()
.Cs
int isjobid(char *string)
.Ce
.IP Args: 4
.RS
.IP string 8
Is this string a job identifier? A job identifier begins with a number.
.RE
.IP Returns: 4
True, if the string is a job identifier, false otherwise.
.LP
Control Flow:
.RS
.nf
Is the first non-blank character a digit?
.fi
.RE
.NH 4
.Fn istrue()
.Cs
int istrue(char *string)
.Ce
.IP Args: 4
.RS
.IP string 8
Is this string some textual form of TRUE?
.RE
.IP Returns: 4
True, if the strings represents true, false otherwise.
.LP
Control Flow:
.RS
.nf
Does the string match TRUE
Does the string match True
Does the string match true
Does the string match 1
.fi
.RE
.NH 4
.Fn states()
.Cs
void states(char *string, char *q, char *r, char *h, char *w, char *t, char *e, int len)
.Ce
.IP Args: 4
.RS
.IP string 8
The string that holds the count of jobs in each state from the server.
.IP q 8
The number of queued jobs.
.IP r 8
The number of running jobs.
.IP h 8
The number of held jobs.
.IP w 8
The number of waiting jobs.
.IP t 8
The number of jobs in transit.
.IP e 8
The number of exiting jobs.
.RE
.LP
Control Flow:
.RS
.nf
While the string is not empty Do
	Scan for the next word
	If it is Queued Then set the output pointer to q
	If it is Running Then set the output pointer to r
	If it is Held Then set the output pointer to h
	If it is Waiting Then set the output pointer to w
	If it is Transit Then set the output pointer to t
	If it is Exiting Then set the output pointer to e
	Copy the next word to where the output pointer is pointing
.fi
.RE
.NH 4
.Fn display_statjob()
.Cs
void display_statjob(struct batch_status *status, int header, int full)
.Ce
.IP Args: 4
.LP
A list of information about each job returned by the server.
.IP header 8
True, if the header is to be printed, false otherwise.
.IP full 8
True, if a full display is requested, false for a normal display.
.LP
Control Flow:
.RS
.nf
If not full and header Then
	Print the header
While there is an item in the status list Do
	If full Then
		Print a full job display of all the attributes
	Else
		Print a normal display of the attributes listed in the ERS
	Get the next item in the list
.fi
.RE
.NH 4
.Fn display_statque()
.Cs
void display_statque(struct batch_status *status, int header, int full)
.Ce
.IP Args: 4
.IP status 8
A list of information about each queue returned by the server.
.IP header 8
True, if the header is to be printed, false otherwise.
.IP full 8
True, if a full display is requested, false for a normal display.
.LP
Control Flow:
.RS
.nf
If not full and header Then
	Print the header
While there is an item in the status list Do
	If full Then
		Print a full queue display of all the attributes
	Else
		Print a normal display of the attributes listed in the ERS
	Get the next item in the list
.fi
.RE
.NH 4
.Fn display_statserver()
.Cs
void display_statserver(struct batch_status *status, int header, int full)
.Ce
.IP Args: 4
.RS
.IP status 8
A list of information about the server returned by the server.
.IP header 8
True, if the header is to be printed, false otherwise.
.IP full 8
True, if a full display is requested, false for a normal display.
.RE
.LP
Control Flow:
.RS
.nf
If not full and header Then
	Print the header
While there is an item in the status list Do
	If full Then
		Print a full server display of all the attributes
	Else
		Print a normal display of the attributes listed in the ERS
	Get the next item in the list
.fi
.RE
.NH 2
.Tc \f3Program: qsub\fP
.LP
To create a job is to submit an executable script to a batch server.
Typically, the script is a shell script which will be executed
by a command shell such as sh or csh.
.NH 3
.Tc Overview
.LP
Parse the execute line and build an attribute list.  Get the script and check
for embedded operands.  Send the script to the server, and, if successful,
display the retunred job identifier.
.LP
If the job is an interactive job, qsub binds a socket to a port and passes
the port number as the interactive attribute.  After submitting the job, qsub
waits to accept a connection from MOM on that socket.  Data from standard in
is written to the socket and data from the socket is written to standard out.
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the qsub command, the exit status will be a value of zero.
.LP
If the qsub command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi qsub.c
.LP
This file contains the main routine and some other functions related to job
submission only.  All other functions are in the library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
[\-a\ date_time] [\-A\ account_string] [\-c\ interval] [\-C\ directive_prefix]
[\-e\ pathname] [\-h] [\-j\ join] [\-k\ keep] [\-l\ resource_list]
[\-m\ mail_options] [\-M\ user_list] [\-N\ name] [\-o\ pathname] 
[\-p\ priority] [\-q\ destination_id] [\-r\ c] [\-S\ pathname]
[\-u\ user_list] [\-W\ dependency_list] [\-v\ variable_list] [\-V] [\-z]
[script]
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
The variables HOME, LOGNAME, PATH, MAIL, SHELL and TZ are sent along with the
job. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
Use getopt to get each option
	Build an attribute list to go in the submit job request
Get the script and any options embedded in the script
Get the queue and server name
Connect to the server
Build the list of environment variables to send
Send the submit job request
Print the job identifier returned
If the job is an interactive job,
    Install handler for SIGTSTP so ^Z will not suspend qsub and hand up MOM.
    Call interactive to wait for a connection from the job.
Disconnect from the server
.fi
.RE
.NH 4
.Fn set_dir_prefix()
.Cs
char *set_dir_prefix(char *prefix)
.Ce
.IP Args: 4
.RS
.IP prefix 8
The directive prefix supplied by the user, if given.
.RE
.IP Returns: 4
The directive prefix.
.LP
Control Flow:
.RS
.nf
If prefix has something in it Then
	Use prefix
Else If the environment variable PBS_DPREFIX is defined Then
	Use PBS_DPREFIX
Else
	Use the default PBS_DPREFIX_DEFAULT
.fi
.RE
.NH 4
.Fn isexecutable()
.Cs
int isexecutable(char *line)
.Ce
.IP Args: 4
.RS
.IP line 8
A line of the script file.
.RE
.IP Returns: 4
True, if the line is not a comment, false otherwise.
.LP
Control Flow:
.RS
.nf
Is the first non-blank character a #?
.fi
.RE
.NH 4
.Fn ispbsdir()
.Cs
int ispbsdir(char *line)
.Ce
.IP Args: 4
.RS
.IP line 8
A line from the script file.
.RE
.IP Returns: 4
True, if the line is a PBS directive, false otherwise.
.LP
Control Flow:
.RS
.nf
Does the first part of the line match the PBS directive prefix?
.fi
.RE	
.NH 4
.Fn get_script()
.Cs
int get_script(FILE *file, char *script, char *prefix)
.Ce
.IP Args: 4
.RS
.IP file 8
The file descriptor of the script.
.IP script 8
The name of the copy that is made of the script.
.IP prefix 8
The PBS directive prefix.
.RE
.IP Returns: 4
Zero, if the script was copied okay, non-zero otherwise.
.LP
Control Flow:
.LP
.RS
.nf
Create a temporary file
While there is a line left in the script file Do
	If first line of the file Then
		Check for : or #!
	If no executable statements yet and this is a PBS directive Then
		Continuation is TRUE
		While Continuation D0
			Check if this line is continued
			Parse the PBS directives
			If the line is continued Then
				Get the next line in the script
	Else If no executable statements and this an executable statement Then
		Now there are executable statements
	Write the line to the temporary file
.RE
.NH 4
.Fn make_argv()
.Cs
void make_argv(int *argc, char *argv[], char *line)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of PBS directives found in the line.
.IP argv 8
The individual PBS directives.
.IP line 8
The PBS directives line from the script.
.RE
.LP
Control Flow:
.RS
.nf
Set argv[0] to qsub
While the line is not empty Do
	If the next character is a quote Then
		Find the matching quote
		Make it a blank
	Scan for the next blank
	Allocate memory for the word
	Copy the word
	Put the word's address into the argv array
	Increment the number of things in argv
.fi
.RE
.NH 4
.Fn do_dir
.Cs
int do_dir(char *line)
.Ce
.IP Args: 4
.RS
.IP line 8
A PBS directives line from the script.
.RE
.IP Returns: 4
The value returned from processing the directives (see process_opts).
.LP
Control Flow:
.RS
.nf
If the first time through Then
	Clear out the array that will hold the words of the line
Parse the line into words
Process the word list
.f
.RE
.NH 4
.Fn set_job_env()
.Cs
int set_job_env(char **environment)
.Ce
.IP Args: 4
.RS
.IP environment 8
The environment variables known to this process.
.RE
.IP Returns: 4
True, if the environment was made correctly, false otherwise.
.LP
Control Flow:
.RS
.nf
Calculate how big to make the environment
Allocate the memory for the environment
Put the required variables in the environment
Parse the environment variables from the command line and add them
If -V was given Then
	Add all the environment variable known to this process
Add the environment to the attribute list
.fi
.RE
.NH 4
Interactive job support routines
.LP
If interactive job support is compiled in...
.Fn interactive_port()
.Ce
.IP Returns: 4
a numeric character string representing the port number obtained.
.LP
This routine is called if the interactive attribute is specified either by
the -I option or directly via -W.
.LP
A socket is opened an bound to a port.  The port number assigned it obtained
and encoded into a numeric string which is returned.   If errors occur, the
program exits.
.Fn settermraw()
.Cs
void settermraw(struct termios *ptio)
.Ce
.IP Args: 4
.RS
.IP ptio
Pointer to the saved terminal characteristics.
.RE
.LP
The saved terminal charactersistics are duplicated and the copy is altered to
place the terminal into \*Qraw\*U mode.  
.I tcsetattr() 
is called with
.Sc TCSANOW
to set the altered characters.
.Fn stopme()
.Cs
void stopme(pid)
.Ce
.IP Args: 4
.RS
.IP pid
the pid of the process to suppend, zero (0) for all processes in the group
.RE
.LP
.I tcsetattr()
is called with
.Sc TCSANOW
and the original terminal characteristics to reset the terminal.
The SIGTSTP signal is sent to the supplied process (or group if 0).
When the process resumes, 
.I settermraw() 
is called to return the terminal to raw mode.
.Fn reader()
.Cs
int reader(int socket)
.Ce
.IP Args: 4
.RS
.IP socket
connection to the job.
.RE
.IP Returns: 4
Zero (0) on EOF, -1 on error.
.LP
This routine reads data from the job over the network and writes to the
local terminal (standard output) in raw mode.  It loops until either the
connection is closed, EOF received, or an error occurs.
See the figure 8\-1 for a picture of the communication flow between qsub,
pbs_mom's children, and the job.
.Fn writer()
.Cs
int writer(int socket)
.Ce
.IP Args: 4
.RS
.IP socket
connection to the job.
.RE
.IP Returns: 4
Zero (0) on EOF, -1 on error.
.LP
This routine reads from the local terminal (standard input) in raw mode and
writes data to the job over the network.
It loops until either the connection
is closed, EOF received, or an error occurs.
.Fn getwinsize()
.Cs
int getwinsize(struct winsize *size)
.Ce
.IP Args: 4
.RS
.IP size
pointer to the window size structure, see sys/tty.h or termios.h or some
such header.
.RE
.IP Returns: 4
zero (0) if ok, -1 on error.
.LP
Gets the current window size by calling
.I ioctl() 
.Sc TIOCGWINSZ
.Fn send_winsize()
.Cs
void send_winsize(int socket)
.Ce
.IP Args: 4
.RS
.IP socket
connection to the job.
.RE
.LP
Encodes the window size information obtained in a prior call to
.I getwinsize()
into a string and writes it to the job.
.Fn send_term()
.Cs
void send_term(int socket)
.Ce
.IP Args: 4
.RS
.IP socket
connection to the job.
.RE
.LP
Gets the TERM environment variable and writes it as a string
.Ty TERM= type
to the job.  Also writes the
.Sc PBS_TERM_CCA
(number of) terminal control characters obtained earlier to the job.
.Fn catchchild()
.Cs
void catchchild()
.Ce
.LP
Signal handler for SIGCHLD.  Invoked by death of the reader process.
Resets the terminal to normal (cooked) mode.
.Fn catchint()
.Cs
void catchint()
.Ce
.LP
Signal handler for SIGINT and SIGTERM while qsub is waiting for the job to
start.  The function asked the user if it should terminate or not.  If 
any string starting with 'y' is received, 
.I pbs_deljob()
is called to delete the job and qsub exits.
.Fn interactive()
.Cs
void interactive()
.Ce
.LP
This routine waits for the job to connect with it over the socket set up
earlier, see
.I interactive_port() .
The routine
.I catchint() 
is installed as the signal handler for SIGINT and SIGTERM.
The current terminal settings are saved by calling 
.I tcgetattr() .
The window size is obtained by calling 
.I getwinsize() .
.I select() 
is called in a loop with a 30 second time out.  After each time out,
.I locate_job()
is called to see if the job still exists.  If the job is gone, qsub exits.
.LP
When a connection request is received, the function reads in what should be
the job id from MOM.   If the string does not match the job id as submitted,
qsub aborts.
If the job id is correct, we send the termal type,
.I send_term() 
and window size
.I send_winsize() .
We print that the job is ready and set SIGINT and SIGTERM handler to the
default.  A child process is forked to become the
.I reader()
process.  The parent (qsub) becomes the 
.I writer()
process.  Both processes exit when EOF or an error is received.
The writer process will make sure the reader child is killed and resets the
terminal.

.NH 4
.Fn process_opts()
.Cs
int process_opts(int argc, char **argv, int pass)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments in argv.
.IP argv 8
The command line or PBS directives line arguments.
.IP pass 8
Zero, if a command line argument list, positive if a PBS directive argument list.
.RE
.LP
.nf
Control Flow:
If pass is greater than zero Then
	Start at the beginning of the argument list
While getopt Do
	The appropriate thing for each option
.fi
.LP
Note that the following rules are enforced:
.IP 1.
Option argument values supplied on the command line take precedence over values
for the same option supplied in script directivies.
.IP 2.
If an option  is repeated on the command line (or in the script, subject to
rules 1), the argument value for the last occurrence:
.RS
.IP -
replaces the prior value if the option is singled valued (integer or string).
.IP -
is appended to the prior value(s) if the option is list valued (comma
separated elements).
.RE
.LP
.Fn set_opt_defaults()
.Cs
void set_opt_defaults()
.Ce
.LP
This function is called after all command line options and script 
directives have been parsed.   According to POSIX, certain job attributes
must be set to default values if not set by the user.  This is where
that happens for: checkpoint, hold, join, keep, mail-points, priority,
and rerunable.
.NH 2
.Tc \f3Libcmds\fP
.LP
The Libcmds library has supporting routines for the PBS utilities.
These mostly consist of parsing job identifiers and destinations, building
attribute lists, and some miscellaneous routines.
.NH 3
.Fi ck_job_name.c
.LP
This file has one routine to validate the job name specified vi the -N option.
.NH 4
.Fn ck_job_name()
.Cs
int ck_job_name.c(char *name, int alpha)
.Ce
.IP Args: 4
.RS
.IP name
of job specified on -N option.
.IP alpha
If set to one (1), the first character of the name must start with a alphabetic
character.  Set to zero (0), this check is not made.
.RE
.IP Returns: 4
Zero (0) if name is valid, -1 if invalid.
.LP
The name must be less than or equal to 15 characters in length.  The first
character must be alphabetic if 
.Ar alpha
is set to 1.  PBS allows the remaining characters to be
any printable character.  The POSIX Batch standard calls for only 
alphanumeric, but then conflicts with itself to default to the
script base-name which may have non-alphanumeric characters.
Since the users like to use under_score and dot, we allow it.
.NH 3
.Fi cvtdate.c
.LP
This file has one routine to convert POSIX touch date/time to seconds since
epoch time.
.NH 4
.Fn cvtdate()
.Cs
time_t cvtdate(char *datestr)
.Ce
.IP Args: 4
.RS
.IP datestr 8
The string 
.B datestr
is a date/time string in the form [[CC]YY]MMDDhhmm[.SS] as defined by POSIX,
where
.nf
	CC = century, ie 19 or 20
	YY = year, if CC is not provided and YY is < 69, 
	     then CC is assumed to be 20, else CC is 19.
	MM = Month, [1,12]
	DD = Day of month, [1,31];
	hh = hour, [00, 23]
	mm = minute, [00, 59]
	SS = seconds, [00, 59]
.fi
.RE
.IP Returns: 4
Seconds since epoch, or -1 if an error occurred (see man mktime).
.LP
Control Flow:
.RS
.nf
If datestr contains a '.' Then
	Set the seconds from SS
	Take the .SS off datestr
else
	Set seconds to zero
Make sure the rest of the datestr contains all digits
Get the current year
Case length of datestr is
12:	/* CCYYMMDDhhmm */
	Get the century
	Fall through
10:	/* YYMMDDhhmm */
	Get the year
	If century is not set Then
		Set century according to the year
	Combine the century and year together
	Set the year
	Fall Through
8:	/* MMDDhhmm */
	Set the month from the next two digits
	Set the day from the next two digits
	Set the hour from the next two digits
	Set the minutes from the next two digits
default:
	Return -1
Return the result of mktime using the above data
.fi
.RE
.NH 3
.Fi get_server.c
.LP
This file has one routine to parse the job identifier from the command line
into a full job identifier and a server name. The complete syntax for a
command line job identifier is defined in parse_jobid.c. The routine implements
the procedure outlined in Section 5.1.2 of the ERS for setting the name
of the server.
.NH 4
.Fn get_server()
.Cs
int get_server(char *job_id_in, char *job_id_out, char *server_out)
.Ce
.IP Args: 4
.RS
.IP job_id_in 8
The job identifier from the command line.
.IP job_id_out 8
The sequence number and an appropriate server name.
.IP server_out 8
The name of the server to send the request to.
.RE
.IP Returns: 4
Zero, if the job identifier parse correctly, one otherwise.
.LP
Control Flow:
.RS
.nf
Parse the job_id_in into sequence number, parent server, and current server
If current server is defined Then
	Set server_out to the current server (5.1.2 Step 1)
Elseif parent server is defined Then
	Set the server_out to the parent server (5.1.2 Step 2)
Else
	Set the server_out to NULL (5.1.2 Step 4)
If parent server is defined Then
	Set the job_id_out to the sequence number and the fully qualified
	parent server
Else
	Set the parent server to the environment variable PBS_DEFAULT value
	If no value exist Then
		Set the parent server to the name in the PBS DEFAULT FILE
	Set the job_id_out to the sequence number and the fully qualified
	parent server	
.fi
Note that the routine
.I get_fullhostname()
in libnet.a is used to obtain the fully qualified hostname.
.RE
.NH 3
.Fi locate_job.c
.LP
This file has one routine that connects to the server the job was submitted
to and sends a Locate Job request. The result should be the server the job
is at.
.NH 4
.Fn locate_job()
.Cs
int locate_job(char *job_id, char *parent_server, char *located_server)
.Ce
.IP Args: 4
.RS
.IP job_id 8
The full job identifier.
.IP parent_server 8
The name of the server to send the request to.
.IP located_server 8
The name of the server the job is current at.
.RE
.IP Returns: 4
True, if the job is located, false otherwise.
.LP
Control Flow:
.RS
.nf
Connect to the parent server
Send the Locate Job request
Disconnect from the server
.fi
.RE
.NH 3
.Fi parse_destid.c
.LP
This file has one routine that parses the destination from the command line.
The destination can have the following forms:
.nf

queue_name[@server_name[:port_number]]
@server_name[:port_number]

.fi
.NH 4
.Fn parse_destination_id()
.Cs
int parse_destination_id(char *destination, char **queue, char **server)
.Ce
.IP Args: 4
.RS
.IP destination 8
The destination to be parsed.
.IP queue 8
The queue part of the destination.
.IP located_server 8
The server part of the destination.
.RE
.IP Returns: 4
Zero, if the destination was parsed correctly, one otherwise.
.LP
Control Flow:
.RS
.nf
Initialize the queue and server names to NULL
Get the queue name if it is given
Get the server name if it is given
.fi
.RE
.NH 3
.Fi parse_equal.c
.LP
This file has one routine that parses set of comma delimited name = value_list
into separate name = value_list. On the first call, the first name = value_list
is returned. On subsequent calls, the next name = value_list is returned until
there are no more.
.NH 4
.Fn parse_equal_string()
.Cs
int parse_equal_string(char *start, char **name, char **value)
.Ce
.IP Args: 4
.RS
.IP start 8
Where to start parsing.
.IP queue 8
The name part.
.IP value 8
The value_list part.
.RE
.IP Returns: 4
One, if a name = value_list is found, zero if nothing is left, and minus one
if there is a parsing error.
.LP
Control Flow:
.RS
.nf
If there is nothing left to parse Then
	return 0
Find the beginning of the name
Find the end of the name
Make sure it is followed by an '='
If value starts with a quote Then
	Find the matching quote
Scan for the next equal sign
If at end of input string Then
	return 1
Back up to the first comma
If the comma is after the start of the value string Then
	Strip off trailing blanks
.fi
.RE
.NH 3
.Fi parse_jobid.c
.LP
This file has one routine that parses the complete job identification from the
command line into it's various parts. The complete syntax is
.nf

seq_number[.parent_server[:port]][@current_server[:port]]

.fi
.LP
The routine returns the sequence number, parent server and current server as
separate values.
The port is returned as part of the server name.
.NH 4
.Fn parse_jobid()
.Cs
int parse_jobid(char *jobid, char **s_number, char **p_server, char **c_server)
.Ce
.IP Args: 4
.RS
.IP jobid 8
The job identification from the command line.
.IP s_number 8
The sequence number part.
.IP p_server 8
The parent server part.
.IP c_server 8
The current server part.
.RE
.IP Returns: 4
Zero, if parse was okay, non-zero on a parsing error.
.LP
Control Flow:
.RS
.nf
Initialize the sequence number, parent server and current server names to NULL
Scan for the sequence number
If the next character is '.' Then
	Scan for the parent server
If the next character is '@' Then
	Scan for the current server
If we are at the end of the jobid Then
	Return the separate values
.fi
.RE
.NH 3
.Fi prepare_path.c
.LP
This file has one routine that path given on the command line and turns it into
a full path name if needed. The syntax of the path name is
.nf

host:path

.fi
.NH 4
.Fn prepare_path()
.Cs
int prepare_path(char *path_in, char *path_out)
.Ce
.IP Args: 4
.RS
.IP path_in 8
The path to turn into an absolute path name.
.IP path_out 8
The absolute path name.
.RE
.IP Returns: 4
Zero, if path was converted okay, non-zero not.
.LP
Control Flow:
.RS
.nf
Initialize the host and path to NULL
Scan for the host name
Scan for the path
Get fully qualified host name
Put the fully qualified host name in path_out
Append a ':'
If the path name is relative Then
	Get the current working directory
	Append it to path_out
Append the path to path_out
.fi
.LP
Note, if the the path is relative and the current directory is in an NFS
Automounted path, the currently location may not be mounted when the output
is returned.  Hence it is neccessary to make the path NFS Automounter
"friendly".   This entails finding the path name used to cause the automounter
to mount.   This might be obtained from the shell environment variable PWD
if it exists.   Otherwise we fall back to using getcwd() to expand the relative
path name.
.RE
.NH 3
.Fi prt_job_err.c
.LP
This file has one routine that prints a standard error message if a request
that involves a job identification fails.
.NH 4
.Fn prt_job_err()
.Cs
void prt_job_err(char *cmd, int connection, char *jobid)
.Ce
.IP Args: 4
.RS
.IP cmd 8
The PBS utility that is calling this routine.
.IP connection 8
The connection identifier to the server.
.IP jobid 8
The job identifier of the failed request.
.RE
.LP
Control Flow:
.RS
.nf
If error message returned by server Then
	Print server error message
Else
	Print generic error message
.fi
.RE
.NH 3
.Fi set_attr.c
.LP
This file has one routine that builds an attribute list.
.NH 4
.Fn set_attr()
.Cs
void set_attr(struct attrl **attrib, char *name, char *value)
.Ce
.IP Args: 4
.RS
.IP attrib 8
The attribute list.
.IP connection 8
The name part.
.IP jobid 8
The value part.
.RE
.LP
Control Flow:
.RS
.nf
Allocate the space needed for an attribute structure
Allocate the space needed for the name field and copy the name into it
Set the resource field to NULL
Allocate the space needed for the value field and copy the value into it
Append the attribute structure to the end of the attribute list
.fi
.RE
.NH 3
.Fi set_resources.c
.LP
This file has one routine that parses the resource list and makes an attribute
structure from this that it appends to the attribute list. The syntax of a
resource list is
.nf

resource = value, ...

.fi
.NH 4
.Fn set_resources()
.Cs
void set_resources(struct attrl **attrib, char *resources, int add)
.Ce
.IP Args: 4
.RS
.IP attrib 8
The attribute list.
.IP resources 8
The resource list.
.IP add 8
Force the append or only add if the resource is not already on the attribute list.
.RE
.LP
Control Flow:
.RS
.nf
While the resource list is not empty Do
	Get the resource
	If followed by an '=' Then
		Get the value
	Allocate memory for the attribute structure
	Allocate memory for the name ATTR_l and copy it to the name
	Allocate memory for the resource name and copy the resource to it
	If value is defined Then
		Allocate memory for the value name and copy the value to it
	Else
		Set the value name to NULL
	If the attribute list is empty Then
		Put the attribute structe on it
	Else
		Search the attribute list to see if the resource is there
		If add is true or not found Then
			Append the attribute structure to the list
.fi
.RE
.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[This page is blank.]
.DE
.bp
\}
