.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.SH
Appendix A - Job Selection for Initiation
.LP
As stated in the section on job initiation, different sites have greatly
differing views as to how jobs should be selected for initiation into
execution.
A far from exhaustive list of possible policies would include:
.IP \(em
First in, first out.
.IP \(em
Maximize usage of one or more resources.
.IP \(em
Minimize turn around time.
.IP \(em
Schedule based on CPU Time times Memory usage.
.IP \(em
Favor large memory job, or small memory jobs.
.IP \(em
Favor short jobs, or long jobs.
.IP \(em
Favor the jobs submitted by a certain user or group.
.IP \(em
Minimize the impact of batch jobs upon the interactive users.
.LP
To make matters even more challenging, a site's policy often changes
depending on time of day, day of the week, part of the month, work load,
finances, and politics.
In the following sections, two approaches to solving the question of
how to best select jobs are examined.
.SH
A.1 - Multiple Queue Approach
.LP
The multiple queue approach was the basis for Cosmic NQS and the Cray
variant of NQS.  Jobs are routed (or \*Qpiped\*U) into one of several
queues based upon the resource requirements of the job.  When a job was
to be placed into execution, the queues were examined in priority order.
If a job was in the queue be examined, and the various limits on the 
queue and complex had not been exceeded, the first job in that queue
would be selected for execution.
By varying the priorities and run limits of the various queues and by
starting and stopping queues, the operator or batch administrator
could exercise a great deal of control over what type of jobs were
run and when.
.LP
A problem with this approach was that users could, knowing when certain
queues had priority, misrepresent their job's resource requirements to
force the job to fit into a queue where it might run sooner.
Another problem was that the system offered no provision for doing any
type of best fit or maximizing resource usage.  This has lead several
sites to consider a different approach to job selection.
.SH
A.2 - A Single Job Pool
.LP
The alternative most often considered is the single job pool.
All jobs are placed in a single pool or queue.
The job selection algorithm can then pick from all jobs without queue bias.
However, this approach places a new set of issues on how to control job
selection.
.LP
The single pool is often used when a site wishes to implement a policy
of maximizing the usage of one or more resources.
It is also used as the basis for implementing a pure job priority driven
selection.
The user can specify any priority, a higher priority ensures faster
selection of the job.  However, the user is charged at a premium rate;
the higher the priority, the higher the rate.
.SH
A.3 - The PBS Solution
.LP
The requirements as specified in this document can be met by either of
the above approaches, or others as well.  It is the intent of this
document to ensure that the implementation is easily modifiable,
and can be adjusted or replaced to satisfy most sites.
.LP
The most flexible approach appears to be to support multiple queues
.sm
[A single pool is a subset of multiple queues, where only one queue
is defined.]
.nr
with modifiable controlling attributes, such as run limit, priority,
etc; and a table driven selection algorithm.
By modifying queue priority and changing values in the selection function,
job selection can be biased in favor of long jobs, short jobs, big jobs,
little jobs, or any combination of those and other characteristics.
.bp
.SH
Appendix B - A Pull Model of Job Distribution
.LP
There has been much interest within the batch community in the concept
of the pull model of job distribution.
In this model, jobs available for execution are collected in a central
queue or pool.  When a execution server determines that it can initiate
a new job, it sends a request for the job to the pool.  A job is selected
and dispatched to the execution server.
.LP
This model is not ideal for NAS because of the divergent architecture of the
computational resources.  However, provisions to support a pull model
must be included in PBS as it is to be the foundation for other
user sites' and vendors' batch systems.
.SH
B.1 - Job Collection Pool
.LP
With minor modifications, a routing queue can be used as the collection
pool for jobs waiting for distribution to execution servers.
Jobs are not routed until a request arrives from an execution server.
The request must contain the requirements which a selected job must
meet.  The requirements may include limits, upper and lower, on required
resources, priorities, user name, or any other job attribute.
.LP
A routing queue will act in a push manner or a pull manner based upon
an attribute of the queue.
.SH
B.2 - Execution Server
.LP
In the pull model, an execution server must ask for a job when resources
are available.  In the framework of PBS, an execution queue can act
as the execution server.
Attributes of the execution queue will direct the job selection function
to make the request of a routing queue and specify to which batch server -
routing queue pair the request is made.
