.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.IP Account 15
is an arbitrary character string which may have meaning to
one or more of the hosts in the batch system.  Frequently, account
is used as a grouping for charging for the use of resources.
.IP Administrator 15
or Batch System Administrator is a person authorized to use all restricted
capabilities of the batch system.  The administrator may act upon the
the batch system, queues, or jobs.
.IP Batch 15
or batch processing, is the capability of running
.I jobs
outside of the interactive login session.  Placing a process in the
background, by appending an `&' to the command, is like running
a batch job.  In this document however, batch implies a more complex
subsystem which provides for additional control over job scheduling
and resource contention.
.IP "Batch Server" 15
is a subsystem upon a single host which provides batch
processing capability.
.IP "Batch System" 15
is a set of batch servers that are configured
for processing.  The system may consist of multiple hosts, each with
multiple servers.
.IP Complex 15
or queue complex is a set of queues within a batch server.
The purpose of a complex is to provide additional control over resource usage.
Limits on types of resources may be defined for the complex which limit
the sum of the resources used by jobs from all queues which are
members of that complex.
.IP "Cosmic NQS" 15
stands for the prior version of the Network Queuing System developed at
NAS and released for distribution to NASA's COSMIC software center.
.IP Destination 15
is the location within the batch system where the job is
sent for processing or executing.  In Cosmic NQS terms, destination is
a queue at a host.  In PBS, a destination may uniquely define a single
queue at a single batch server or it may map into many locations.
.IP "Destination Identifier " 15
is a string which names the destination.  It is in two parts and has the
format
.DS C
queue@server
.DE
where server is the name of a batch server and queue is the string identifying
a queue on that server.
.IP "File Staging" 15
is the movement of files between a specified location and the execution
host.
See 
.B "Stage In"
and
.B "Stage Out" .
.IP Group 15
is a collection of system users (see Users).
A user must be a member of a group and may be a member of more than one.
Within Unix and POSIX systems, membership in a group establishes one
level of privilege.  Group membership is also often used to control or
limit access to system resources.
.IP Hold 15
is an artificial restriction which prevents a job from being selected for
processing.  There are three types of holds,
.B User
which is applied by the job owner,
.B System
which is applied by the batch system administrator or operator, and
.B Other
which is applied by the batch system itself.
.IP Job 15
or 
.I "batch job"
is the basic execution object managed by the batch subsystem.  A job is a
collection of related processes which is managed as a whole.  A job can
often be thought of as a shell script.
In POSIX terms, a job is a processes group from which the member processes
cannot leave.
.IP NAS 15
is short for
.I "Numerical Aerodynamic Simulation"
Program.   A supercomputer center at NASA Ames Research Center for the
study of computational physics.
.IP Operator 15
or Batch Operator is a person authorized to use some but not all of the
restricted capabilities of the batch system.
.IP Owner 15
of a job is the user who submitted the job to the batch system.
.IP Packet 15
is a block of data sent over a network connecting two batch systems.
A packet is placed on the network by the application with a single call
to the basic I/O call, write(2).
Typically, one or more packets make up a request for service between batch
systems, and one packet (but not limited to one) contains the reply.
.IP PBS 15
is short for
.I "Portable Batch System" .
.IP POSIX 15
refers to the various standards being developed by the "Technical
Committee on Operating Systems and Application Environments of the IEEE
Computer Society" under standard  P1003.  There are a number of
subcommittees under POSIX, those of interest to this project are:
.RS 15
.IP POSIX.1 10
System Application Program Interface (the system calls).
.IP POSIX.2 10
The command shell language.
.IP POSIX.3 10
Test Methods
.IP POSIX.10 10
Supercomputing Profile
.IP POSIX.12 10
Protocol Independent Interfaces (one of the many network working groups)
.IP POSIX.14 10
Multiprocessor Working Group
.IP POSIX.15 10
Batch Queuing Extensions, this starndard has been approved as 1003.2d.
.RE
.IP Queue 15
is a collection of jobs (or job related tasks) within the
batch queuing system.
Each queue has a set of associated attributes which
determine what actions are performed upon each job  within the queue. 
Typical attributes include queue name, queue priority, resource limits,
destination(s) and job count limits.
Selection/scheduling of jobs is implementation defined.  The use of the
term "queue" does not imply the ordering is "first in, first out."
.IP "Stage In" 15
is to move a file or files to the host prior to the batch job beginning
execution.
.IP "Stage Out" 15
is to move a file or files off of the host after the batch job completes
execution.
.IP User 15
is a user of the computer system.  Each user is identified by a unique
character string, the user name; and by a unique number, the user id.
.IP "User ID" 15
is a numeric identifier uniquely assigned to each user.
Privilege to access system resources and services is typically established
by the user id.
