.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.LP
The following list of requirements specifies features of user
commands which must be provided by PBS.  Where these requirements
match those specified in POSIX 1003.2d, the syntax of the
command must be that of POSIX 1003.2d.
Where possible any additional required features must be implemented
in such manner that PBS is a extension to POSIX 1003.2d and is not
in conflict with the base features.
.NH 4
Qsub
.LP
A user command must be provided to 
.B submit
a job to the batch system.
Resources and execution attributes
may be specified as well as the destination for the job.
There must be a capability to specify parameters which will be passed as
arguments to the job command or script.
.NH 4
Qalter
.LP
A command must be provided to
.B alter
the resources and execution 
attributes of batch jobs which have been previously submitted. 
The job script and its arguments must be unalterable.
.NH 4
Qdel
.LP
A command must be provided to 
.B delete
a batch job from the batch system.
If the job is executing, it must be sent the signal
.B SIGTERM ,
followed by the signal
.B SIGKILL .
The amount of time, in seconds, between the two signals must be definable by
the site and the site must be able to specify that the time is in wall
clock or cpu seconds.  The user must be able to specify via options on the
command a different value for the delay between the two signals.
.NH 4
Qhold
.LP
A command must be provided to place an indefinite 
.B hold
on the specified
batch job.  If the job is queued (not executing), the hold  makes it
ineligible for execution (prevents it from be scheduled) until the hold is
released.
.LP
If the job is executing when the qhold command is issued, then the 
hold is applied to the job and the job must cease executing.
At a minimum, a
.B SIGSTOP
must be sent to the job.  If the underlaying kernel supports 
.I "checkpoint / restart" 
(see checkpoint discussion in the section on Kernel Support),
then options must exist on the qhold command to allow the user to
specify which of the following actions should be taken regarding the
running job:
.IP Stopped 12
Just send a 
.B SIGSTOP
signal.
.IP Suspended 12
Checkpoint the job, but retain its resources.  The job is placed in
a held state in the execution queue from which its execution  was initiated.
.IP Requeued 12
Checkpoint the job, release the resources, and return the job to a
held state in the execution queue.  Certain resources, such as tapes which
cannot be easily repositioned, may be treated as not releasable and therefore
be retained.
.LP
A batch system attribute, settable by the batch system administrator,
must exist which specifies if PBS will be allowed to schedule another
job when a executing job is 
.I requeued
with the qhold command.
.LP
If a job is not checkpointable (actually restartable), then an attempt to
apply a qhold with the suspend or requeue option must be rejected.
.NH 4
Qmove
.LP
A command must be provided to 
.B move
the specified batch jobs from their present
destination into the named destination.
.NH 4
Qmsg
.LP
A command must be provided to write a text string into the output of
a batch job.
.NH 4
Qrerun
.LP
A command must be provided which causes the specified batch job to be
killed and 
.B rerun .
If the job is marked as one which cannot be rerun, this command must not
have any effect.
.NH 4
Qrls
.LP
A command must be provided to 
.B release
a user applied hold if one is applied to the job.  If the hold is the only
one on the job, the job is then eligible for execution.
.NH 4
Qselect
.LP
A command must be provided which 
.B selects
or lists the identifiers of all batch jobs
which meet the specified selection criteria.
This list can be passed to another command to specify the targets of the
action of that command.
.NH 4
Qsig
.LP
A command must be provided to send a 
.B signal
to a running batch job.  The default signal sent is
.B SIGTERM .
.NH 4
Qstat
.LP
A command must be provided to collect and display current 
.B status
of a batch job or set of batch jobs, a batch queue or the batch system.
The status of jobs may be requested for a selected list of jobs or for
all the user's jobs.
The status of a job or jobs must include at least the following items:
.IP \(em 4
The current location of the job.
.IP \(em 4
The current state of the job.
.IP \(em 4
Amount of cpu time used.
.IP \(em 4
Current amount of memory used.
.IP \(em 4
Maximum amount of memory used.
