/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/* 
 *
 * qhold - (PBS) hold batch job
 *
 * Authors:
 *      Terry Heidelberg
 *      Livermore Computing
 *
 *      Bruce Kelly
 *      National Energy Research Supercomputer Center
 *
 *      Lawrence Livermore National Laboratory
 *      University of California
 */

#include "cmds.h"
#include <pbs_config.h>   /* the master config generated by configure */

static char ident[] = "@(#) $RCSfile: qhold.c,v $ $Revision: 2.1 $";

main(argc, argv, envp) /* qhold */
int argc;
char **argv;
char **envp;
{
    int c;
    int errflg=0;
    int any_failed=0;
    int u_cnt, o_cnt, s_cnt, n_cnt;
    char *pc;
    struct attrl *attrib = NULL;

    char job_id[PBS_MAXCLTJOBID];       /* from the command line */

    char job_id_out[PBS_MAXCLTJOBID];
    char server_out[MAXSERVERNAME];
    char rmt_server[MAXSERVERNAME];

#define MAX_HOLD_TYPE_LEN 32
    char hold_type[MAX_HOLD_TYPE_LEN+1];

#define GETOPT_ARGS "h:"
                 
    hold_type[0]='\0';

    while ((c = getopt (argc, argv, GETOPT_ARGS )) != EOF)
        switch (c) {
        case 'h':
            while ( isspace((int)*optarg) ) optarg++;
            if ( strlen(optarg) == 0 ) {
                fprintf(stderr, "qhold: illegal -h value\n");
                errflg++;
		break;
            }
            pc = optarg;
            u_cnt = o_cnt = s_cnt = n_cnt = 0;
            while ( *pc) {
                if ( *pc == 'u' )
                    u_cnt++;
                else if ( *pc == 'o' )
                    o_cnt++;
                else if ( *pc == 's' )
                    s_cnt++;
                else if ( *pc == 'n' )
                    n_cnt++;
                else {
                    fprintf(stderr, "qhold: illegal -h value\n");
                    errflg++;
		    break;
                }
                pc++;
            }
            if ( n_cnt && (u_cnt + o_cnt + s_cnt) ) {
                fprintf(stderr, "qhold: illegal -h value\n");
                errflg++;
		break;
            }
            strcpy(hold_type, optarg);
            break;
        default :
            errflg++;
        }

    if (errflg || optind >= argc) {
        static char usage[]="usage: qhold [-h hold_list] job_identifier...\n";
        fprintf(stderr, usage);
        exit (2);
    }

    for ( ; optind < argc; optind++) {
        int connect;
        int stat=0;
        char *errmsg;
	int located = FALSE;

        strcpy(job_id, argv[optind]);
        if ( get_server(job_id, job_id_out, server_out) ) {
            fprintf(stderr, "qhold: illegally formed job identifier: %s\n", job_id);
            any_failed = 1;
            continue;
        }
cnt:
        connect = cnt2server(server_out);
        if ( connect <= 0 ) {
            fprintf(stderr, "qhold: cannot connect to server %s (errno=%d)\n", 
                    pbs_server, pbs_errno);
            any_failed = pbs_errno;
            continue;
        }

        stat = pbs_holdjob(connect, job_id_out, hold_type, NULL);
        if ( stat && (pbs_errno != PBSE_UNKJOBID) ) {
	    prt_job_err("qhold", connect, job_id_out);
            any_failed = pbs_errno;
        } else if ( stat && (pbs_errno == PBSE_UNKJOBID) && !located ) {
	    located = TRUE;
	    if ( locate_job(job_id_out, server_out, rmt_server) ) {
	        pbs_disconnect(connect);
		strcpy(server_out, rmt_server);
		goto cnt;
	    }
	    prt_job_err("qhold", connect, job_id_out);
	    any_failed = pbs_errno;
	}

        pbs_disconnect(connect);
    }
    exit(any_failed);
}
