/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/* 
 * qorder - change the order of two batch jobs in a queue
 */

#include <string.h>
#include "cmds.h"
#include <pbs_config.h>   /* the master config generated by configure */

static char ident[] = "@(#) $RCSfile: qorder.c,v $ $Revision: 2.1 $";

main(argc, argv, envp)
int argc;
char **argv;
char **envp;
{
    char job_id1[PBS_MAXCLTJOBID+1];		/* from the command line */
    char job_id2[PBS_MAXCLTJOBID+1];		/* from the command line */
    char job_id1_out[PBS_MAXCLTJOBID+1];
    char job_id2_out[PBS_MAXCLTJOBID+1];
    char *pn;
    int  port1 = 0;
    int  port2 = 0;
    char server_out1[MAXSERVERNAME+1];
    char server_out2[MAXSERVERNAME+1];
    char svrtmp[MAXSERVERNAME+1];
    int connect;
    int stat=0;
    int rc = 0;
    extern char *PBS_get_server();


    if (argc != 3) {
        static char usage[]="usage: qorder job_identifier job_identifier\n";
        fprintf(stderr, usage);
        exit (2);
    }

        strcpy(job_id1, argv[1]);
        strcpy(job_id2, argv[2]);
	svrtmp[0] = '\0';
        if ( get_server(job_id1, job_id1_out, svrtmp) ) {
            fprintf(stderr, "qorder: illegally formed job identifier: %s\n", job_id1);
            exit(1);
        }
	if (*svrtmp == '\0') {
	    if (pn = pbs_default()) {
		(void)strcpy(svrtmp, pn);
	    } else {
		fprintf(stderr, "qorder: could not get default server: %s\n", job_id1);
		exit(1);
	    }
	}
		
	if ((pn = strchr(svrtmp, (int)':')) != 0) {
	    *pn = '\0';
	    port1 = atoi(pn+1);
	}
	if (get_fullhostname(svrtmp, server_out1, MAXSERVERNAME) != 0) {
	    fprintf(stderr, "qorder: invalid server name: %s\n", job_id1);
	    exit(1);
	}
	
	svrtmp[0] = '\0';
        if ( get_server(job_id2, job_id2_out, svrtmp) ) {
            fprintf(stderr, "qorder: illegally formed job identifier: %s\n", job_id2);
            exit(1);
        }
	if (*svrtmp == '\0') {
	    if (pn = pbs_default()) {
		(void)strcpy(svrtmp, pn);
	    } else {
		fprintf(stderr, "qorder: could not get default server: %s\n", job_id1);
		exit(1);
	    }
	}
	if ((pn = strchr(svrtmp, (int)':')) != 0) {
	    *pn = '\0';
	    port2 = atoi(pn+1);
	}
	if (get_fullhostname(svrtmp, server_out2, MAXSERVERNAME) != 0) {
	    fprintf(stderr, "qorder: invalid server name: %s\n", job_id2);
	    exit(1);
	}
	if ( (strcmp(server_out1, server_out2) != 0) || (port1 != port2) ) {
	    fprintf(stderr, "qorder: both jobs ids must specify the same server\n");
	    exit(1);
	}
	if (pn)
		*pn = ':';	/* restore : if it was present */


        connect = cnt2server(svrtmp);
        if ( connect <= 0 ) {
            fprintf(stderr, "qorder: cannot connect to server %s (errno=%d)\n",
                    pbs_server, pbs_errno);
            exit(1);;
        }

        stat = pbs_orderjob(connect, job_id1_out, job_id2_out, NULL);
        if ( stat ) {
	    prt_job_err("qorder", connect, "");
            rc = pbs_errno;
	}

        pbs_disconnect(connect);
        exit(rc);
}
