/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: Long.h,v 2.2 1999/07/21 22:34:42 lonhyn Exp $
 */

#ifndef lONG_H
#define lONG_H

#include <limits.h>

#ifndef A_
#if __STDC__ == 1
#define A_(x) x
#else	/* STDC */
#define const
#define volatile
#define A_(x) ()
#endif	/* STDC */
#endif	/* A_   */

/*
 * Define Long and u_Long to be the largest integer types supported by the
 * native compiler.  They need not be supported by printf or scanf or their
 * ilk.  Ltostr, uLtostr, strtoL, strtouL, and atoL provide conversion to and
 * from character string form.
 *
 * The following sections are listed in decreasing order of brain damage.
 */ 

/****************************************************************************/
#if defined(__hpux)						   /* HP-UX */

/* Under HP-UX, the compiler supports 64-bit signed integers as long longs */
/* but it is only capable of supporting 63-bit unsigned integers as */
/* unsigned long longs.  As a consequence, the most negative Long is one */
/* closer to zero than it would otherwise be.  HP-UX also seems to provide */
/* neither defined constant support nor library support. */

typedef long long		Long;
typedef unsigned long long	u_Long;

#define lONG_MIN		-0x7FFFFFFFFFFFFFFFLL
#define lONG_MAX		 0x7FFFFFFFFFFFFFFFLL
#define UlONG_MAX		 0x7FFFFFFFFFFFFFFFULL

Long strToL A_((const char *nptr, char **endptr, int base));
u_Long strTouL A_((const char *nptr, char **endptr, int base));
#define atoL(nptr)		strToL((nptr), (char **)NULL, 10)

/****************************************************************************/
#elif defined(__GNUC__) ||		    /* SunOS, FreeBSD, NetBSD, BSDI */\
      defined(_AIX) && defined(__EXTENDED__)			     /* AIX */

/* On these systems, the compiler supports 64-bit integers as long longs but */
/* there seems to be neither defined constant support nor library support. */

typedef long long		Long;
typedef unsigned long long	u_Long;

#define lONG_MIN		(-0x7FFFFFFFFFFFFFFFLL-1)
#define lONG_MAX		  0x7FFFFFFFFFFFFFFFLL
#define UlONG_MAX		  0xFFFFFFFFFFFFFFFFULL

Long strToL A_((const char *nptr, char **endptr, int base));
u_Long strTouL A_((const char *nptr, char **endptr, int base));
#define atoL(nptr)		strToL((nptr), (char **)NULL, 10)

/****************************************************************************/
#elif defined(__sgi) && defined(_LONGLONG) && _MIPS_SZLONG == 32    /* Irix */\

/* On Irix, the compiler supports 64-bit integers as long longs with defined */
/* constant support and with some library support.  The library has nothing */
/* like LTostr or uLTostr. */

typedef long long		Long;
typedef unsigned long long	u_Long;

#define lONG_MIN		LONGLONG_MIN
#define lONG_MAX		LONGLONG_MAX
#define UlONG_MAX		ULONGLONG_MAX

#define strToL(n, e, b)		strtoll(n, e, (b))
#define strTouL(n, e, b)	strtoull(n, e, (b))
#define atoL(nptr)		atoll((nptr))

/****************************************************************************/
#elif defined(sun) && defined(sparc) && defined(LLONG_MAX)	 /* Solaris */

/* Under Solaris, the compiler supports 64-bit integers as long longs with */
/* defined constant support and library support, but with some strange */
/* aspects to its library support.  This package ignores the Solaris */
/* definitions of lltostr and ulltostr.  They aren't anything close to being */
/* the functionally symetric equivalents of strtoll and strtoull.  The */
/* LTostr and uLTostr functions in this package are much closer. */

typedef long long		Long;
typedef unsigned long long	u_Long;

#define lONG_MIN		LLONG_MIN
#define lONG_MAX		LLONG_MAX
#define UlONG_MAX		ULLONG_MAX

#define strToL(n, e, b)		strtoll(n, e, (b))
#define strTouL(n, e, b)	strtoull(n, e, (b))
#define atoL(nptr)		atoll((nptr))

/****************************************************************************/
#else							/* Unicos, SunOS cc */

/* On this machine, longs are as long as it gets.  With luck, at least 64 */
/* bits (SunOS cc users have no luck).  Naturally, defined constant support */
/* and some library support are both present.  The library has nothing like */
/* LTostr or uLTostr. */

/* What an amazing concept, long as the longest supported integer data type! */
/* Congratulations Cray, for being the only ones so far to get it right! */

typedef long			Long;
typedef unsigned long		u_Long;

#define lONG_MIN		LONG_MIN
#define lONG_MAX		LONG_MAX
#define UlONG_MAX		(u_Long)ULONG_MAX	/* Cast for SunOS cc */

#define strToL(n, e, b)		strtol(n, e, (b))
#define strTouL(n, e, b)	strtoul(n, e, (b))
#define atoL(nptr)		atol((nptr))

/****************************************************************************/
#endif

const char *LTostr A_((Long value, int base));
const char *uLTostr A_((u_Long value, int base));

#endif /* lONG_H */
