/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: credential.h,v 2.2 1999/07/21 22:56:18 lonhyn Exp $
 */

/*
 * credential.h - header file for default authentication system provided
 *	with PBS.  
 *
 * Other Requrired Header Files:
 *	"portability.h"
 *	"libpbs.h"
 *
 */

/* the credential as decrypted by the server */

struct credential {
	time_t timestamp;
	int    type;		/* see BATCH-types.h */
	char   username[PBS_MAXUSER];
	char   hostname[PBS_MAXHOSTNAME];
};

/*
 * a full ticket (credential) as passed from the client to the server
 * is of the following size: 8 for the pbs_iff key + 8 for the timestamp +
 * space for user and host name rounded up to multiple of 8 which is the
 * sub-credential size
 */
#define PBS_KEY_SIZE	 8
#define PBS_TIMESTAMP_SZ 8
#define PBS_SUBCRED_SIZE ((PBS_MAXUSER + PBS_MAXHOSTNAME + 7) / 8 * 8)
#define PBS_SEALED_SIZE (PBS_SUBCRED_SIZE + PBS_TIMESTAMP_SZ)
#define PBS_TICKET_SIZE (PBS_KEY_SIZE + PBS_SEALED_SIZE)

/*
 * a sealed ticket as produced by the server
 */
struct sealed_ticket {
	char timestamp[PBS_TIMESTAMP_SZ];
	char subcred[PBS_SUBCRED_SIZE];
};


#define CREDENTIAL_LIFETIME  3600
#define CREDENTIAL_TIME_DELTA 300

extern void break_cred A_((char key[PBS_KEY_SIZE], char *ticket, int size, struct credential *pcred));
extern int  get_credent A_((char *server,unsigned int port,char **credential));
extern int  make_sealed A_((char key[PBS_KEY_SIZE], char *subcred, int size, char **ticket));
extern void make_svr_key A_((char key[PBS_KEY_SIZE]));
extern int  make_subcred A_((char key[PBS_KEY_SIZE], char *user, char **subcred));
