/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: dis.h,v 2.2 1999/07/21 22:56:19 lonhyn Exp $
 */

#ifndef DATA_IS_STRINGS_
#define DATA_IS_STRINGS_

#include <string.h>
#include <limits.h>
#include <float.h>

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

/*
 * Integer function return values from Data-is-Strings reading calls
 */

#define DIS_SUCCESS	0	/* No error */
#define DIS_OVERFLOW	1	/* Value too large to convert */
#define DIS_HUGEVAL	2	/* Tried to write floating point infinity */
#define DIS_BADSIGN	3	/* Negative sign on an unsigned datum */
#define DIS_LEADZRO	4	/* Input count or value has leading zero */
#define DIS_NONDIGIT	5	/* Non-digit found where a digit was expected */
#define DIS_NULLSTR	6	/* String read has an embedded ASCII NUL */
#define DIS_EOD		7	/* Premature end of message */
#define DIS_NOMALLOC	8	/* Unable to malloc space for string */
#define DIS_PROTO	9	/* Supporting protocol failure */
#define DIS_NOCOMMIT	10	/* Protocol failure in commit */
#define DIS_EOF		11	/* End of File */

#ifdef __STDC__
#define A_(x) x
#else
#define A_(x) ()
#define const
#define volatile
#endif

unsigned long disrul A_((int stream, int *retval));

/*#if UINT_MAX == ULONG_MAX*/
#if SIZEOF_UNSIGNED == SIZEOF_LONG
#define disrui(stream, retval) (unsigned)disrul(stream, (retval))
#else
unsigned disrui A_((int stream, int *retval));
#endif

/*#if USHRT_MAX == UINT_MAX*/
#if SIZEOF_UNSIGNED_SHORT == SIZEOF_UNSIGNED_INT
#define disrus(strea, retval) (unsigned short)disrui(stream, (retval))
#else
unsigned short disrus A_((int stream, int *retval));
#endif

/*#if UCHAR_MAX == USHRT_MAX*/
#if SIZEOF_UNSIGNED_CHAR == SIZEOF_UNSIGNED_SHORT
#define disruc(stream, retval) (unsigned char)disrus(stream, (retval))
#else
unsigned char disruc A_((int stream, int *retval));
#endif

long disrsl A_((int stream, int *retval));
/*#if INT_MIN == LONG_MIN && INT_MAX == LONG_MAX*/
#if SIZEOF_INT == SIZEOF_LONG
#define disrsi(stream, retval) (int)disrsl(stream, (retval))
#else
int disrsi A_((int stream, int *retval));
#endif

/*#if SHRT_MIN == INT_MIN && SHRT_MAX == INT_MAX*/
#if SIZEOF_SHORT == SIZEOF_INT
#define disrss(stream, retval) (short)disrsi(stream, (retval))
#else
short disrss A_((int stream, int *retval));
#endif

/*#if CHAR_MIN == SHRT_MIN && CHAR_MAX == SHRT_MAX*/
#if SIZEOF_SIGNED_CHAR == SIZEOF_SHORT
#define disrsc(stream, retval) (signed char)disrss(stream, (retval))
#else
signed char disrsc A_((int stream, int *retval));
#endif

/*#if CHAR_MIN, i.e. if chars are signed*/
/* also, flip the order of statements */
#if __CHAR_UNSIGNED__
#define disrc(retval, stream) (char)disruc(stream, (retval))
#else
#define disrc(stream, retval) (char)disrsc(stream, (retval))
#endif

char *disrcs A_((int stream, size_t *nchars, int *retval));
int disrfcs A_((int stream, size_t *nchars, size_t achars, char *value));
char *disrst A_((int stream, int *retval));
int disrfst A_((int stream, size_t achars, char *value));

/*
 * some compilers do not like long doubles, if long double is the same
 * as a double, just use a double.
 */
#if SIZEOF_DOUBLE == SIZEOF_LONG_DOUBLE
typedef double dis_long_double_t;
#else
typedef long double dis_long_double_t;
#endif

dis_long_double_t disrl A_((int stream, int *retval));
/*#if DBL_MANT_DIG == LDBL_MANT_DIG && DBL_MAX_EXP == LDBL_MAX_EXP*/
#if SIZEOF_DOUBLE == SIZEOF_LONG_DOUBLE
#define disrd(stream, retval) (double)disrl(stream, (retval))
#else
double disrd A_((int stream, int *retval));
#endif

/*#if FLT_MANT_DIG == DBL_MANT_DIG && FLT_MAX_EXP == DBL_MAX_EXP*/
#if SIZEOF_FLOAT == SIZEOF_DOUBLE
#define disrf(stream, retval) (float)disrd(stream, (retval))
#else
float disrf A_((int stream, int *retval));
#endif

int diswul A_((int stream, unsigned long value));
/*#if UINT_MAX == ULONG_MAX*/
#if SIZEOF_UNSIGNED_INT == SIZEOF_UNSIGNED_LONG
#define diswui(stream, value) diswul(stream, (unsigned long)(value))
#else
int diswui A_((int stream, unsigned value));
#endif
#define diswus(stream, value) diswui(stream, (unsigned)(value))
#define diswuc(stream, value) diswui(stream, (unsigned)(value))

int diswsl A_((int stream, long value));
/*#if INT_MIN == LONG_MIN && INT_MAX == LONG_MAX*/
#if SIZEOF_INT == SIZEOF_LONG
#define diswsi(stream, value) diswsl(stream, (long)(value))
#else
int diswsi A_((int stream, int value));
#endif
#define diswss(stream, value) diswsi(stream, (int)(value))
#define diswsc(stream, value) diswsi(stream, (int)(value))

/*#if CHAR_MIN*/
#if __UNSIGNED_CHAR__
#define diswc(stream, value) diswui(stream, (unsigned)(value))
#else
#define diswc(stream, value) diswsi(stream, (int)(value))
#endif

int diswcs A_((int stream, const char *value, size_t nchars));
#define diswst(stream, value) diswcs(stream, value, strlen(value))

int diswl_ A_((int stream, dis_long_double_t value, unsigned int ndigs));
#define diswl(stream, value) diswl_(stream, (value), LDBL_DIG)
#define diswd(stream, value) diswl_(stream, (dis_long_double_t)(value), DBL_DIG)
/*#if FLT_MANT_DIG == DBL_MANT_DIG || DBL_MANT_DIG == LDBL_MANT_DIG*/
#if SIZEOF_FLOAT == SIZEOF_DOUBLE
#define diswf(stream, value) diswl_(stream, (dis_long_double_t)(value), FLT_DIG)
#else
int diswf A_((int stream, double value));
#endif

extern const char *dis_emsg[];

/* the following routines set/control DIS over tcp */

extern void DIS_tcp_reset A_((int fd, int rw));
extern void DIS_tcp_setup A_((int fd));
extern int  DIS_tcp_wflush A_((int fd));

#endif	/* DATA_IS_STRINGS_ */
