/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: log.h,v 2.2 1999/07/21 22:56:22 lonhyn Exp $
 */

/*
 * include file for error/event logging
 */
#define LOG_BUF_SIZE		1024

/* The following macro assist in sharing code between the Server and Mom */
#define LOG_EVENT log_event

/*
** Set up a debug print macro.
*/
#ifdef	DEBUG
#define	DBPRT(x)	printf x;
#else
#define	DBPRT(x)
#endif

extern long *log_event_mask;

extern void log_close A_((int close_msg));
extern void log_err A_((int err, char *func, char *text));
extern void log_event A_((int type, int class, char *id, char *text));
extern int  log_open A_((char *name, char *directory));
extern void log_record A_((int type, int class, char *id, char *text));
extern char log_buffer[LOG_BUF_SIZE];

extern int  chk_path_sec A_((char *path, int dir, int sticky, int bad, int));
extern int  setup_env A_((char *filename));

/* Event types */

#define PBSEVENT_ERROR		0x0001		/* internal errors	      */
#define PBSEVENT_SYSTEM		0x0002		/* system (server) events     */
#define PBSEVENT_ADMIN		0x0004		/* admin events		      */
#define PBSEVENT_JOB		0x0008		/* job related events	      */
#define PBSEVENT_JOB_USAGE	0x0010		/* End of Job accounting      */
#define PBSEVENT_SECURITY	0x0020		/* security violation events  */
#define PBSEVENT_SCHED		0x0040		/* scheduler events	      */
#define PBSEVENT_DEBUG		0x0080		/* common debug messages      */
#define PBSEVENT_DEBUG2		0x0100		/* less needed debug messages */
#define PBSEVENT_FORCE		0x8000		/* set to force a messag      */

/* Event Object Classes, see array class_names[] in ../lib/Liblog/pbs_log.c   */

#define PBS_EVENTCLASS_SERVER	1	/* The server itself	*/
#define PBS_EVENTCLASS_QUEUE	2	/* Queues		*/
#define PBS_EVENTCLASS_JOB	3	/* Jobs			*/
#define PBS_EVENTCLASS_REQUEST	4	/* Batch Requests	*/
#define PBS_EVENTCLASS_FILE	5	/* A Job related File	*/
#define PBS_EVENTCLASS_ACCT	6	/* Accounting info	*/
#define PBS_EVENTCLASS_NODE	7	/* Nodes          	*/

/* Logging Masks */

#define PBSEVENT_MASK 	0x01ff
