/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: mom_func.h,v 2.6 1999/10/18 21:22:01 hender Exp $
 */


#ifndef MOM_MACH
#include "mom_mach.h"
#endif	/* MOM_MACH */

/* struct var_table = used to hold environment variables for the job */

struct var_table {
	char  *v_block;
	char **v_envp;
	int    v_bsize;
	int    v_ensize;
	int    v_used;
};

/* struct sig_tbl = used to hold map of local signal names to values */

struct sig_tbl {
	char *sig_name;
	int   sig_val;
};

#define NUM_LCL_ENV_VAR  10

/* used by mom_main.c and requests.c for $usecp */

struct cphosts {
	char *cph_hosts;
	char *cph_from;
	char *cph_to;
};
extern int cphosts_num;

/* public funtions within MOM */

#ifdef _CRAY
#define WJSIGNAL	46

extern void  post_suspend A_((job *, int));
extern void  post_resume  A_((job *, int));

#endif	/* _CRAY */

extern void  bld_env_variables A_((struct var_table *, char *, char *));
extern pid_t fork_me A_((int sock));
extern int   get_la A_((double *));
extern void  init_abort_jobs A_((int));
extern int   init_groups A_((char *, int, int, int *));
extern int   kill_job A_((job *, int sig));
extern void  mom_deljob A_((job *));
extern void  mom_freenodes A_((job *));
extern void  scan_for_exiting();
extern void  scan_for_terminated();
extern int   set_job A_((job *, struct startjob_rtn *));
extern void  set_globid A_((job *, struct startjob_rtn *));
extern int   set_mach_vars A_((job *, struct var_table *));
extern char *set_shell A_((job *, struct passwd *));
extern void  start_exec A_((job *));
extern int   open_master();
extern int   open_slave();
extern char *rcvttype A_((int));
extern int   rcvwinsize A_((int));
extern int   remtree A_((char *));
extern int   setwinsize A_((int));
extern void  set_termcc A_((int));
extern int   site_job_setup A_((job *));
extern int   site_mom_chkuser A_((job *));
extern int   site_mom_postchk A_((job *, int));
extern int   site_mom_prerst A_((job *));
extern int   reader A_((int, int));
extern int   writer A_((int, int));
extern int   conn_qsub A_((char *host, unsigned int port));
extern int   run_pelog A_((int which, char *file, job *pjob, int pe_io_type));
extern int   is_joined A_((job *));
extern void  check_busy A_((double));
extern void  state_to_server A_((int));

/* Defines for pe_io_type, see run_pelog() */

#define PE_IO_TYPE_NULL	-1
#define PE_IO_TYPE_ASIS	0
#define PE_IO_TYPE_STD 	1
#define PE_PROLOGUE	1
#define PE_EPILOGUE	2

#ifdef LIBPBS_H
extern int   open_std_file A_((job *, enum job_file, int, gid_t));
extern char *std_file_name A_((job *, enum job_file, int *keeping));
#endif	/* LIBPBS_H */

#ifdef BATCH_REQUEST_H
extern int   start_checkpoint A_((job *, int abt, struct batch_request *pq));
#endif /* BATCH_REQUEST_H */
