/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: net_connect.h,v 2.4 1999/10/18 21:22:01 hender Exp $
 */

/* 
 * Other Include Files Required 
 *	<sys/types.h>
 */
#define PBS_NET_H
#ifndef PBS_NET_TYPE
typedef unsigned long pbs_net_t;        /* for holding host addresses */
#define PBS_NET_TYPE
#endif

#define PBS_NET_MAXCONNECTIDLE  900
#define PBS_NET_CONN_AUTHENTICATED 1
#define PBS_NET_CONN_FROM_PRIVIL  2

/*
**	Protocol numbers and versions for PBS communications.
*/

#define RM_PROTOCOL	1	/* resource monitor protocol number */
#define RM_PROTOCOL_VER	1	/* resmon protocol version number */

#define	TM_PROTOCOL	2	/* task manager protocol number */
#define	TM_PROTOCOL_VER	1	/* task manager protocol version number */

#define	IM_PROTOCOL	3	/* inter-manager protocol number */
#define	IM_PROTOCOL_VER	1	/* inter-manager protocol version number */

#define	IS_PROTOCOL	4	/* inter-server protocol number */
#define	IS_PROTOCOL_VER	1	/* inter-server protocol version number */


/*
**	Types of Inter Server messages.
*/
#define	IS_NULL			0
#define	IS_HELLO		1
#define	IS_CLUSTER_ADDRS	2
#define IS_UPDATE		3

/* return codes for client_to_svr() */

#define PBS_NET_RC_FATAL -1
#define PBS_NET_RC_RETRY -2

enum conn_type {
	Primary = 0,
	Secondary,
	FromClientASN,
	FromClientDIS,
	ToServerASN,
	ToServerDIS,
	TaskManagerDIS,
	Idle
};

/* functions available in libnet.a */

void add_conn A_((int sock, enum conn_type, pbs_net_t, unsigned int port, void (*func) A_((int)) ));
int  client_to_svr A_((pbs_net_t, unsigned int port, int));
void close_conn A_((int socket));
pbs_net_t get_connectaddr A_((int sock));
int  get_connecthost A_((int sock, char *namebuf, int size));
pbs_net_t get_hostaddr A_((char *hostname));
int  get_fullhostname A_((char *shortname, char *namebuf, int size));
unsigned int  get_svrport A_((char *servicename, char *proto, unsigned int df));
int  init_network A_((unsigned int port, void (*readfunc)()));
void net_close A_((int));
int  wait_request A_((int waittime));
void net_add_close_func A_((int, void(*)()));
void net_set_type A_((enum conn_type, enum conn_type));


struct connection {
	pbs_net_t	cn_addr;	/* internet address of client */
	int		cn_handle;	/* handle for API, see svr_connect() */
	unsigned int	cn_port;	/* internet port number of client */
	unsigned short  cn_authen;	/* authentication flags */
	enum conn_type	cn_active;	/* idle or type if active */
	time_t		cn_lasttime;	/* time last active */
	void		(*cn_func) A_((int)); /* read function when data rdy */
	void		(*cn_oncl) A_((int)); /* func to call on close */
};
