/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: pbs_nodes.h,v 2.8 1999/11/04 23:10:53 hender Exp $
 */

/*
**	Header file used for the node tracking routines.
*/



enum	psit {
	okay,
	thinking,
	conflict,
	ignore
};

struct	prop {
	char	*name;
	short	mark;
	struct	prop	*next;
};

struct	jobinfo {
	struct	job	*job;
	struct	jobinfo	*next;
};

struct	pbssubn {
	struct pbsnode  *host;
	struct pbssubn  *next;
	struct	jobinfo	*jobs;
	resource_t	allocto;
	enum	psit	flag;		/* XXX */
	unsigned short	inuse;
	short		index;		/* subnode index */
};

struct	pbsnode {
	char			*nd_name;	/* node's host name */
	struct pbssubn		*nd_psn;	/* ptr to list of subnodes */
	struct	prop		*nd_first;	/* first and last property */
	struct	prop		*nd_last;
	u_long			*nd_addrs;	/* IP addresses of host */
	struct array_strings	*nd_prop;	/* array of properities */
	int		 	 nd_stream;	/* RPP stream to Mom on host */
	enum	psit		 nd_flag;
	short		 	 nd_nprops;	/* number of properities */
	short		 	 nd_nsn;	/* number of VPs  */
	short		 	 nd_nsnfree;	/* number of VPs free */
	short			 nd_nsnshared;	/* number of VPs shared */
	short			 nd_needed;	/* number of VPs needed */
	unsigned short	 	 nd_state;
	unsigned short	 	 nd_ntype;	/* node type */
	short			 nd_order;	/* order of user's request */
};
	

/*
 * The following INUSE_ are used in both subnode.inuse and in node.nd_state
 */
#define	INUSE_FREE	 0x00	/* Node/VP is available			*/
#define	INUSE_OFFLINE	 0x01	/* Node was removed by administrator	*/
#define	INUSE_DOWN	 0x02	/* Node is down/unresponsive 		*/
#define INUSE_DELETED	 0x04	/* Node is "deleted"			*/
#define	INUSE_RESERVE	 0x08	/* VP   being reserved by scheduler	*/
#define	INUSE_JOB	 0x10	/* VP   in use by job (exclusive use)	*/
#define INUSE_JOBSHARE	 0x20	/* VP   is use by job(s) (time shared)	*/
#define INUSE_BUSY	 0x40	/* Node is busy (high loadave)		*/

#define INUSE_UNKNOWN	 0x100	/* Node has not been heard from yet	*/
#define INUSE_NEEDS_HELLO_PING	0x200 	/*node needs to be informed of a*/
					/*new qmgr created node         */
#define INUSE_SUBNODE_MASK 0xff	/* bits both in nd_state and inuse	*/
#define INUSE_COMMON_MASK  (INUSE_OFFLINE|INUSE_DOWN)
				/* state bits that go from node to subn */

/*
 * NTYPE_ are used in node.nd_type
 */
#define NTYPE_CLUSTER	 0x00	/* Node is normal allocatable node	*/
#define NTYPE_TIMESHARED 0x01	/* Node is Time Shared Node		*/

#define TIMESHARED_SUFFIX	"ts"
#define PBS_MAXNODENAME	80	/* upper bound on the node name size    */

#define	PBSNODE_STATE		0x1		 /* characteristic code */
#define PBSNODE_PROPERTIES	0x2		 /* characteristic code */
#define PBSNODE_NTYPE		0x3		 /* characteristic code */
#define PBSNODE_NTYPE_MASK	0xf		 /* relevant ntype bits */

#define WRITENODE_STATE		0x1		 /*associated w/ offline*/
#define WRITE_NEW_NODESFILE	0x2 /*changed: deleted,ntype,or properties*/

/*
 * Although at the present time a struct pbssnode doesn't have an array of
 * attributes associated with it, it is convenient for the server's req_manager
 * function to use as much of the existing attribute processing functions and
 * philosophy as practical to carry out any node modification requests sent via
 * "qmgr".   For this reason, and for the fact that some day struct pbssnodes
 * may be redefined to possess attributes, it is convenient to pretend that
 * nodes have an associated attributes array just as a server or a queue or
 * a job would have.
 *
 * The following enum defines the index into the node_attr_def[]  array.
 */

enum nodeattr {
	ND_ATR_state,
	NODE_ATR_np,
	ND_ATR_properties,
	ND_ATR_ntype,
	ND_ATR_jobs,
	ND_ATR_LAST	/* WARNING: Must be the highest valued enum */
};

extern struct attribute_def  node_attr_def[];	/* node attributes defs */
extern	struct pbsnode	**pbsndmast;		/* array of ptr to nodes  */
extern	struct pbsnode	**pbsndlist;		/* array of ptr to nodes  */
extern  int		  svr_totnodes;		/* number of nodes (hosts) */
extern  int		  svr_tsnodes;		/* number of timeshared nodes */
extern	int		  svr_clnodes;		/* number of cluster nodes */
extern	struct tree_t	 *ipaddrs;
extern	struct tree_t	 *streams;

extern	int	update_nodes_file A_(());

#ifdef BATCH_REQUEST_H
extern	void	initialize_pbssubn A_((struct pbsnode *, struct pbssubn*, struct prop*));
extern	void	effective_node_delete A_((struct pbsnode *));
extern	void	setup_notification A_((void));
extern  struct pbssubn  *find_subnodebyname A_((char *));
extern	struct pbsnode  *find_nodebyname A_((char *));
extern	void	free_prop_list A_((struct prop*));
extern void     free_prop_attr  A_(( attribute* ));
extern	void	recompute_ntype_cnts A_(());
extern  int     create_pbs_node A_((char *, svrattrl *, int, int *));
extern  int     mgr_set_node_attr A_((struct pbsnode *, attribute_def *, int, svrattrl *, int, int *, void *, int));
struct prop 	*init_prop A_((char *pname));
#endif	/* BATCH_REQUEST_H */
