/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: server_limits.h,v 2.2 1999/07/21 22:56:36 lonhyn Exp $
 */

/*
 * This section contains size limit definitions
 *
 * BEWARE OF CHANGING THESE
 */
#ifndef SERVER_LIMITS_H
#define SERVER_LIMITS_H

#define PBS_JOBBASE  11		/* basename size for job file, 11 = 14 -3   */
				/* where 14 is min file name, 3 for suffix  */
#define PBS_NUMJOBSTATE 6

#define PBS_MAX_HOPCOUNT 10	/* limit on number of routing hops per job */

#define PBS_SEQNUMTOP 999999	/* top number for job sequence number, reset */
				/* to zero when reached, see req_quejob.c    */

#define PBS_NET_RETRY_TIME     30 /* Retry time between re-sending requests  */
#define PBS_NET_RETRY_LIMIT 14400 /* Max retry time */
#define PBS_SCHEDULE_CYCLE    600 /* re-schedule even if no change, 10 min   */
#define PBS_RESTAT_JOB	       30 /* ask mom for status only once in 30 sec  */
#define PBS_STAGEFAIL_WAIT   1800 /* retry time after stage in failuere */

/* Server Database information - path names */

#define PBS_SVR_PRIVATE		"server_priv"
#define PBS_ACCT		"accounting"
#define PBS_JOBDIR		"jobs"
#define PBS_SPOOLDIR		"spool"
#define PBS_QUEDIR		"queues"
#define PBS_LOGFILES		"server_logs"
#define PBS_ACTFILES		"accounting"
#define PBS_SERVERDB		"serverdb"
#define PBS_SVRACL		"acl_svr"
#define PBS_TRACKING		"tracking"
#define NODE_DESCRIP		"nodes"
#define NODE_STATUS		"node_status"


#define PBS_NET_MAX_CONNECTIONS 256
#define PBS_LOCAL_CONNECTION PBS_NET_MAX_CONNECTIONS

/*
 * Security, Authentication, Authorization Control:
 *
 *	- What account is PBS mail from
 *	- Who is the default administrator (when none defined)
 *	- Is "root" always an batch adminstrator (manager) (YES/no)
 */

#define PBS_DEFAULT_MAIL	"adm"
#define PBS_DEFAULT_ADMIN	"root"
#define PBS_ROOT_ALWAYS_ADMIN	1


/* #define NO_SPOOL_OUTPUT 1	User output in home directory,not spool */

/* "simplified" network address structure */

#ifndef PBS_NET_TYPE
typedef unsigned long pbs_net_t;	/* for holding host addresses */
#define PBS_NET_TYPE
#endif	/* PBS_NET_TYPE */

/* defines for job moving (see net_move() ) */

#define MOVE_TYPE_Move  1	/* Move by user request */
#define MOVE_TYPE_Route 2	/* Route from routing queue */
#define MOVE_TYPE_Exec  3	/* Execution (move to MOM) */
#define MOVE_TYPE_MgrMv	4	/* Mover by privileged user, a manager */
#define MOVE_TYPE_Order 5	/* qorder command by user */

/*
 * server initialization modes
 */
#define RECOV_HOT    0		/* restart prior running jobs   */
#define RECOV_WARM   1		/* requeue/reschedule  all jobs */
#define RECOV_COLD   2 		/* discard all jobs		*/
#define RECOV_CREATE 4		/* discard all info		*/
#define RECOV_Invalid 5

#endif	/* SERVER_LIMITS_H */
