/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: tm.h,v 2.2 1999/07/21 22:56:43 lonhyn Exp $
 */

#include	"portability.h"

/*
**	Header file defineing the datatypes and library visiable
**	variables for paralell awareness.
*/

#include	"tm_.h"

/*
**	The tm_roots structure contains data for the last
**	tm_init call whose event has been polled.  <Me> is the
**	caller's identity.  <Daddy> is the identity of the task that
**	spawned the caller.  If <daddy> is the TM_NULL_TASK, the caller
**	is the initial task of the job, running on job-relative
**	node 0.
*/
struct	tm_roots {
	tm_task_id	tm_me;
	tm_task_id	tm_parent;
	int		tm_nnodes;
	int		tm_ntasks;
	int		tm_taskpoolid;
	tm_task_id	*tm_tasklist;
};

/*
**	The tm_whattodo structure contains data for the last
**	tm_register event polled.  This is not implemented yet.
*/
struct	tm_whattodo {
	int		tm_todo;
	tm_task_id	tm_what;
	tm_node_id	tm_where;
}	typedef		tm_whattodo_t;

/*
**	Prototypes for all the TM API calls.
*/
int	tm_init		A_((	void *info,
				struct tm_roots		*roots));

int	tm_poll		A_((	tm_event_t		poll_event,
				tm_event_t		*result_event,
				int			wait,
				int			*tm_errno));

int	tm_notify	A_((	int			tm_signal));

int	tm_spawn	A_((	int			 argc,
				char			*argv[],
				char			*envp[],
				tm_node_id		where,
				tm_task_id		*tid,
				tm_event_t		*event));

int	tm_kill		A_((	tm_task_id		tid,
				int			sig,
				tm_event_t		*event));

int	tm_obit		A_((	tm_task_id		tid,
				int			*obitval,
				tm_event_t		*event));

int	tm_nodeinfo	A_((	tm_node_id		**list,
				int			*nnodes));

int	tm_taskinfo	A_((	tm_node_id		node,
				tm_task_id		*list,
				int			lsize,
				int			*ntasks,
				tm_event_t		*event));

int	tm_atnode	A_((	tm_task_id		tid,
				tm_node_id		*node));

int	tm_rescinfo	A_((	tm_node_id		node,
				char			*resource,
				int			len,
				tm_event_t		*event));

int	tm_publish	A_((	char			*name,
				void			*info,
				int			nbytes,
				tm_event_t		*event));

int	tm_subscribe	A_((	tm_task_id		tid,
				char			*name,
				void			*info,
				int			len,
				int			*amount,
				tm_event_t		*event));

int	tm_finalize	();

int	tm_alloc	A_((	char			*resources,
				tm_event_t		*event));

int 	tm_dealloc	A_((	tm_node_id		node,
				tm_event_t		*event));

int	tm_create_event	A_((	tm_event_t		*event));

int	tm_destroy_event	A_((	tm_event_t	*event));

int	tm_register	A_((	tm_whattodo_t		*what,
				tm_event_t		*event));
