/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: tm_.h,v 2.2 1999/07/21 22:56:43 lonhyn Exp $
 */

/*
**	Header file defineing the datatypes and library visiable
**	variables for paralell awareness.
*/

#include	<sys/types.h>

typedef int		tm_node_id;	/* job-relative node id */
#define TM_ERROR_NODE	((tm_node_id)-1)

typedef int		tm_event_t;	/* event handle, > 0 for real events */
#define TM_NULL_EVENT	((tm_event_t)0)
#define TM_ERROR_EVENT	((tm_event_t)-1)

typedef unsigned long	tm_task_id;
#define TM_NULL_TASK	(tm_task_id)0

/*
**	Protocol message type defines
*/
#define	TM_INIT		100	/* tm_init request	*/
#define TM_TASKS	101	/* tm_taskinfo request	*/
#define	TM_SPAWN	102	/* tm_spawn request	*/
#define	TM_SIGNAL	103	/* tm_signal request	*/
#define	TM_OBIT		104	/* tm_obit request	*/
#define TM_RESOURCES	105	/* tm_rescinfo request	*/
#define TM_POSTINFO	106	/* tm_publish request	*/
#define TM_GETINFO	107	/* tm_subscribe request	*/
#define	TM_GETTID	108	/* tm_gettasks request */
#define	TM_REGISTER	109	/* tm_register request	*/
#define	TM_RECONFIG	110	/* tm_register deferred reply */
#define	TM_ACK		111	/* tm_register event acknowledge */
#define TM_FINALIZE	112	/* tm_finalize request, there is no reply */
#define TM_OKAY		  0


#define	TM_ERROR	999

/*
**	Error numbers returned from library
*/
#define TM_SUCCESS		0
#define	TM_ESYSTEM		17000
#define	TM_ENOEVENT		17001
#define	TM_ENOTCONNECTED	17002
#define	TM_EUNKNOWNCMD		17003
#define	TM_ENOTIMPLEMENTED	17004
#define	TM_EBADENVIRONMENT	17005
#define	TM_ENOTFOUND		17006

#define	TM_TODO_NOP	5000	/* Do nothing (the nodes value may be new) */
#define	TM_TODO_CKPT	5001	/* Checkpoint <what> and continue it */
#define	TM_TODO_MOVE	5002	/* Move <what> to <where> */
#define	TM_TODO_QUIT	5003	/* Terminate <what> */
#define	TM_TODO_STOP	5004	/* Suspend execution of <what> */
