/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: work_task.h,v 2.2 1999/07/21 22:56:45 lonhyn Exp $
 */

/*
 * Server Work Tasks
 *
 * This structure is used by the server to track deferred work tasks.
 *
 * This information need not be preserved.
 *
 * Other Required Header Files
 *	"list_link.h"
 */

#ifndef WORK_TASK_H
#define WORK_TASK_H 1

enum work_type {
	WORK_Immed,		/* immediate action: see state */
	WORK_Timed,		/* action at certain time */
	WORK_Deferred_Child,	/* On Death of a Child */
	WORK_Deferred_Reply,	/* On reply to an outgoing service request */
	WORK_Deferred_Local,	/* On reply to a local service request */
	WORK_Deferred_Other,	/* various other events */

	WORK_Deferred_Cmp	/* Never set directly, used to indicate that */
				/* a WORK_Deferred_Child is ready            */
};

struct work_task  {
	list_link	 wt_linkall;	/* link to event type work list */
	list_link	 wt_linkobj;	/* link to others of same object */
	long		 wt_event;	/* event id: time, pid, socket, ... */
	enum work_type	 wt_type;	/* type of event */
	void	       (*wt_func) A_((struct work_task *));
					/* function to perform task */
	void		*wt_parm1;	/* obj pointer for use by func */
	void		*wt_parm2;	/* optional pointer for use by func */
	int		 wt_aux;	/* optional info: e.g. child status */
};

extern struct work_task *set_task A_((enum work_type, long event, void (*func)(), void *param));
extern void clear_task A_((struct work_task *ptask));
extern void dispatch_task A_((struct work_task *));

#endif	/* WORK_TASK_H */
