/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 *  parse_jobid
 *
 * takes a job_id string as input, parses it to separate the 
 * 'current_server[:port]' part, and returns this in the return 
 * argument 'server'; if things go OK, the function value is
 * set to 0, if errors, it is set to 1.   The 'current_server[:port]'
 * part of 'job_id' is removed, if it was present.
 *
 * Full legal syntax is:
 *  seq_number[.parent_server[:port]][@current_server[:port]]  
 */

static char ident[] = "@(#) $RCSfile: parse_jobid.c,v $ $Revision: 2.1 $";

#include <pbs_config.h>   /* the master config generated by configure */

#include <string.h>
#include <ctype.h>
#include "pbs_ifl.h"

#define MAXSERVERNAME PBS_MAXSERVERNAME+PBS_MAXPORTNUM+2
#define ISNAMECHAR(x) ( (isgraph(x)) && ((x) != '#') && ( (x) != '@') )

static char seq_number[PBS_MAXSEQNUM+1]; 
static int s_pos;
static char parent_server[MAXSERVERNAME]; 
static int p_pos;
static char current_server[MAXSERVERNAME]; 
static int c_pos;

int parse_jobid(job_id, arg_seq_number, arg_parent_server, arg_current_server)
char *job_id;
char **arg_seq_number;
char **arg_parent_server;
char **arg_current_server;
{
    int i;
    char *c;

    /* initialize static data for this parsing call */
    for ( i=0; i<PBS_MAXSEQNUM+1; i++ ) seq_number[i]='\0';
    s_pos = 0;
    for ( i=0; i<MAXSERVERNAME; i++ ) parent_server[i]='\0';
    p_pos = 0;
    for ( i=0; i<MAXSERVERNAME; i++ ) current_server[i]='\0';
    c_pos = 0;

    /* Begin the parse */
    c = job_id;
    while ( isspace(*c) ) c++;

    /* Looking for a seq_number */
    while ( *c != '\0' ) {
        if ( isdigit(*c) ) {
	    if ( s_pos >= PBS_MAXSEQNUM ) return 3;
            seq_number[s_pos++]=*c;
        } else
            break;
        c++;
    }
    if ( s_pos == 0 ) return 1;

    /* Looking for a parent_server */
    if ( *c == '.' ) {
        c++;
        while ( *c != '\0' ) {
            if ( ISNAMECHAR(*c) ) {
	        if ( p_pos >= MAXSERVERNAME ) return 3;
                parent_server[p_pos++]=*c;
            } else
                break;
            c++;
        }
        if ( p_pos == 0 ) return 1;
    }

    /* Looking for a current_server */
    if ( *c == '@' ) {
        c++;
        while ( *c != '\0' ) {
            if ( ISNAMECHAR(*c) ) {
	        if ( c_pos >= MAXSERVERNAME ) return 3;
                current_server[c_pos++]=*c;
            } else
                break;
            c++;
        }
        if ( c_pos == 0 ) return 1;
    }

    if ( *c != '\0' ) return 2;

    /* set char * pointers to static data, to arguments */
    if ( arg_seq_number != NULL ) *arg_seq_number = seq_number;
    if ( arg_parent_server != NULL ) *arg_parent_server = parent_server;
    if ( arg_current_server != NULL ) *arg_current_server = current_server;

    return 0;
}
