/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * set_attr
 *
 *	Add an entry to an attribute list. First, create the entry and set
 * the fields. If the attribute list is empty, then just point it at the
 * new entry. Otherwise, append the new entry to the list.
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "pbs_ifl.h"

static char ident[] = "@(#) $RCSfile: set_attr.c,v $ $Revision: 2.1 $";

void 
set_attr(attrib, attrib_name, attrib_value)
struct attrl **attrib;
char *attrib_name;
char *attrib_value;
{
    struct attrl *attr, *ap;
    
    attr = (struct attrl *) malloc(sizeof(struct attrl));
    if ( attr == NULL ) {
        fprintf(stderr, "Out of memory\n");
        exit(2);
    }
    if ( attrib_name == NULL )
        attr->name = NULL;
    else {
        attr->name = (char *) malloc(strlen(attrib_name)+1);
        if ( attr->name == NULL ) {
            fprintf(stderr, "Out of memory\n");
            exit(2);
        }
        strcpy(attr->name, attrib_name);
    }
    attr->resource = NULL;
    if ( attrib_value == NULL )
        attr->value = NULL;
    else {
        attr->value = (char *) malloc(strlen(attrib_value)+1);
        if ( attr->name == NULL ) {
            fprintf(stderr, "Out of memory\n");
            exit(2);
        }
        strcpy(attr->value, attrib_value);
    }
    attr->next = NULL;
    if ( *attrib == NULL ) {
        *attrib = attr;
    } else {
        ap = *attrib;
	while ( ap->next != NULL ) ap = ap->next;
        ap->next = attr;
    }

    return;
}
