/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * set_resources
 *
 *	Append a entries to the attribute list that are from the resource list.
 * If the add flag is set, append the resource regardless. Otherwise, append
 * it only if it is not already on the list.
 *
 */

#include <pbs_config.h>   /* the master config generated by configure */

#define TRUE	1
#define FALSE	0

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "pbs_ifl.h"

static char ident[] = "@(#) $RCSfile: set_resource.c,v $ $Revision: 2.2 $";

int
set_resources(attrib, resources, add)
struct attrl **attrib;
char *resources;
int add;
{
    char *r, *eq, *v, *e;
    char *str;
    struct attrl *attr, *ap;
    int found, len;

    r = resources;
    while ( *r != '\0' ) {

	/* Skip any leading whitespace */
	while (isspace((int)*r))
		r++;

	/* Get the resource name */
        eq = r;
	while ( *eq != '=' && *eq != ',' && *eq != '\0' ) eq++;
	
	/* Make sure there is a resource name */
        if ( r == eq ) {
            return (1);
        }

	/*
	 * Count the number of non-space character that make up the
	 * resource name.  Count only up to the last character before the
	 * separator ('\0', ',' or '=').
	 */
	for (str=r, len=0; str<eq && !isspace((int)*str); str++)
		len++;

	/* If separated by an equal sign, get the value */
	if ( *eq == '=' ) {
	    v = eq + 1;
	    while ( isspace((int)*v) ) v++;
	    e = v;
	    while ( *e != ',' && *e != '\0' ) {
		if ( isspace((int)*e) ) return(1);
	        e++;
	    }
	} else
	    v = NULL;
	
        /* Allocate memory for the attrl structure */
        attr = (struct attrl *) malloc(sizeof(struct attrl));
        if ( attr == NULL ) {
            fprintf(stderr, "Out of memory\n");
            exit(2);
        }
	
        /* Allocate memory for the attribute name and copy */
        str = (char *) malloc( strlen(ATTR_l)+1 );
        if ( str == NULL ) {
            fprintf(stderr, "Out of memory\n");
            exit(2);
        }
        strcpy(str, ATTR_l);
        attr->name = str;
	
        /* Allocate memory for the resource name and copy */
        str = (char *) malloc( len + 1 );
        if ( str == NULL ) {
            fprintf(stderr, "Out of memory\n");
            exit(2);
        }
        strncpy(str, r, len);
        str[len] = '\0';
        attr->resource = str;
	
        /* Allocate memory for the value and copy */
	if ( v != NULL ) {
            str = (char *) malloc(e-v+1);
            if ( str == NULL ) {
                fprintf(stderr, "Out of memory\n");
                exit(2);
            }
            strncpy(str, v, e-v);
            str[e-v] = '\0';
            attr->value = str;
	} else {
	    str = (char *) malloc(1);
	    if ( str == NULL ) {
                fprintf(stderr, "Out of memory\n");
                exit(2);
            }
	    str[0] = '\0';
	    attr->value = str;
	}

        /* Put it on the attribute list */
	/* If the argument add is true, add to the list regardless.
	 * Otherwise, add it to the list only if the resource name
	 * is not already on the list.
	 */
        attr->next = NULL;
        if ( *attrib == NULL ) {
            *attrib = attr;
        } else {
            ap = *attrib;
	    found = FALSE;
	    while ( ap->next != NULL ) {
	        if ( strcmp(ap->name, ATTR_l) == 0 &&
		     strcmp(ap->resource, attr->resource) == 0 ) found = TRUE;
	        ap = ap->next;
	    }
	    if ( add || !found ) ap->next = attr;
        }

	/* Get ready for next resource/value pair */
	if ( v != NULL )
	    r = e;
	else
            r = eq;
	if ( *r == ',' ) {
	    r++;
	    if ( *r == '\0' ) {
                return (1);
	    }
	}
    }
    return (0);
}
