/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
#include <pbs_config.h>   /* the master config generated by configure */

#include <assert.h>
#include <float.h>
#include <stddef.h>
#include <stdlib.h>

#include <dis.h>

unsigned dis_dmx10 = 0;
double *dis_dp10 = NULL;
double *dis_dn10 = NULL;

/*
 *	Allocate and fill tables with all powers of 10 that fit the forms:
 *
 *				  n
 *				 2
 *		*dis_dp10[n] = 10
 *
 *				  ( n)
 *				 -(2 )
 *		*dis_dn10[n] = 10
 *
 *	For all values of n supported by the floating point format.  Set
 *	dis_dmx10 equal to the largest value of n that fits the format.
 */

void disi10d_() {
	int		i;
	unsigned long	ul;
	dis_long_double_t	accum;
	size_t		tabsize;

	assert(dis_dp10 == NULL);
	assert(dis_dn10 == NULL);
	assert(dis_dmx10 == 0);

#if DBL_MAX_10_EXP + DBL_MIN_10_EXP > 0
	ul = DBL_MAX_10_EXP;
#else
	ul = -DBL_MIN_10_EXP;
#endif
	while (ul >>= 1)
		dis_dmx10++;
	tabsize = (dis_dmx10 + 1) * sizeof(double);
	dis_dp10 = (double *)malloc(tabsize);
	assert(dis_dp10 != NULL);
	dis_dn10 = (double *)malloc(tabsize);
	assert(dis_dn10 != NULL);
	assert(dis_dmx10 > 0);
	dis_dp10[0] = accum = 10.0L;
	dis_dn10[0] = 1.0L / accum;
	for (i = 1; i <= dis_dmx10; i++) {
		accum *= accum;
		dis_dp10[i] = accum;
		dis_dn10[i] = 1.0L / accum;
	}
}
