/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
#include <pbs_config.h>   /* the master config generated by configure */

#include <assert.h>
#include <math.h>
#include <stddef.h>

#include "dis.h"
#include "dis_.h"

int disrl_(stream, ldval, ndigs, nskips, sigd, count)
    int			stream;
    dis_long_double_t		*ldval;
    unsigned		*ndigs;
    unsigned		*nskips;
    unsigned		sigd;
    unsigned		count;
    {
	int		c;
	int		negate;
	unsigned	unum;
	char		*cp;
	dis_long_double_t	fpnum;

	assert(stream >= 0);
	assert(dis_getc != NULL);
	assert(disr_skip != NULL);

	if (dis_umaxd == 0)
	        disiui_();
	switch (c = (*dis_getc)(stream)) {
	    case '-':
	    case '+':
		negate = c == '-';
		*nskips = count > sigd ? count - sigd : 0;
		count -= *nskips;
		*ndigs = count;
		fpnum = 0.0L;
		do {
			if ((c = (*dis_getc)(stream)) < '0' || c > '9') {
				if (c < 0)
				        return (DIS_EOD);
				return (DIS_NONDIGIT);
			}
			fpnum = fpnum * 10.0L + (dis_long_double_t)(c - '0');
		} while (--count);
		if ((count = *nskips) > 0) {
			count--;
			switch ((*dis_getc)(stream)) {
			    case '5':
				if (count == 0)
				        break;
			    case '6':
			    case '7':
			    case '8':
			    case '9':
			        fpnum += 1.0L;
			    case '0':
			    case '1':
			    case '2':
			    case '3':
			    case '4':
				if (count > 0 &&
				   (*disr_skip)(stream, (size_t)count) == count)
				        return (DIS_EOD);
				break;
			    default:
				return (DIS_NONDIGIT);
			}
		}
		*ldval = negate ? -fpnum : fpnum;
		return (DIS_SUCCESS);
	    case '0':
		return (DIS_LEADZRO);
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
		unum = c - '0';
		if (count > 1) {
			if ((*dis_gets)(stream, dis_buffer + 1, count - 1) !=
								count - 1)
			        return (DIS_EOD);
			cp = dis_buffer;
			if (count >= dis_umaxd) {
				if (count > dis_umaxd)
				        break;
				*cp = c;
				if (memcmp(dis_buffer, dis_umax, dis_umaxd) > 0)
				        break;
			}
			while (--count) {
				if ((c = *++cp) < '0' || c > '9')
				        return (DIS_NONDIGIT);
				unum = unum * 10 + (unsigned)(c - '0');
			}
		}
		return (disrl_(stream, ldval, ndigs, nskips, sigd, unum));
	    case -1:
		return (DIS_EOD);
	    case -2:
		return (DIS_EOF);
	    default:
		return (DIS_NONDIGIT);
	}
	*ldval = HUGE_VAL;
	return (DIS_OVERFLOW);
}
