/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
 
static char ident[] = "@(#) $RCSfile: dec_CpyFil.c,v $ $Revision: 2.1 $";

/*
 * decode_DIS_CopyFiles() - decode a Copy Files Dependency Batch Request
 *
 *	This request is used by the server ONLY. 
 *	The batch request structure pointed to by preq must already exist.
 *
 *	Data items are:	string		job id			(may be null)
 *			string		job owner		(may be null)
 *			string		execution user name
 *			string		execution group name	(may be null)
 *			unsigned int	direction	
 *			unsigned int	count of file pairs in set
 *			set of		file pairs:
 *				unsigned int	flag
 *				string		local path name
 *				string		remote path name (may be null)
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include <stdlib.h>
#include "libpbs.h"
#include "list_link.h"
#include "server_limits.h"
#include "attribute.h"
#include "credential.h"
#include "batch_request.h"
#include "dis.h"

int decode_DIS_CopyFiles(sock, preq)
	int   sock;
	struct batch_request *preq;
{
	int   pair_ct;
	struct rq_cpyfile *pcf;
	struct rqfpair    *ppair;
	int   rc;

	pcf = &preq->rq_ind.rq_cpyfile;
	CLEAR_HEAD(pcf->rq_pair);
	if ((rc = disrfst(sock, PBS_MAXSVRJOBID, pcf->rq_jobid)) != 0)
		return rc;
	if ((rc = disrfst(sock, PBS_MAXUSER, pcf->rq_owner)) != 0)
		return rc; 
	if ((rc = disrfst(sock, PBS_MAXUSER, pcf->rq_user))  != 0)
		return rc;
	if ((rc = disrfst(sock, PBS_MAXGRPN, pcf->rq_group)) != 0)
		return rc;
	pcf->rq_dir = disrui(sock, &rc);
	if (rc) return rc;
	
	pair_ct = disrui(sock, &rc);
	if (rc) return rc;

	while (pair_ct--) {

		ppair = (struct rqfpair *)malloc(sizeof (struct rqfpair));
		if (ppair == (struct rqfpair *)0)
			return DIS_NOMALLOC;
		CLEAR_LINK(ppair->fp_link);
		ppair->fp_local = 0;
		ppair->fp_rmt   = 0;

		ppair->fp_flag = disrui(sock, &rc);
		if (rc) {
			(void)free(ppair);
			return rc;
		}
		ppair->fp_local = disrst(sock, &rc);
		if (rc) {
			(void)free(ppair);
			return rc;
		}
		ppair->fp_rmt = disrst(sock, &rc);
		if (rc) {
			(void)free(ppair->fp_local);
			(void)free(ppair);
			return rc;
		}
		append_link(&pcf->rq_pair, &ppair->fp_link, ppair);
	}
	return 0;
}
