/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
 
static char ident[] = "@(#) $RCSfile: enc_svrattrl.c,v $ $Revision: 2.1 $";

/*
 * encode_DIS_svrattrl() - encode a list of server "svrattrl" structures
 *
 *	The first item encoded is a unsigned integer, a count of the
 *	number of svrattrl entries in the linked list.  This is encoded
 *	even when there are no svrattrl entries in the list.
 *
 *	Each individual entry is then encoded as:
 *		u int	size of the three strings (name, resource, value)
 *			including the terminating nulls
 *		string	attribute name
 *		u int	1 or 0 if resource name does or does not follow
 *		string	resource name (if one)
 *		string  value of attribute/resource
 *		u int	"op" of attrlop
 *
 *	Note, the encoding of a svrattrl is the same as the encoding of
 *	the pbs_ifl.h structures "attrl" and "attrlop".  Any one of the 
 *	three forms can be decoded into any of the three with the possible
 *	loss of the "flags" field (which is the "op" of the attrlop).
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include "libpbs.h"
#include "list_link.h"
#include "attribute.h"
#include "dis.h"

int encode_DIS_svrattrl(sock, psattl)
	int	  sock;
	svrattrl *psattl;
{
	unsigned int ct = 0;
	unsigned int name_len;
	svrattrl *ps;
	int rc;

	/* count how many */

	for (ps = psattl; ps; ps = (svrattrl *)GET_NEXT(ps->al_link)) {
		++ct;
	}

	if (rc = diswui(sock, ct))
		return rc;

	for (ps = psattl; ps; ps = (svrattrl *)GET_NEXT(ps->al_link)) {
		/* length of three strings */
		name_len = (int)strlen(ps->al_atopl.name) +
			   (int)strlen(ps->al_atopl.value) + 2;
		if (ps->al_atopl.resource)
			name_len += strlen(ps->al_atopl.resource) + 1;

		if (rc = diswui(sock, name_len))
			break;
		if (rc = diswst(sock, ps->al_atopl.name))
			break;
		if (ps->al_rescln) {	/* has a resource name */
			if (rc = diswui(sock, 1))
				break;
			if (rc = diswst(sock, ps->al_atopl.resource))
				break;
		} else {
			if (rc = diswui(sock, 0))	/* no resource name */
				break;
		}
		if ( (rc = diswst(sock, ps->al_atopl.value))	||
		     (rc = diswui(sock, (unsigned int)ps->al_op)) )
			break;
	}
	return rc;
}
