/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include <string.h>
#include "portability.h"
#include "list_link.h"
#include "attribute.h"
#include "server_limits.h"
#include "queue.h"
#include "job.h"
#include "log.h"

static char ident[] = "@(#) $RCSfile: site_check_u.c,v $ $Revision: 2.2 $";

/* Global Data Items */

extern char *pbs_o_host;
extern char  server_host[];
extern char *msg_orighost;	/* error message: no PBS_O_HOST */

/*
 * site_check_u - site_check_user_map()
 *
 *	This routine determines if a user is privileged to execute a job
 *	on this host under the login name specified (in user-list attribute)
 *
 *	As provided, this routine uses ruserok(3N).  If this is a problem,
 *	It's replacement is "left as an exersize for the reader."
 */

int site_check_user_map(pjob, luser)
	job	*pjob;	
	char	*luser;
{
	char    *orighost;
	char	 owner[PBS_MAXUSER+1];
	char	*p1;
	char	*p2;
	int	 rc;
	
	/* get just the owner name, without the "@host" */
	
	p1 = pjob->ji_wattr[JOB_ATR_job_owner].at_val.at_str;
	p2 = owner;
	while ((*p1 != '@') && (*p1 != '\0'))
		*p2++ = *p1++;
	*p2 = '\0';

	orighost = get_variable(pjob, pbs_o_host);
	if (orighost == (char *)0) {
		log_event(PBSEVENT_JOB, PBS_EVENTCLASS_JOB, 
			  pjob->ji_qs.ji_jobid, msg_orighost);
		return (-1);
	}
	if ( !strcmp(orighost, server_host) && !strcmp(owner, luser))
		return (0);

	rc =   ruserok(orighost, 0, owner, luser);
#ifdef sun
	/* broken Sun ruserok() sets process so it appears to be owned	*/
	/* by the luser, change it back for cosmetic reasons		*/
	setuid(0);
#endif	/* sun */
	return (rc);
}

/*
 * site_check_u - site_acl_check()
 *
 *    This routine is a place holder for sites that wish to implement
 *    access controls that differ from the standard PBS user, group, host
 *    access controls.  It does NOT replace their functionality.
 *
 *    Return -1 for access denied, otherwise 0 for ok.
 */

int site_acl_check(pjob, pque)
	job		*pjob;
	pbs_queue	*pque;
{
	return (0);
}
