/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*************************************************************
*      myname           CodeGen.h
*      created          12/18/1996
*      updated          12/18/1996
*      works            xx/1996
*
*		designer		rrs/1996
*************************************************************/

/***********************************************************
*
*	               OPERATION OVERVIEW
*
*
************************************************************/
#ifndef _CODEGEN_H
#define _CODEGEN_H
/* Feature test switches */
#ifndef _POSIX_SOURCE
#define _POSIX_SOURCE 1
#endif  /* _POSIX_SOURCE */

#if __STDC__ == 1
/*
 * The following macro definations take affect when compiling under ansi C
 *
 * The A_ macro is provided for function prototype declarations.  It allows
 * ANSI C prototypes to be complied under K&R C
 */

#define A_(x) x

#else
/* The following macro definations take affect when compiling under K&R C */

#define const
#define volatile
#define A_(x) ()

#endif  /* __STDC__ */

#include "List.h"

struct Stack
{
	Np     np;
        struct Stack *rptr;
};
typedef struct Stack *St;
 
/*prototypes*/

extern void
CodeGenInit A_((void));

extern void
CodeGenPutDF A_((int df));

extern void
CodeGenCondPrint A_((char *str));

extern void
CodeGenPrint A_((void));

extern void
CodeGenErr A_((int e));

extern void
CodeGenBuffClear A_((void));

extern void
CodeGenBuffPrint A_((void));

extern void
CodeGenBuffEmit A_((void));

extern void
CodeGenBuffSwitchEmit A_((void));

extern void
CodeGenBuffSave A_((char *str));

extern void
CodeGenBuffSaveBefore A_((char *str, char *lexeme, int level));

extern void
CodeGenBuffSaveAfter A_((char *str, char *lexeme, int level));

extern void
CodeGenBuffSaveFirst A_((char *str));

extern void
CodeGenBuffSaveFun A_((char *str));

extern void
CodeGenBuffSaveFunBefore A_((char *str, char *lexeme, int level));

extern void
CodeGenBuffSaveFunAfter A_((char *str, char *lexeme, int level));

extern void
CodeGenBuffSaveFunFirst A_((char *str));

extern void
CodeGenStatPrint A_((void));

extern void
CodeGenStatPrintTail A_((struct MYTOK data));

extern void
CodeGenDefSimple A_((struct MYTOK data));

extern void
CodeGenProgHead A_((void));

extern int
CodeGenLastDef A_((char *lexeme));

extern void
CodeGenStackClear A_((void));

extern St
CodeGenStackNew A_((Np np));

extern void
CodeGenStackPush A_((Np	np));

extern Np
CodeGenStackPop A_((void));

extern void
CodeGenStackPrint A_((void));

extern void
CodeGenBuffSaveSpecOper A_((char *operstr));

extern Np
CodeGenBuffGetLast A_((void));

extern void
CodeGenBuffDelete A_((char *lexeme, int inst));

extern void
CodeGenBuffSaveStrAssign A_((void));

extern void
CodeGenBuffSaveForeach A_((struct MYTOK var, struct MYTOK svar));

extern void
CodeGenBuffSaveSwitch A_((struct MYTOK switchVar));

extern void
CodeGenBuffSaveSwitchIn A_((struct MYTOK switchVar, struct MYTOK caseVal));

extern void
CodeGenBuffSaveQueJobFind A_((void));

extern void
CodeGenBuffSaveQueFilter A_((void));

extern Np
CodeGenBuffGetNp A_(( char *lexeme, int lineDef ));
#endif /* _CODEGEN_H */
