/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*************************************************************
*      myname           Node.h
*      created          7/12/1996
*      updated          8/13/1996
*      works            8/13/1996
*
*************************************************************/
 
/*
 * This is header for the Node class emulated in C
 */
#ifndef _NODE_H
#define _NODE_H
/* Feature test switches */
#ifndef _POSIX_SOURCE
#define _POSIX_SOURCE 1
#endif  /* _POSIX_SOURCE */

#if __STDC__ == 1
/*
 * The following macro definations take affect when compiling under ansi C
 *
 * The A_ macro is provided for function prototype declarations.  It allows
 * ANSI C prototypes to be complied under K&R C
 */

#define A_(x) x

#else
/* The following macro definations take affect when compiling under K&R C */

#define const
#define volatile
#define A_(x) ()

#endif  /* __STDC__ */

#include "ParLexGlob.h"

struct FUNDESCR 
{
	int paramCnt;
	struct Node * paramPtr;
};

/*struct Node;*/
struct Node
{
	char lexeme[LEXEMSZ];
	int type;		/* Semantic type. If this is a function, then 
					retType. */
				 
	int lineDef;
	int level;
	int funFlag;		/* YES it is a function; otherwise NO */

	struct FUNDESCR funDescr;

	struct Node *rptr;
};
typedef struct Node *Np;

/*prototypes*/

extern void
NodePutDF A_((int df));

extern void
NodeCondPrint A_((char *str));

extern Np
NodeNew A_((char *lexem, int typ, int lin, int leve, int funFla));

extern void
NodePrint A_((Np xp));

extern void
NodePrint2 A_((Np xp));

extern void
NodeFunDescrPrint A_((Np nx));

extern Np
NodeFunDescrFindByLexeme A_((Np nx, char *lexem));

extern void
NodeInit A_((Np nx, char *lexem, int typ, int lin, int leve, int funFla));

extern int
NodeCmp A_((Np xp, char *lexem));

extern void
NodeErr A_((int e));

extern char *
NodeGetLexeme A_((Np nxp));

extern int
NodeGetType A_((Np nxp));

extern int
NodeGetLineDef A_((Np nxp));

extern int
NodeGetLevel A_((Np nxp));

extern int
NodeGetFunFlag A_((Np nxp));

extern int
NodeGetParamCnt A_((Np nxp));

extern Np
NodeGetParamPtr A_((Np nxp));

extern void
NodePutLexeme A_((Np nxp, char *lexem));

extern void
NodePutType A_((Np nxp, int typ));

extern void
NodePutLineDef A_((Np nxp, int lin));

extern void
NodePutLevel A_((Np nxp, int leve));

extern void
NodePutFunFlag A_((Np nxp, int funFla));

extern void
NodePutParamCnt A_((Np nxp, int paramCn));

extern void
NodePutParamPtr A_((Np nxp, Np paramPt));

extern void
NodeParamCntIncr A_((Np nxp));

extern void
NodeParamCntDecr A_((Np nxp));

#endif /* _NODE_H */
