/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*************************************************************
*      myname           ParLexGlob.h
*      created          7/15/1996
*      updated          8/6/1996
*      works            7/29/1996
*
*      designed			rrs/1996
*************************************************************/
#ifndef _PARLEXGLOB_H 
#define _PARLEXGLOB_H
/* Feature test switches */
#ifndef _POSIX_SOURCE
#define _POSIX_SOURCE 1
#endif  /* _POSIX_SOURCE */

#define YES_INT 2 /* funFlag: means func is internally def */
#define YES 1
#define NO 0
#define OTHER 0
#define CONST 1
#define VAR 2

#define LEXEMSZ 80

struct MYTOK
{
	char lexeme[LEXEMSZ];
	int line;
	int len;
	int type;	
	int varFlag; /* VAR, CONST, OTHER */
};

typedef struct MYTOK STRMYTOK;

/* The following defines must coincide */
/* with SymTabGlob.h entries. */
#define UNKNOWN 0
#define INTTYPE 1
#define FLOATTYPE 2
#define STRINGTYPE 3
#define STATUSTYPE 4
#define DAYOFWEEKTYPE 5
#define SERVERTYPE 6
#define QUETYPE 7
#define JOBTYPE 8
#define SIZETYPE 9
#define INTRANGETYPE 10
#define FLOATRANGETYPE 11
#define DAYOFWEEKRANGETYPE 12
#define SERVERSETTYPE 13
#define QUESETTYPE 14
#define JOBSETTYPE 15
#define SIZESETTYPE 16
#define PARAMTYPE 17
#define FUNTYPE 18
#define SERVERSTATETYPE 19
#define QUESTATETYPE 20
#define JOBSTATETYPE 21
#define SIZESTATETYPE 22
#define DATETIMETYPE 23
#define CNODETYPE 24
#define VOIDTYPE 25
#define DATETIMERANGETYPE 26
#define CNODESETTYPE 27
#define SIZERANGETYPE 28
#define GENERICTYPE 29
#define KEYWORDTYPE 30

#endif /* _PARLEXGLOB_H */
