/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
#ifndef _AF_CNODEMAP_H
#define _AF_CNODEMAP_H
/* Feature test switches */
#ifndef _POSIX_SOURCE
#define _POSIX_SOURCE 1
#endif  /* _POSIX_SOURCE */

/* System headers */

/* Local Headers */
#include "af.h"
#include "af_cnode.h"
/* Macros */
#define INT_TYPE 0
#define STR_TYPE 1
#define FLT_TYPE 2
#define SIZE_TYPE  3

/* types of resources */
#define STATIC_RESOURCE 	10
#define DYNAMIC_RESOURCE 	20

struct CNodeAttrInfo {
	char 	*name;	    	    /* name of a CNode struct member */
        int     type;	    	    /* attribute type */
	void	(*attrPutFunc)();   /* the CNodePut function for attribute */
};

struct Resource {
        char *archType;
        char *nodeAttr;
        char *hostQuery_keyword;
};

/* This maps attributes whose values usually do not change over time */
static struct CNodeAttrInfo static_attrinfo_map[] = {
{"CNodePropertiesGet", 		STR_TYPE,	CNodePropertiesPut	},
{"CNodeVendorGet", 		STR_TYPE, 	CNodeVendorPut		},
{"CNodeOsGet", 			STR_TYPE, 	CNodeOsPut		},
{"CNodeNumCpusGet", 		INT_TYPE, 	CNodeNumCpusPut		},
{"CNodeMemTotalGet[]", 		SIZE_TYPE, 	CNodeMemTotalPut    	},
{"CNodeNetworkBwGet[]", 	INT_TYPE, 	CNodeNetworkBwPut    	},
{"CNodeSwapSpaceTotalGet[]", 	SIZE_TYPE, 	CNodeSwapSpaceTotalPut  },
{"CNodeDiskSpaceTotalGet[]", 	SIZE_TYPE, 	CNodeDiskSpaceTotalPut  },
{"CNodeDiskInBwGet[]", 		INT_TYPE, 	CNodeDiskInBwPut	},
{"CNodeDiskOutBwGet[]", 	INT_TYPE, 	CNodeDiskOutBwPut	},
{"CNodeTapeSpaceTotalGet[]", 	SIZE_TYPE, 	CNodeTapeSpaceTotalPut  },
{"CNodeTapeInBwGet[]", 		INT_TYPE, 	CNodeTapeInBwPut	},
{"CNodeTapeOutBwGet[]", 	INT_TYPE, 	CNodeTapeOutBwPut	},
{"CNodeSrfsSpaceTotalGet[]", 	SIZE_TYPE, 	CNodeSrfsSpaceTotalPut  },
{"CNodeSrfsInBwGet[]", 		INT_TYPE, 	CNodeSrfsInBwPut	},
{"CNodeSrfsOutBwGet[]", 	INT_TYPE, 	CNodeSrfsOutBwPut	},
{NULL,			-1,             NULL	}
};

/* This maps attributes whose values usually change over time */
static struct CNodeAttrInfo dynamic_attrinfo_map[] = {
{"CNodeIdletimeGet", 	INT_TYPE, 	CNodeIdletimePut		},
{"CNodeCpuPercentIdleGet",  INT_TYPE, 	CNodeCpuPercentIdlePut		},
{"CNodeCpuPercentSysGet",   INT_TYPE, 	CNodeCpuPercentSysPut		},
{"CNodeCpuPercentUserGet",  INT_TYPE, 	CNodeCpuPercentUserPut		},
{"CNodeCpuPercentGuestGet", INT_TYPE, 	CNodeCpuPercentGuestPut		},
{"CNodeMemAvailGet[]", 	SIZE_TYPE, 	CNodeMemAvailPut    		},
{"CNodeLoadAveGet", 	FLT_TYPE, 	CNodeLoadAvePut			},
{"CNodeSwapSpaceAvailGet[]", 	SIZE_TYPE, 	CNodeSwapSpaceAvailPut  },
{"CNodeSwapInBwGet[]", 	INT_TYPE, 	CNodeSwapInBwPut   		},
{"CNodeSwapOutBwGet[]", INT_TYPE, 	CNodeSwapOutBwPut   		},
{"CNodeDiskSpaceAvailGet[]", 	SIZE_TYPE, 	CNodeDiskSpaceAvailPut  },
{"CNodeDiskSpaceReservedGet[]", SIZE_TYPE, 	CNodeDiskSpaceReservedPut },
{"CNodeTapeSpaceAvailGet[]", 	SIZE_TYPE, 	CNodeTapeSpaceAvailPut    },
{"CNodeSrfsSpaceAvailGet[]", 	SIZE_TYPE, 	CNodeSrfsSpaceAvailPut    },
{"CNodeSrfsSpaceReservedGet[]",	SIZE_TYPE, 	CNodeSrfsSpaceReservedPut },
{NULL,			-1,		NULL  				  }
};

/* External Functions */
extern int
nodeAttrCmpNoTag A_((char *attr1, char *attr2));

extern char *
parseAttrForTag A_((char *attName));

extern char *
getStaticAttrAtIndex A_((int index, int *type, void (**putfunc)()));

extern char *
getDynamicAttrAtIndex A_((int index, int *type, void (**putfunc)()));

extern int
getAttrType A_((char *attName));

extern void
(*getAttrPutFunc A_((char *attName)))();

extern int
getAttrVectorFlg A_((char *attName));

extern void
attrInfoMapPrint A_((void));

/* Res stuff */
extern int
addRes A_((char *archType, char *nodeAttr, char *hostQuery));

extern struct Resource **
getResPtr A_((char *archType, char *nodeAttr));

extern char *
getNodeAttrGivenResPtr A_((struct Resource *resptr));

extern char *
getHostQueryKeywordGivenResPtr A_((struct Resource *resptr));

extern void
ResPrint A_((void));

extern void
ResFree A_((void));

#endif 	/* _AF_CNODEMAP_H */
