/* $Id: byte2val.c,v 1.1 1999/11/15 23:34:45 hender Exp $ */

#include <sys/types.h>
#include <stdio.h>

/*
 * byte2val(bytes)
 *
 * Return a pointer to a static string that is the shortest string by which
 * the number of bytes can be accurately represented. i.e.:
 *
 *	1023			-> 1023b
 *	16384			-> 16kb
 *	1048576			-> 1mb
 *	16777216		-> 16mb
 *	16777217		-> 16777217b
 *	34359738368		-> 32gb
 */

char *
schd_byte2val(size_t bytes)
{
    size_t  mult      = 1;	/* Initial multiplier */
    int     log_1024  = 0;	/* logarithm base 1024 of multiplier */

    size_t  next_mult = 1024;	/* multiplier of next-highest unit */

    static char string[32];

    char   *units[] = { 
	"b", 		/* bytes     */
	"kb", 		/* kilobytes */
	"mb", 		/* megabytes */
	"gb", 		/* gigabytes */
	"tb", 		/* terabytes */
	"pb", 		/* petabytes */
	"eb"		/* exabytes  */
    };

    /*
     * Find the first multiplier by which the given byte count is not 
     * evenly divisible.  If we overflow the next multiplier, we have
     * gone far enough.
     */
    while (bytes && (bytes % next_mult) == 0) {
	mult = next_mult;
	next_mult <<= 10;
	log_1024 ++;

	if (next_mult == 0)
	    break;
    }

    /*
     * Make 'bytes' be the number of units being represented.
     */
    bytes /= mult;

    /*
     * Create a string from number of units, and the symbol for that unit.
     */
    sprintf(string, "%lu%s", bytes, units[log_1024]);

    /*
     * Remember: this is a static string!
     */
    return (string);
}
