/* $Id: comment.c,v 1.1 1999/11/15 23:34:45 hender Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <pbs_error.h>
#include <pbs_ifl.h>
#include <log.h>

#include "toolkit.h"
#include "gblxvars.h"

extern int connector;

static int schd_alterserver(int sv_conn, char *name, char *value);
int schd_alterjob(int sv_conn, Job *job, char *name, char *value, 
				char *resource);

/*
 * Record the reason that the current candidate job cannot currently run.
 * When it is decided that the job will remain queued, place the reason 
 * string in the comment field of the job structure.
 */
void 
schd_comment_job(Job *job, char *reason, int optional)
{
    char   *id = "schd_comment_job";
    char   *msg_ptr;
    char   *old_msg;

    /*
     * If the 'optional' argument is true, then this comment is optional.
     * Do not bother commenting this job if this is not the first time it
     * has been seen, and it has been recently modified (hopefully it was
     * a comment change).  If there is no comment for the job, comment it
     * this time.
     */
    if (optional &&
	(!schd_FirstRun) &&
	(job->comment != NULL) &&
	!(job->flags & JFLAGS_FIRST_SEEN) && 
	(MIN_COMMENT_AGE && ((schd_TimeNow - job->mtime) < MIN_COMMENT_AGE)))
    {
	return;
    }

    if (reason == NULL)
	msg_ptr = "";
    else
	msg_ptr = reason;

    old_msg = job->comment;

    /* If there is no old message, or they are different, set it. */
    if ((old_msg == NULL) || (strcmp(msg_ptr, old_msg) != 0)) {

	/* Alter PBS' view of the job. */
	schd_alterjob(connector, job, ATTR_comment, msg_ptr, NULL);

	/* Copy the new comment into the job field. */
	if (job->comment)
	    free(job->comment);
	job->comment = schd_strdup(msg_ptr);
	
	if (job->comment == NULL) {
	    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id,
		"schd_strdup(job->comment)");
	    return;
	}
    }

    return;
}

void 
schd_comment_server(char *reason)
{
    char   *id = "schd_comment_server";
    char   *msg_ptr;
    static char *old_msg = NULL;

    if (reason == NULL)
	msg_ptr = "";
    else
	msg_ptr = reason;

    if (old_msg == NULL) {
	old_msg = (char *)malloc(MAX_TXT);
	if (old_msg == NULL) {
	    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id,
		"malloc(old_msg)");
	    return;
	}	    
	old_msg[0] = '\0';
    }

    if (strncmp(msg_ptr, old_msg, MAX_TXT - 1) != 0) {
	schd_alterserver(connector, ATTR_comment, msg_ptr);
	strncpy(old_msg, msg_ptr, MAX_TXT - 1);
    }

    return;
}

/* Alter a job's actual attributes. */
int 
schd_alterjob(int sv_conn, Job *job, char *name, char *value, char *rsrc)
{
    char   *id = "schd_alterjob";
    int     err;
    AttrList atp;

    if (schd_TEST_ONLY) {
	DBPRT(("%s: Would have altered job %s:\n", id, job->jobid));
	DBPRT(("%s: rsrc: %s, name: %s, value: %s\n", id, 
	    rsrc ? rsrc : "(NULL)", 
	    name ? name : "(NULL)", 
	    value ? value : "(NULL)"));
	return 0;
    }

    /* Fill the attribute structure with function parameters */
    atp.resource = rsrc;
    atp.value    = value;
    atp.name     = name;
    atp.next     = NULL;

    err = pbs_alterjob(sv_conn, job->jobid, &atp, NULL);

    if (err) {
	(void)sprintf(log_buffer, 
	    "pbs_alterjob(%s, %s, %s, %s) failed: %d", 
	    job->jobid, name, value, rsrc, pbs_errno);
	log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
    }

    return (err);
}

static int
schd_alterserver(int sv_conn, char *name, char *value)
{
    char   *id = "schd_alterserver";
    int     err;
    AttrOpList alist;

    if (schd_TEST_ONLY) {
	DBPRT(("%s: Would have altered server %d:\n", id, sv_conn));
	DBPRT(("%s: name: %s, value: %s\n", id, 
	    name ? name : "(NULL)", 
	    value ? value : "(NULL)"));
	return 0;
    }

    /* Fill in the attribute struct with appropriate parameters */

    alist.resource = NULL;
    alist.value    = value;
    alist.name     = name;
    alist.next     = NULL;
    alist.op       = SET;

    err = pbs_manager(sv_conn, MGR_CMD_SET, MGR_OBJ_SERVER, "", &alist, 
	NULL);
    
    if (err) {
	(void)sprintf(log_buffer, 
	    "pbs_alterserver(%s, %s) failed: %d", name, value, pbs_errno);
	log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
    }

    return (err);
}
