/* $Id: evaluate_system.c,v 1.1 1999/11/15 23:34:47 hender Exp $ */

/*
 * Perform some basic analysis of system resources to determine if 
 * jobs should be run.
 */

#include <stdio.h>
#include <stdlib.h>

/* PBS header files */
#include "pbs_error.h"
#include "pbs_ifl.h"
#include "log.h"

/*  Scheduler head files */
#include "toolkit.h"
#include "gblxvars.h"

#define DONT_START_JOB 0
#define	START_JOB 1

int
schd_evaluate_system(Resources *rsrcs, char *reason)
{
    double loadchk;

    if (rsrcs->nodes_alloc == rsrcs->nodes_total) {
	if (reason)
	    (void)sprintf(reason, "No nodes available to schedule");
	return (DONT_START_JOB);
    }

    /* Are there enough jobs running?  If not, start one. */
    if ((rsrcs->njobs < schd_MIN_JOBS) && schd_MIN_JOBS) {
	if (reason)
	    (void)sprintf(reason, "Not running enough jobs (%d/%d min)",
		rsrcs->njobs, schd_MIN_JOBS);
	return (START_JOB);
    }

    /* Are there too many jobs running?  If so, don't start one. */
    if ((rsrcs->njobs >= schd_MAX_JOBS) && schd_MAX_JOBS) {
	if (reason)
	    (void)sprintf(reason, "Maximum number of jobs running (%d/%d max)",
		rsrcs->njobs, schd_MAX_JOBS);
	return (DONT_START_JOB);
    }

    /*
     * If system time is high and we are permitting deferred jobs then 
     * change our mind and don't permit deferred jobs.  The high system 
     * time could be a short duration anomaly due to several jobs all 
     * doing I/O.  However, we should let regular jobs start if we are 
     * taking idle time.
     */
    if ((rsrcs->systime >= schd_HIGH_SYSTIME) && schd_HIGH_SYSTIME) {
	if (reason)
	    (void)sprintf(reason, "High system time (%d/%d max)",
		rsrcs->systime, schd_HIGH_SYSTIME);
	return (DONT_START_JOB);
    }

    if (reason)
	(void)sprintf(reason, "Done.  Don't need to run any jobs.");

    /*
     *  If we reached here, then we really don't need to start 
     *  another job.  If we do, then the system could become over
     *  burdened with work.
     */
    return (DONT_START_JOB);
}
