/* $Id: gblxvars.h,v 1.1 1999/11/15 23:34:48 hender Exp $ */

#ifndef GBLXVARS_H_
#define GBLXVARS_H_

#include <signal.h>
#include <time.h>

extern Resources *schd_RsrcsList;	/* Execution host resource list */

/* Queue lists */
extern QueueList *schd_SubmitQueue;	/* Job submission queue.	*/
extern QueueList *schd_BatchQueues;	/* Job execution queues.	*/
extern QueueList *schd_DedQueues;	/* Dedicated time queues.	*/

/*
 * The list of jobs on the system.  Jobs will be removed from this
 * list and placed onto the per-queue lists as they are initialized.
 * Anything remaining on this list belongs to a queue in which the
 * scheduler is not interested.
 */

extern Job *schd_AllJobs;

extern Alloc_Group schd_GroupTable[];

/* True if this is the first run since reconfiguration. */
extern int schd_FirstRun;

/* Scheduler Configuration Parameters */
extern int schd_TEST_ONLY;
extern int schd_AVOID_FRAGS;
extern int schd_SORT_BY_PAST_USAGE;
extern time_t schd_ENFORCE_PRIME_TIME;
extern int schd_NONPRIME_DRAIN_SYS;
extern time_t schd_NP_DRAIN_BACKTIME;
extern time_t schd_NP_DRAIN_IDLETIME;
extern time_t schd_PRIME_TIME_START;
extern time_t schd_PRIME_TIME_END;
extern time_t schd_PT_SMALL_NODE_LIMIT;
extern time_t schd_PT_SMALL_WALLT_LIMIT;
extern time_t schd_PT_WALLT_LIMIT;
extern time_t schd_SMALL_JOB_MAX;
extern time_t schd_WALLT_LARGE_LIMIT;
extern time_t schd_WALLT_SMALL_LIMIT;
extern int schd_TARGET_LOAD_PCT;
extern int schd_TARGET_LOAD_MINUS;
extern int schd_TARGET_LOAD_PLUS;
extern int schd_HIGH_SYSTIME;
extern int schd_MAX_JOBS;
extern int schd_MIN_JOBS;
extern int schd_MAX_DEDICATED_JOBS;
extern int schd_MAX_USER_RUN_JOBS;
extern int schd_USAGE_WEIGHT;
extern int schd_NODES_WEIGHT;
extern int schd_TIMEQ_WEIGHT;
extern int schd_MAX_NCPUS;

extern char *schd_SERVER_HOST;
extern char *schd_SCHED_HOST;
extern time_t schd_ENFORCE_ALLOCATION;
extern time_t schd_ENFORCE_DEDTIME;
extern int schd_DEDTIME_CACHE_SECS;
extern char *schd_SCHED_ACCT_DIR;
extern char *schd_DEDTIME_COMMAND;
extern char *schd_SYSTEM_NAME;
extern char *schd_JOB_DUMPFILE;
extern char *schd_SpecialQueue;
extern char *schd_ChallengeQueue;
extern char *schd_BackgroundQueue;

#define SCHD_RESTART_NONE	0
#define SCHD_RESTART_RESUBMIT	1
#define SCHD_RESTART_RERUN	2
extern int schd_SCHED_RESTART_ACTION;

/*
 * Pretend this machine is this many times as large as the real numbers
 * returned by resmom indicate.  I.e. to treat a 4-node box as a 64, set
 * FAKE_MACHINE_MULT to '16'.
 */
extern int schd_FAKE_MACH_MULT;

extern int schd_NeedToGetAllocInfo;
extern int schd_NeedToGetYTDInfo;
extern int schd_NumAllocation;
extern time_t schd_TimeNow;
extern time_t schd_TimeLast;
extern time_t schd_TimeChk;
extern struct tm schd_TmNow;
extern char *schd_CfgFilename;
extern char *schd_AllocFilename;
extern char *schd_CurrentFilename;

/* Global Variables added for User/Job Sorting - JJPJ */
extern int schd_NeedToGetDecayInfo; 
extern time_t schd_MAX_QUEUED_TIME;
extern time_t schd_SMALL_QUEUED_TIME;
extern time_t schd_INTERACTIVE_LONG_WAIT;
extern double schd_DECAY_FACTOR;
extern double schd_OA_DECAY_FACTOR;

/* 
 * Flags to prevent reconfiguration due to HUP while working. 
 */
#define SCHD_SIGFLAGS_BUSY		(1)
#define SCHD_SIGFLAGS_RECONFIG		(1 << 1)
extern volatile sig_atomic_t schd_sigflags;

extern char schd_ThisHost[];

#ifndef ALLOC_1ST
#define ALLOC_1ST 64
#endif /* !ALLOC_1ST */
#ifndef ALLOC_INC
#define ALLOC_INC 32
#endif /* !ALLOC_INC */

#endif /* ! GBLXVARS_H_ */
