/* $Id: getat.c,v 1.1 1999/11/15 23:34:48 hender Exp $ */

/*
 * Given a batch_status structure (bs), search the attributes for the 
 * requested attribute (at) and return it's value (v).  If the attribute 
 * contains a resource list, then search the resource list for the requested
 * resource (rs).  The function returns the value if found or a NULL if 
 * the search is not successful.
 */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pbs_ifl.h"
#include "log.h"
#include "toolkit.h"
#include "gblxvars.h"

char *
schd_getat(char *at, Batch_Status *bs, char *rs)
{
    /* char   *id = "getat"; */
    AttrList *a;

    for (a = bs->attribs; a != NULL; a = a->next) {
	/* Is this the attribute we are looking for? */
	if (!strcmp(at, a->name)) {

	    /*
	     * If no resource specified, OR this resource matches the 
	     * requested one, return a pointer to the attribute's value.
	     */
	    if ((rs == NULL) || (strcmp(rs, a->resource) == 0))
		return (a->value);
	}
    }

    return (NULL);	/* No matching attributes. */
}
