/* $Id: how_many.c,v 1.1 1999/11/15 23:34:50 hender Exp $ */

/*
 *  Given a state_count string, return the integer value
 *  of the state requested.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>

#include "toolkit.h"

int 
schd_how_many(char *str, char *state)
{
    /* char   *id = "how_many"; */
    char   *avalue, *ptr1;
    int     intval = 0;

    /* Make a duplicate of the string since strtok() is destructive. */
    avalue = schd_strdup(str);

    if (avalue == NULL)
	return (0);	/* XXX - return an error (malloc) here? */

    /* Search for a token that matches the requested state */
    for (ptr1 = strtok(avalue, " "); ptr1 != NULL; ptr1 = strtok(NULL, " "))
	if (!strncmp(state, ptr1, strlen(state)))
	    break;

    if (ptr1 == NULL)
	goto free_and_exit;	/* XXX return an error */

    /* Locate the number after the colon */
    ptr1 = strchr(ptr1, ':');

    if (ptr1 == NULL)
	goto free_and_exit;	/* XXX return an error? */

    ptr1++;
    intval = atoi(ptr1);

free_and_exit:
    free(avalue);		/* Free the memory schd_strdup() allocated. */

    return (intval);
}
