/* $Id: movejob.c,v 1.1 1999/11/15 23:34:51 hender Exp $ */

#include	<stdio.h>

/* PBS header files */
#include        "pbs_error.h"
#include        "pbs_ifl.h"
#include        "log.h"

/* Toolkit header files */
#include "toolkit.h"
#include "gblxvars.h"

/*
 * Move the internal representation of the given job from the list on its
 * queue to the tail of the destination queue's list.
 *
 * If the destination queue is NULL, this is equivalent to deleting the job
 * from the per-queue lists.
 */

int
schd_move_job_to(Job *thisjob, Queue *destq)
{
    Job    *prev, *tail;
    Queue  *srcq;

    srcq = thisjob->queue;

    if (srcq == NULL) {
	DBPRT(("move_job_to(Job %s, Queue %s) before job->queue init'd\n",
	    thisjob->jobid, destq ? destq->qname : "[dead]"));
	return (-1);
    }

    if (srcq->jobs == NULL) {
	DBPRT(("job %s says queue %s is owner, but joblist is NULL.\n",
	    thisjob->jobid, srcq->qname));
	return (-1);
    }

    /*
     * If the head of the source queue's job list is not the job in question,
     * walk down the list until we find the element before the job (i.e.
     * until the element's next pointer is equal to the job's pointer).
     */
    prev = NULL;

    if (srcq->jobs != thisjob) {
	for (prev = srcq->jobs; prev != NULL; prev = prev->next) {
	    if (prev->next == thisjob)
		break;
	}

	if (prev == NULL) {
	    DBPRT(("job %s says queue %s is owner, but not on queue joblist.\n",
		thisjob->jobid, srcq->qname));
	    return (-1);
	}
    }

    /* 
     * Remove the job from the source queue's list.  The previous pointer may
     * be NULL -- this indicates that the job is the head of the source list.
     * In that case, simply move the source queue's pointer forward and we're
     * done.  Otherwise, point the previous job's next pointer to skip over
     * this one.  Either way, the job is no longer a list, so set its next 
     * pointer to NULL.
     */
    if (prev == NULL)
	srcq->jobs = srcq->jobs->next;
    else
	prev->next = thisjob->next;
    thisjob->next = NULL;

    if (destq) {
	/*
	 * Append the job to the destination queue job list.  Like the source
	 * queue, a NULL pointer in queue->jobs indicates that the list is
	 * empty.  In this case, the detached job becomes the head of the
	 * list.  Otherwise, find the tail of the list and hook the new job
	 * onto the end of the list.
	 */
	if (destq->jobs == NULL) {
	    destq->jobs = thisjob;
	} else {
	    for (tail = destq->jobs; tail->next != NULL; tail = tail->next)
		/* do nothing -- just walk the list */ 
		;
	    tail->next = thisjob;
	}

	/* Make the destination the owner of the job. */
	thisjob->queue = destq;

    } else {
	/*
	 * Moving to a NULL queue is a job deletion.  This job is no longer
	 * referenced on the source, so will be lost.  Free it's resources.
	 */

	schd_free_jobs(thisjob);
    }

    /*
     * Account for the moved job.  Decrement the appropriate counters on the
     * source queue, and increment them on the destination queue (if present)
     */

    switch (thisjob->state) {
    case 'R':
	srcq->running --;
	if (destq)
	    destq->running ++;
	break;
    
    case 'Q':
	srcq->queued --;
	if (destq)
	    destq->queued ++;
	break;

    default:	/* Do nothing.  Present for completeness. */
	break;
    }

    return (0);
}
