/* $Id: sec2val.c,v 1.1 1999/11/15 23:34:55 hender Exp $ */

/*
 * Convert seconds into "HH:MM:SS" format.  Note that the returned string
 * is a pointer to a static buffer.  The caller must copy the time string
 * into a holding buffer before the next call to sec2val() occurs.
 */

#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>

char   *
schd_sec2val(int seconds)
{
    /* char   *id = "sec2val"; */
    static char tval[16];

    int     hours   = 0;
    int     minutes = 0;

    /* Hours */
    if (seconds >= (60 * 60))
	hours = seconds / (60 * 60);

    seconds -= (hours * (60 * 60));

    /* Minutes */
    if (seconds >= 60)
	minutes = seconds / 60;

    /* Seconds */
    seconds -= (minutes * 60);

    (void)sprintf(tval, "%2.2d:%2.2d:%2.2d", hours, minutes, seconds);

    return (&tval[0]);
}
