/* $Id: user_limits.c,v 1.1 1999/11/15 23:34:55 hender Exp $ */

/*
 * There are two routines here.  The first, queue_limits(), evaluates the 
 * limits of a queue to see if the queue can support running another job.  
 * The other, user_limits(), evaluates a job against any imposed user 
 * limit for the specified queue.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/sysmacros.h>
#include <string.h>

/* PBS header files */

#include "pbs_error.h"
#include "pbs_ifl.h"
#include "log.h"

/* Scheduler header files */

#include "toolkit.h"
#include "gblxvars.h"

extern int connector;

static int user_running (Queue *queue, char *user);

/*
 * Given a user batch request and a queue name, evaluate the job against 
 * limits retrieved from the queue_limits() routine.
 */
int 
schd_user_limits(Job *job, Queue *queue, char *reason)
{
    /* char   *id = "schd_user_limits"; */
    int     jobs_running;

    /*
     * If there is a user run limit, make sure the user is under their limit.
     */

    if ((queue->userrun != UNSPECIFIED) && queue->userrun) {
	jobs_running = user_running (queue, job->owner);

	/* See if run limit will be exceeded */
	if ((jobs_running != UNSPECIFIED) && 
	    (jobs_running >= queue->userrun)) 
	{
	    if (reason)
		sprintf(reason, "Would exceed queue %s userrun limit (%d)",
		    queue->qname, queue->userrun);
	    return (-1);
	}
    }

    /* If the queue has a maximum node limit, enforce it. */
    if ((queue->nodes_max != UNSPECIFIED) && queue->nodes_max) {

	/* Will this job exceed the queue node limit? */
	if ((job->nodes + queue->nodes_assn) > queue->nodes_max) {
	    if (reason)
		sprintf(reason, "Would exceed queue %s node limit (%d)", 
		    queue->qname, queue->nodes_max);
	    return (-1);
	}
    }

    /* If the job meets all the criteria above, it is runnable. */
    return (0);
}

static int
user_running(Queue *queue, char *user)
{
    char   *id = "user_running";
    Job    *job;
    int     jobs_running;

    DBPRT(("%s(%s, %s)\n", id, user, queue->qname));

    jobs_running = 0;

    /* 
     * Count the jobs in the queue's job list that are running and owned
     * by this user.
     */

    for (job = queue->jobs; job != NULL; job = job->next) {
	if ((job->state != 'R') && (!strcmp(job->owner, user)))
	    jobs_running++;
    }

    DBPRT(("    user %s has %d job%s running in queue '%s'\n", 
	user, jobs_running, jobs_running == 1 ? "" : "s", queue->qname));

    return (jobs_running);
}
