/* $Id: val2bool.c,v 1.1 1999/11/15 23:34:56 hender Exp $ */

/* 
 * This file uses strftime(3)/strptime(3), which are part of XPG4, 
 * but are not specified in the POSIX 1003.1 standard. 
 */
#ifdef	_POSIX_C_SOURCE
#undef	_POSIX_C_SOURCE
#endif	/* _POSIX_C_SOURCE */

#include <sys/param.h>
#include <sys/types.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "toolkit.h"

/*
 * Convert a boolean value (i.e. "True" or "False") to an int, where
 * the integer 1 represents a true value, and 0 represents non-true.
 */
int 
schd_val2bool(char *val, int *bool)
{
    /* char   *id = "val2bool"; */
    char   lower[64];

    /* Make a copy of the input string, and convert it to all lowercase. */
    strncpy(lower, val, sizeof(lower) - 1);
    schd_lowercase(lower);

    /* Test for a variety of "yes" values. */
    if ((strcmp(lower, "true") == 0) ||
        (strcmp(lower, "on") == 0) ||
        (strcmp(lower, "enabled") == 0) ||
        (strcmp(lower, "enable") == 0) ||
        (strcmp(lower, "yes") == 0) ||
        (strcmp(lower, "y") == 0) ||
        (strcmp(lower, "1") == 0))
    {
	*bool = 1;
	return (0);
    }

    /* Test for a variety of "no" values. */
    if ((strcmp(lower, "false") == 0) ||
        (strcmp(lower, "off") == 0) ||
        (strcmp(lower, "no") == 0) ||
        (strcmp(lower, "disabled") == 0) ||
        (strcmp(lower, "disable") == 0) ||
        (strcmp(lower, "n") == 0) ||
        (strcmp(lower, "0") == 0))
    {
	*bool = 0;
	return (0);
    }

    /* No free() necessary - lower is automatic array. */

    return (1);		/* Did not parse successfully. */
}

char * 
schd_bool2val(int bool)
{
    if (bool != 0)
	return "True";

    return "False";
}


#define	DATEFMT	"%m/%d/%Y@%H:%M:%S"	/* MM/DD/YYYY@HH:MM:SS */

/* 
 * Convert a string of the form MM/DD/YYYY@HH:MM:SS to a time_t.  Uses
 * strptime(3) function for parsing.
 */
int
schd_val2datetime(char *string, time_t *when)
{
    /* char   *id = "get_datetime"; */
    char   *remain;
    struct tm tm;
    time_t  then;

    /* Call the "inverse" of strftime(3) to parse the string. */
    remain = strptime(string, DATEFMT, &tm);

    /* Check for successful parsing of the date string in DATEFMT. */
    if (remain == NULL)
	return -1;

    /* Make sure the date@time was the only thing in the string. */
    if (*remain != '\0' && !isspace(*remain))
	return -1;

    /*
    * The struct tm now contains the right information.  Turn it into a
    * valid time_t.
    */
    then = mktime(&tm);
    if (then == (time_t) -1)
	return -1;

    /* Copy the time value and return success. */
    *when = then;

    return 0;
}
/*
 * Change a string into either a boolean (values 0 or 1), or a time_t if
 * the string gives a time in the format "MM/DD/YYYY@HH:MM:SS".
 */
int 
schd_val2booltime(char *val, time_t *t)
{
    int    ival;
    time_t tval;

    /* Try to parse into a boolean first. */
    if (schd_val2bool(val, &ival) == 0) {
	*t = (time_t) ival;
	return 0;
    }

    /* Not a boolean -- try for a date@time string. */
    if (schd_val2datetime(val, &tval) == 0) {
	*t = tval;
	return 0;
    }

    /* Not a valid boolean or date@time, so reject it. */
    return 1;
}

/*
 * Change an integer value into string containing either "True" or "False",
 * or (if the value > 1) a string containing the equivalent 'date@time' for
 * that value.
 * The time_t is overloaded in the case of being a boolean.
 */
char * 
schd_booltime2val(time_t bool)
{
    static char val[64];
    char   datetime[48];

    if ((bool == (time_t) 0) || (bool == (time_t) 1))
	return (schd_bool2val(bool));

    (void)strftime(datetime, sizeof(datetime) - 1, DATEFMT, localtime(&bool));

    if (time(NULL) >= bool)
	(void)sprintf(val, "%s (since %s)", schd_bool2val(1), datetime);
    else
	(void)sprintf(val, "%s (until %s)", schd_bool2val(0), datetime);

    return val;
}
