/* $Id: val2byte.c,v 1.1 1999/11/15 23:34:56 hender Exp $ */

/* Convert a an allocation value string to its equivalent value in bytes. */

#include <sys/param.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "toolkit.h"

/* Power-of-two unit multipliers. */
#define KILO ((size_t)1024)
#define MEGA (KILO*1024)
#define GIGA (MEGA*1024)
#define TERA (GIGA*1024)

size_t 
schd_val2byte(char *val)
{
    /* char   *id = "schd_val2byte"; */
    int     b = 0;
    size_t num = 0;
    char   *p;

    if (val == NULL)
	return (0);

    b = 0;
    num = 0;
    num = strtoul(val, &p, 0);

#if 0
    /* Dead code as of Feb 10, 1998.  Remove no later than Feb 10, 1999. */
    (void) sprintf(buffer,"1: val=[%s] num=%lld, p=[%s]",val,num,p);
    log_record(1,1,id,buffer);
#endif /* 0 */

    /* Now 'p' should point to first non-number character. */

    /* If no units given, return the number. */
    if ((p == val) || (*p == '\0'))
	return (num);	/* XXX return num if p == val? */

    /* Parse the given order of magnitude. */
    switch (*p) {
    case 'k':
    case 'K':
	num *= KILO;
	break;

    case 'm':
    case 'M':
	num *= MEGA;
	break;

    case 'g':
    case 'G':
	num *= GIGA;
	break;

    case 't':
    case 'T':
	num *= TERA;
	break;

    case 'b':
    case 'B':
	b++;
	break;

    default:
	return (-1);
    }

    /* XXX if (b && *p != '\0') return error. */

    /* Parse the word-size unit. */
    p++;
    if ((*p != '\0') && !b) {
	switch (*p) {
	case 'b':
	case 'B':
	    break;

	case 'w':
	case 'W':
	    num *= NBPW;	/* Multiply by size of word. */
	    break;

	default:
	    return (-1);
	}
    }

    /* Return the total number of bytes represented by the value. */
    return (num);
}
